<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XRemoteDestinationProfile StructType
 * @subpackage Structs
 */
class XRemoteDestinationProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The product
     * Meta information extracted from the WSDL
     * - documentation: Product ID string. read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $product;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - documentation: Class ID string. Class information is read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $class;
    /**
     * The protocol
     * Meta information extracted from the WSDL
     * - documentation: Protocol option is read-only,except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $protocol;
    /**
     * The protocolSide
     * Meta information extracted from the WSDL
     * - documentation: Side information is read-only except when creating a device
     * - default: User
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $protocolSide;
    /**
     * The devicePoolName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $devicePoolName;
    /**
     * The callInfoPrivacyStatus
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $callInfoPrivacyStatus;
    /**
     * The userId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $userId;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - documentation: Optional description of the device
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The callingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The networkHoldMohAudioSourceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $networkHoldMohAudioSourceId;
    /**
     * The userHoldMohAudioSourceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $userHoldMohAudioSourceId;
    /**
     * The lines
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\Lines
     */
    public $lines;
    /**
     * The ignorePresentationIndicators
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $ignorePresentationIndicators;
    /**
     * The rerouteCallingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $rerouteCallingSearchSpaceName;
    /**
     * The cgpnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $cgpnTransformationCssName;
    /**
     * The automatedAlternateRoutingCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $automatedAlternateRoutingCssName;
    /**
     * The useDevicePoolCgpnTransformCss
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCss;
    /**
     * The userLocale
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $userLocale;
    /**
     * The networkLocale
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $networkLocale;
    /**
     * The primaryPhoneName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $primaryPhoneName;
    /**
     * The dndOption
     * Meta information extracted from the WSDL
     * - default: Ringer Off
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $dndOption;
    /**
     * The dndStatus
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $dndStatus;
    /**
     * The mobileSmartClientProfileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $mobileSmartClientProfileName;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * Constructor method for XRemoteDestinationProfile
     * @uses XRemoteDestinationProfile::setName()
     * @uses XRemoteDestinationProfile::setProduct()
     * @uses XRemoteDestinationProfile::setClass()
     * @uses XRemoteDestinationProfile::setProtocol()
     * @uses XRemoteDestinationProfile::setProtocolSide()
     * @uses XRemoteDestinationProfile::setDevicePoolName()
     * @uses XRemoteDestinationProfile::setCallInfoPrivacyStatus()
     * @uses XRemoteDestinationProfile::setUserId()
     * @uses XRemoteDestinationProfile::setDescription()
     * @uses XRemoteDestinationProfile::setCallingSearchSpaceName()
     * @uses XRemoteDestinationProfile::setNetworkHoldMohAudioSourceId()
     * @uses XRemoteDestinationProfile::setUserHoldMohAudioSourceId()
     * @uses XRemoteDestinationProfile::setLines()
     * @uses XRemoteDestinationProfile::setIgnorePresentationIndicators()
     * @uses XRemoteDestinationProfile::setRerouteCallingSearchSpaceName()
     * @uses XRemoteDestinationProfile::setCgpnTransformationCssName()
     * @uses XRemoteDestinationProfile::setAutomatedAlternateRoutingCssName()
     * @uses XRemoteDestinationProfile::setUseDevicePoolCgpnTransformCss()
     * @uses XRemoteDestinationProfile::setUserLocale()
     * @uses XRemoteDestinationProfile::setNetworkLocale()
     * @uses XRemoteDestinationProfile::setPrimaryPhoneName()
     * @uses XRemoteDestinationProfile::setDndOption()
     * @uses XRemoteDestinationProfile::setDndStatus()
     * @uses XRemoteDestinationProfile::setMobileSmartClientProfileName()
     * @uses XRemoteDestinationProfile::setCtiid()
     * @param string $name
     * @param string $product
     * @param string $class
     * @param string $protocol
     * @param string $protocolSide
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName
     * @param string $callInfoPrivacyStatus
     * @param string $userId
     * @param string $description
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName
     * @param string $networkHoldMohAudioSourceId
     * @param string $userHoldMohAudioSourceId
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Lines $lines
     * @param string $ignorePresentationIndicators
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $rerouteCallingSearchSpaceName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName
     * @param string $useDevicePoolCgpnTransformCss
     * @param string $userLocale
     * @param string $networkLocale
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $primaryPhoneName
     * @param string $dndOption
     * @param string $dndStatus
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mobileSmartClientProfileName
     * @param int $ctiid
     */
    public function __construct($name = null, $product = null, $class = null, $protocol = null, $protocolSide = 'User', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName = null, $callInfoPrivacyStatus = 'Default', $userId = null, $description = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName = null, $networkHoldMohAudioSourceId = null, $userHoldMohAudioSourceId = null, \\Losc\CucmBundle\Model\Webservice\StructType\Lines $lines = null, $ignorePresentationIndicators = 'false', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $rerouteCallingSearchSpaceName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName = null, $useDevicePoolCgpnTransformCss = 'true', $userLocale = null, $networkLocale = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $primaryPhoneName = null, $dndOption = 'Ringer Off', $dndStatus = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mobileSmartClientProfileName = null, $ctiid = null)
    {
        $this
            ->setName($name)
            ->setProduct($product)
            ->setClass($class)
            ->setProtocol($protocol)
            ->setProtocolSide($protocolSide)
            ->setDevicePoolName($devicePoolName)
            ->setCallInfoPrivacyStatus($callInfoPrivacyStatus)
            ->setUserId($userId)
            ->setDescription($description)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId)
            ->setUserHoldMohAudioSourceId($userHoldMohAudioSourceId)
            ->setLines($lines)
            ->setIgnorePresentationIndicators($ignorePresentationIndicators)
            ->setRerouteCallingSearchSpaceName($rerouteCallingSearchSpaceName)
            ->setCgpnTransformationCssName($cgpnTransformationCssName)
            ->setAutomatedAlternateRoutingCssName($automatedAlternateRoutingCssName)
            ->setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss)
            ->setUserLocale($userLocale)
            ->setNetworkLocale($networkLocale)
            ->setPrimaryPhoneName($primaryPhoneName)
            ->setDndOption($dndOption)
            ->setDndStatus($dndStatus)
            ->setMobileSmartClientProfileName($mobileSmartClientProfileName)
            ->setCtiid($ctiid);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XRemoteDestinationProfile
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get product value
     * @return string
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param string $product
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XRemoteDestinationProfile
     */
    public function setProduct($product = null)
    {
        $this->product = $product;
        return $this;
    }
    /**
     * Get class value
     * @return string
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param string $class
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XRemoteDestinationProfile
     */
    public function setClass($class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get protocol value
     * @return string
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @param string $protocol
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XRemoteDestinationProfile
     */
    public function setProtocol($protocol = null)
    {
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get protocolSide value
     * @return string
     */
    public function getProtocolSide()
    {
        return $this->protocolSide;
    }
    /**
     * Set protocolSide value
     * @param string $protocolSide
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XRemoteDestinationProfile
     */
    public function setProtocolSide($protocolSide = 'User')
    {
        $this->protocolSide = $protocolSide;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XRemoteDestinationProfile
     */
    public function setDevicePoolName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get callInfoPrivacyStatus value
     * @return string
     */
    public function getCallInfoPrivacyStatus()
    {
        return $this->callInfoPrivacyStatus;
    }
    /**
     * Set callInfoPrivacyStatus value
     * @param string $callInfoPrivacyStatus
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XRemoteDestinationProfile
     */
    public function setCallInfoPrivacyStatus($callInfoPrivacyStatus = 'Default')
    {
        $this->callInfoPrivacyStatus = $callInfoPrivacyStatus;
        return $this;
    }
    /**
     * Get userId value
     * @return string
     */
    public function getUserId()
    {
        return $this->userId;
    }
    /**
     * Set userId value
     * @param string $userId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XRemoteDestinationProfile
     */
    public function setUserId($userId = null)
    {
        $this->userId = $userId;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XRemoteDestinationProfile
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return isset($this->callingSearchSpaceName) ? $this->callingSearchSpaceName : null;
    }
    /**
     * Set callingSearchSpaceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XRemoteDestinationProfile
     */
    public function setCallingSearchSpaceName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName = null)
    {
        if (is_null($callingSearchSpaceName) || (is_array($callingSearchSpaceName) && empty($callingSearchSpaceName))) {
            unset($this->callingSearchSpaceName);
        } else {
            $this->callingSearchSpaceName = $callingSearchSpaceName;
        }
        return $this;
    }
    /**
     * Get networkHoldMohAudioSourceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNetworkHoldMohAudioSourceId()
    {
        return isset($this->networkHoldMohAudioSourceId) ? $this->networkHoldMohAudioSourceId : null;
    }
    /**
     * Set networkHoldMohAudioSourceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $networkHoldMohAudioSourceId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XRemoteDestinationProfile
     */
    public function setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId = null)
    {
        if (is_null($networkHoldMohAudioSourceId) || (is_array($networkHoldMohAudioSourceId) && empty($networkHoldMohAudioSourceId))) {
            unset($this->networkHoldMohAudioSourceId);
        } else {
            $this->networkHoldMohAudioSourceId = $networkHoldMohAudioSourceId;
        }
        return $this;
    }
    /**
     * Get userHoldMohAudioSourceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserHoldMohAudioSourceId()
    {
        return isset($this->userHoldMohAudioSourceId) ? $this->userHoldMohAudioSourceId : null;
    }
    /**
     * Set userHoldMohAudioSourceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userHoldMohAudioSourceId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XRemoteDestinationProfile
     */
    public function setUserHoldMohAudioSourceId($userHoldMohAudioSourceId = null)
    {
        if (is_null($userHoldMohAudioSourceId) || (is_array($userHoldMohAudioSourceId) && empty($userHoldMohAudioSourceId))) {
            unset($this->userHoldMohAudioSourceId);
        } else {
            $this->userHoldMohAudioSourceId = $userHoldMohAudioSourceId;
        }
        return $this;
    }
    /**
     * Get lines value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\Lines|null
     */
    public function getLines()
    {
        return $this->lines;
    }
    /**
     * Set lines value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Lines $lines
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XRemoteDestinationProfile
     */
    public function setLines(\\Losc\CucmBundle\Model\Webservice\StructType\Lines $lines = null)
    {
        $this->lines = $lines;
        return $this;
    }
    /**
     * Get ignorePresentationIndicators value
     * @return string|null
     */
    public function getIgnorePresentationIndicators()
    {
        return $this->ignorePresentationIndicators;
    }
    /**
     * Set ignorePresentationIndicators value
     * @param string $ignorePresentationIndicators
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XRemoteDestinationProfile
     */
    public function setIgnorePresentationIndicators($ignorePresentationIndicators = 'false')
    {
        $this->ignorePresentationIndicators = $ignorePresentationIndicators;
        return $this;
    }
    /**
     * Get rerouteCallingSearchSpaceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getRerouteCallingSearchSpaceName()
    {
        return isset($this->rerouteCallingSearchSpaceName) ? $this->rerouteCallingSearchSpaceName : null;
    }
    /**
     * Set rerouteCallingSearchSpaceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $rerouteCallingSearchSpaceName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XRemoteDestinationProfile
     */
    public function setRerouteCallingSearchSpaceName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $rerouteCallingSearchSpaceName = null)
    {
        if (is_null($rerouteCallingSearchSpaceName) || (is_array($rerouteCallingSearchSpaceName) && empty($rerouteCallingSearchSpaceName))) {
            unset($this->rerouteCallingSearchSpaceName);
        } else {
            $this->rerouteCallingSearchSpaceName = $rerouteCallingSearchSpaceName;
        }
        return $this;
    }
    /**
     * Get cgpnTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCgpnTransformationCssName()
    {
        return isset($this->cgpnTransformationCssName) ? $this->cgpnTransformationCssName : null;
    }
    /**
     * Set cgpnTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XRemoteDestinationProfile
     */
    public function setCgpnTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName = null)
    {
        if (is_null($cgpnTransformationCssName) || (is_array($cgpnTransformationCssName) && empty($cgpnTransformationCssName))) {
            unset($this->cgpnTransformationCssName);
        } else {
            $this->cgpnTransformationCssName = $cgpnTransformationCssName;
        }
        return $this;
    }
    /**
     * Get automatedAlternateRoutingCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getAutomatedAlternateRoutingCssName()
    {
        return isset($this->automatedAlternateRoutingCssName) ? $this->automatedAlternateRoutingCssName : null;
    }
    /**
     * Set automatedAlternateRoutingCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XRemoteDestinationProfile
     */
    public function setAutomatedAlternateRoutingCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName = null)
    {
        if (is_null($automatedAlternateRoutingCssName) || (is_array($automatedAlternateRoutingCssName) && empty($automatedAlternateRoutingCssName))) {
            unset($this->automatedAlternateRoutingCssName);
        } else {
            $this->automatedAlternateRoutingCssName = $automatedAlternateRoutingCssName;
        }
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCss()
    {
        return $this->useDevicePoolCgpnTransformCss;
    }
    /**
     * Set useDevicePoolCgpnTransformCss value
     * @param string $useDevicePoolCgpnTransformCss
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XRemoteDestinationProfile
     */
    public function setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss = 'true')
    {
        $this->useDevicePoolCgpnTransformCss = $useDevicePoolCgpnTransformCss;
        return $this;
    }
    /**
     * Get userLocale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserLocale()
    {
        return isset($this->userLocale) ? $this->userLocale : null;
    }
    /**
     * Set userLocale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userLocale
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XRemoteDestinationProfile
     */
    public function setUserLocale($userLocale = null)
    {
        if (is_null($userLocale) || (is_array($userLocale) && empty($userLocale))) {
            unset($this->userLocale);
        } else {
            $this->userLocale = $userLocale;
        }
        return $this;
    }
    /**
     * Get networkLocale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNetworkLocale()
    {
        return isset($this->networkLocale) ? $this->networkLocale : null;
    }
    /**
     * Set networkLocale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $networkLocale
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XRemoteDestinationProfile
     */
    public function setNetworkLocale($networkLocale = null)
    {
        if (is_null($networkLocale) || (is_array($networkLocale) && empty($networkLocale))) {
            unset($this->networkLocale);
        } else {
            $this->networkLocale = $networkLocale;
        }
        return $this;
    }
    /**
     * Get primaryPhoneName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getPrimaryPhoneName()
    {
        return isset($this->primaryPhoneName) ? $this->primaryPhoneName : null;
    }
    /**
     * Set primaryPhoneName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $primaryPhoneName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XRemoteDestinationProfile
     */
    public function setPrimaryPhoneName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $primaryPhoneName = null)
    {
        if (is_null($primaryPhoneName) || (is_array($primaryPhoneName) && empty($primaryPhoneName))) {
            unset($this->primaryPhoneName);
        } else {
            $this->primaryPhoneName = $primaryPhoneName;
        }
        return $this;
    }
    /**
     * Get dndOption value
     * @return string|null
     */
    public function getDndOption()
    {
        return $this->dndOption;
    }
    /**
     * Set dndOption value
     * @param string $dndOption
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XRemoteDestinationProfile
     */
    public function setDndOption($dndOption = 'Ringer Off')
    {
        $this->dndOption = $dndOption;
        return $this;
    }
    /**
     * Get dndStatus value
     * @return string|null
     */
    public function getDndStatus()
    {
        return $this->dndStatus;
    }
    /**
     * Set dndStatus value
     * @param string $dndStatus
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XRemoteDestinationProfile
     */
    public function setDndStatus($dndStatus = null)
    {
        $this->dndStatus = $dndStatus;
        return $this;
    }
    /**
     * Get mobileSmartClientProfileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getMobileSmartClientProfileName()
    {
        return isset($this->mobileSmartClientProfileName) ? $this->mobileSmartClientProfileName : null;
    }
    /**
     * Set mobileSmartClientProfileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mobileSmartClientProfileName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XRemoteDestinationProfile
     */
    public function setMobileSmartClientProfileName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mobileSmartClientProfileName = null)
    {
        if (is_null($mobileSmartClientProfileName) || (is_array($mobileSmartClientProfileName) && empty($mobileSmartClientProfileName))) {
            unset($this->mobileSmartClientProfileName);
        } else {
            $this->mobileSmartClientProfileName = $mobileSmartClientProfileName;
        }
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XRemoteDestinationProfile
     */
    public function setCtiid($ctiid = null)
    {
        $this->ctiid = $ctiid;
        return $this;
    }
}
