<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XPhone StructType
 * @subpackage Structs
 */
class XPhone extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: The device name,using only URL-friendly characters
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The product
     * Meta information extracted from the WSDL
     * - documentation: Product ID string. read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $product;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - documentation: Class ID string. Class information is read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $class;
    /**
     * The protocol
     * Meta information extracted from the WSDL
     * - documentation: Protocol option is read-only,except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $protocol;
    /**
     * The protocolSide
     * Meta information extracted from the WSDL
     * - documentation: Side information is read-only except when creating a device
     * - default: User
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $protocolSide;
    /**
     * The devicePoolName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $devicePoolName;
    /**
     * The commonPhoneConfigName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $commonPhoneConfigName;
    /**
     * The locationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $locationName;
    /**
     * The useTrustedRelayPoint
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The phoneTemplateName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $phoneTemplateName;
    /**
     * The primaryPhoneName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $primaryPhoneName;
    /**
     * The builtInBridgeStatus
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $builtInBridgeStatus;
    /**
     * The packetCaptureMode
     * Meta information extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $packetCaptureMode;
    /**
     * The certificateOperation
     * Meta information extracted from the WSDL
     * - default: No Pending Operation
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $certificateOperation;
    /**
     * The deviceMobilityMode
     * Meta information extracted from the WSDL
     * - documentation: Specifies if the phone is configured for device mobility or not.
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $deviceMobilityMode;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - documentation: Optional description of the device
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The callingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The commonDeviceConfigName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $commonDeviceConfigName;
    /**
     * The networkLocation
     * Meta information extracted from the WSDL
     * - documentation: The new Device Destination for Trunk to Trunk Transfer and Drop Conference Feature is required for most gateways ,except FXS gateways and phones.Not Nullable.
     * - default: Use System Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $networkLocation;
    /**
     * The mediaResourceListName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $mediaResourceListName;
    /**
     * The networkHoldMohAudioSourceId
     * Meta information extracted from the WSDL
     * - documentation: This tag is not valid for H323Phone,H323trunk and SIPTrunk
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $networkHoldMohAudioSourceId;
    /**
     * The userHoldMohAudioSourceId
     * Meta information extracted from the WSDL
     * - documentation: This tag is not valid for H323Phone,H323trunk and SIPTrunk
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $userHoldMohAudioSourceId;
    /**
     * The automatedAlternateRoutingCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $automatedAlternateRoutingCssName;
    /**
     * The aarNeighborhoodName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $aarNeighborhoodName;
    /**
     * The loadInformation
     * Meta information extracted from the WSDL
     * - documentation: For devices with load information, if any special load information is specified the special attribute is set to TRUE.Otherwise,the load information is default for the product.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation
     */
    public $loadInformation;
    /**
     * The vendorConfig
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig
     */
    public $vendorConfig;
    /**
     * The versionStamp
     * Meta information extracted from the WSDL
     * - documentation: UUID changed each time device is updated
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $versionStamp;
    /**
     * The traceFlag
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $traceFlag;
    /**
     * The mlppDomainId
     * Meta information extracted from the WSDL
     * - documentation: This setting only effects devices that support MLPP. Use -1 to set to null
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $mlppDomainId;
    /**
     * The mlppIndicationStatus
     * Meta information extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - default: Off
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $mlppIndicationStatus;
    /**
     * The preemption
     * Meta information extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $preemption;
    /**
     * The retryVideoCallAsAudio
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $retryVideoCallAsAudio;
    /**
     * The securityProfileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $securityProfileName;
    /**
     * The sipProfileName
     * Meta information extracted from the WSDL
     * - documentation: This Tag is valid only for SIP Phones and SIP Trunks
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $sipProfileName;
    /**
     * The cgpnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $cgpnTransformationCssName;
    /**
     * The useDevicePoolCgpnTransformCss
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCss;
    /**
     * The geoLocationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $geoLocationName;
    /**
     * The geoLocationFilterName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $geoLocationFilterName;
    /**
     * The sendGeoLocation
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $sendGeoLocation;
    /**
     * The lines
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\Lines
     */
    public $lines;
    /**
     * The speeddials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\Speeddials
     */
    public $speeddials;
    /**
     * The busyLampFields
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\BusyLampFields
     */
    public $busyLampFields;
    /**
     * The ringSettingIdleBlfAudibleAlert
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ringSettingIdleBlfAudibleAlert;
    /**
     * The ringSettingBusyBlfAudibleAlert
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ringSettingBusyBlfAudibleAlert;
    /**
     * The blfDirectedCallParks
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\BlfDirectedCallParks
     */
    public $blfDirectedCallParks;
    /**
     * The addOnModules
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\AddOnModules
     */
    public $addOnModules;
    /**
     * The userLocale
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $userLocale;
    /**
     * The networkLocale
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $networkLocale;
    /**
     * The idleTimeout
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $idleTimeout;
    /**
     * The authenticationUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $authenticationUrl;
    /**
     * The directoryUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $directoryUrl;
    /**
     * The idleUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $idleUrl;
    /**
     * The informationUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $informationUrl;
    /**
     * The messagesUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $messagesUrl;
    /**
     * The proxyServerUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $proxyServerUrl;
    /**
     * The servicesUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $servicesUrl;
    /**
     * The services
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\Services
     */
    public $services;
    /**
     * The softkeyTemplateName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $softkeyTemplateName;
    /**
     * The defaultProfileName
     * Meta information extracted from the WSDL
     * - documentation: The name of the default profile for this device.Not Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $defaultProfileName;
    /**
     * The enableExtensionMobility
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableExtensionMobility;
    /**
     * The singleButtonBarge
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only for devices that support SBB.
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $singleButtonBarge;
    /**
     * The joinAcrossLines
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only for devices that support JAL..
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $joinAcrossLines;
    /**
     * The callInfoPrivacyStatus
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callInfoPrivacyStatus;
    /**
     * The hlogStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $hlogStatus;
    /**
     * The ownerUserName
     * Meta information extracted from the WSDL
     * - documentation: Read-only for IP Phones.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $ownerUserName;
    /**
     * The ignorePresentationIndicators
     * Meta information extracted from the WSDL
     * - documentation: The new Ignore Presentation Indicators flag for Hospitality feature is required for most phones andand device profiles. Not Nullable.
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $ignorePresentationIndicators;
    /**
     * The packetCaptureDuration
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $packetCaptureDuration;
    /**
     * The subscribeCallingSearchSpaceName
     * Meta information extracted from the WSDL
     * - documentation: Support for this tag has been removed for IMS phones from 9.0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $subscribeCallingSearchSpaceName;
    /**
     * The rerouteCallingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $rerouteCallingSearchSpaceName;
    /**
     * The allowCtiControlFlag
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowCtiControlFlag;
    /**
     * The presenceGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $presenceGroupName;
    /**
     * The unattendedPort
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for H323Phones and H323Trunks.Not for Gateways.
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $unattendedPort;
    /**
     * The requireDtmfReception
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $requireDtmfReception;
    /**
     * The rfc2833Disabled
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $rfc2833Disabled;
    /**
     * The authenticationMode
     * Meta information extracted from the WSDL
     * - documentation: authenticationMode can be updated only if certificateOperation field is Install/Upgrade,Delete or Troubleshoot.
     * - default: By Null String
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $authenticationMode;
    /**
     * The keySize
     * Meta information extracted from the WSDL
     * - documentation: keySize can be updated only if certificateOperation field is Install/Upgrade,Delete or Troubleshoot.
     * - default: 1024
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $keySize;
    /**
     * The authenticationString
     * Meta information extracted from the WSDL
     * - documentation: authenticationString can be updated only if certificateOperation field is Install/Upgrade,Delete or Troubleshoot.
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $authenticationString;
    /**
     * The upgradeFinishTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $upgradeFinishTime;
    /**
     * The remoteDevice
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $remoteDevice;
    /**
     * The dndOption
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only for devices that support DND.
     * - default: Ringer Off
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $dndOption;
    /**
     * The dndRingSetting
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only for devices that support DND.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $dndRingSetting;
    /**
     * The dndStatus
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only for devices that support DND.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $dndStatus;
    /**
     * The isActive
     * Meta information extracted from the WSDL
     * - documentation: This tag determines if the newly added phone is active to determine consumption of license.If set to false the license units will not be consumed.
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isActive;
    /**
     * The isDualMode
     * Meta information extracted from the WSDL
     * - documentation: Read-only tag.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isDualMode;
    /**
     * The mobilityUserIdName
     * Meta information extracted from the WSDL
     * - documentation: The userid of the mobility user for this phone.Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $mobilityUserIdName;
    /**
     * The phoneSuite
     * Meta information extracted from the WSDL
     * - documentation: If a blank tag is passed ,the value of the default is inserted into the database.
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $phoneSuite;
    /**
     * The phoneServiceDisplay
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $phoneServiceDisplay;
    /**
     * The isProtected
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only for devices that support Secure Tone.
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isProtected;
    /**
     * The mtpRequired
     * Meta information extracted from the WSDL
     * - documentation: This field is applicable only to SIP phones.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $mtpRequired;
    /**
     * The mtpPreferedCodec
     * Meta information extracted from the WSDL
     * - documentation: This field is applicable only to SIP phones.
     * - default: 711ulaw
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $mtpPreferedCodec;
    /**
     * The dialRulesName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $dialRulesName;
    /**
     * The sshUserId
     * Meta information extracted from the WSDL
     * - documentation: This tag is applicable only to thosedevices that support ssh feature.
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $sshUserId;
    /**
     * The sshPwd
     * Meta information extracted from the WSDL
     * - documentation: This tag is applicable only to thosedevices that support ssh feature.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $sshPwd;
    /**
     * The digestUser
     * Meta information extracted from the WSDL
     * - documentation: This field is applicable only to SIP phones.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $digestUser;
    /**
     * The outboundCallRollover
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only for devices that Automatic Outbound Callrollover
     * - default: No Rollover
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $outboundCallRollover;
    /**
     * The hotlineDevice
     * Meta information extracted from the WSDL
     * - documentation: This tag is applicable for PLAR-supporting SIP/SCCP phones only
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $hotlineDevice;
    /**
     * The secureInformationUrl
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $secureInformationUrl;
    /**
     * The secureDirectoryUrl
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $secureDirectoryUrl;
    /**
     * The secureMessageUrl
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $secureMessageUrl;
    /**
     * The secureServicesUrl
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $secureServicesUrl;
    /**
     * The secureAuthenticationUrl
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $secureAuthenticationUrl;
    /**
     * The secureIdleUrl
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $secureIdleUrl;
    /**
     * The alwaysUsePrimeLine
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $alwaysUsePrimeLine;
    /**
     * The alwaysUsePrimeLineForVoiceMessage
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $alwaysUsePrimeLineForVoiceMessage;
    /**
     * The featureControlPolicy
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only for RT Phones.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $featureControlPolicy;
    /**
     * The deviceTrustMode
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only for TIP endpoints
     * - default: Not Trusted
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $deviceTrustMode;
    /**
     * The earlyOfferSupportForVoiceCall
     * Meta information extracted from the WSDL
     * - documentation: This field is applicable only for Third-party AS-SIP Endpoint.
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $earlyOfferSupportForVoiceCall;
    /**
     * The requireThirdPartyRegistration
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $requireThirdPartyRegistration;
    /**
     * The blockIncomingCallsWhenRoaming
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $blockIncomingCallsWhenRoaming;
    /**
     * The homeNetworkId
     * Meta information extracted from the WSDL
     * - documentation: This tag is only valid when value of blockIncomingCallsWhenRoaming is true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $homeNetworkId;
    /**
     * The AllowPresentationSharingUsingBfcp
     * Meta information extracted from the WSDL
     * - documentation: This field is applicable only for Third-party AS-SIP Endpoint.
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $AllowPresentationSharingUsingBfcp;
    /**
     * The confidentialAccess
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess
     */
    public $confidentialAccess;
    /**
     * The requireOffPremiseLocation
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $requireOffPremiseLocation;
    /**
     * The allowiXApplicableMedia
     * Meta information extracted from the WSDL
     * - documentation: This field is applicable only for Third-party AS-SIP Endpoint.
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowiXApplicableMedia;
    /**
     * The cgpnIngressDN
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $cgpnIngressDN;
    /**
     * The useDevicePoolCgpnIngressDN
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnIngressDN;
    /**
     * The msisdn
     * Meta information extracted from the WSDL
     * - documentation: Mobile Subscriber ISDN
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $msisdn;
    /**
     * The enableCallRoutingToRdWhenNoneIsActive
     * Meta information extracted from the WSDL
     * - documentation: The new enableCallRoutingToRdWhenNoneIsActive flag for Remote Destination Call Forwarding feature is required for CTI Remote Device. Not Nullable.
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableCallRoutingToRdWhenNoneIsActive;
    /**
     * The wifiHotspotProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $wifiHotspotProfile;
    /**
     * The wirelessLanProfileGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $wirelessLanProfileGroup;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * Constructor method for XPhone
     * @uses XPhone::setName()
     * @uses XPhone::setProduct()
     * @uses XPhone::setClass()
     * @uses XPhone::setProtocol()
     * @uses XPhone::setProtocolSide()
     * @uses XPhone::setDevicePoolName()
     * @uses XPhone::setCommonPhoneConfigName()
     * @uses XPhone::setLocationName()
     * @uses XPhone::setUseTrustedRelayPoint()
     * @uses XPhone::setPhoneTemplateName()
     * @uses XPhone::setPrimaryPhoneName()
     * @uses XPhone::setBuiltInBridgeStatus()
     * @uses XPhone::setPacketCaptureMode()
     * @uses XPhone::setCertificateOperation()
     * @uses XPhone::setDeviceMobilityMode()
     * @uses XPhone::setDescription()
     * @uses XPhone::setCallingSearchSpaceName()
     * @uses XPhone::setCommonDeviceConfigName()
     * @uses XPhone::setNetworkLocation()
     * @uses XPhone::setMediaResourceListName()
     * @uses XPhone::setNetworkHoldMohAudioSourceId()
     * @uses XPhone::setUserHoldMohAudioSourceId()
     * @uses XPhone::setAutomatedAlternateRoutingCssName()
     * @uses XPhone::setAarNeighborhoodName()
     * @uses XPhone::setLoadInformation()
     * @uses XPhone::setVendorConfig()
     * @uses XPhone::setVersionStamp()
     * @uses XPhone::setTraceFlag()
     * @uses XPhone::setMlppDomainId()
     * @uses XPhone::setMlppIndicationStatus()
     * @uses XPhone::setPreemption()
     * @uses XPhone::setRetryVideoCallAsAudio()
     * @uses XPhone::setSecurityProfileName()
     * @uses XPhone::setSipProfileName()
     * @uses XPhone::setCgpnTransformationCssName()
     * @uses XPhone::setUseDevicePoolCgpnTransformCss()
     * @uses XPhone::setGeoLocationName()
     * @uses XPhone::setGeoLocationFilterName()
     * @uses XPhone::setSendGeoLocation()
     * @uses XPhone::setLines()
     * @uses XPhone::setSpeeddials()
     * @uses XPhone::setBusyLampFields()
     * @uses XPhone::setRingSettingIdleBlfAudibleAlert()
     * @uses XPhone::setRingSettingBusyBlfAudibleAlert()
     * @uses XPhone::setBlfDirectedCallParks()
     * @uses XPhone::setAddOnModules()
     * @uses XPhone::setUserLocale()
     * @uses XPhone::setNetworkLocale()
     * @uses XPhone::setIdleTimeout()
     * @uses XPhone::setAuthenticationUrl()
     * @uses XPhone::setDirectoryUrl()
     * @uses XPhone::setIdleUrl()
     * @uses XPhone::setInformationUrl()
     * @uses XPhone::setMessagesUrl()
     * @uses XPhone::setProxyServerUrl()
     * @uses XPhone::setServicesUrl()
     * @uses XPhone::setServices()
     * @uses XPhone::setSoftkeyTemplateName()
     * @uses XPhone::setDefaultProfileName()
     * @uses XPhone::setEnableExtensionMobility()
     * @uses XPhone::setSingleButtonBarge()
     * @uses XPhone::setJoinAcrossLines()
     * @uses XPhone::setCallInfoPrivacyStatus()
     * @uses XPhone::setHlogStatus()
     * @uses XPhone::setOwnerUserName()
     * @uses XPhone::setIgnorePresentationIndicators()
     * @uses XPhone::setPacketCaptureDuration()
     * @uses XPhone::setSubscribeCallingSearchSpaceName()
     * @uses XPhone::setRerouteCallingSearchSpaceName()
     * @uses XPhone::setAllowCtiControlFlag()
     * @uses XPhone::setPresenceGroupName()
     * @uses XPhone::setUnattendedPort()
     * @uses XPhone::setRequireDtmfReception()
     * @uses XPhone::setRfc2833Disabled()
     * @uses XPhone::setAuthenticationMode()
     * @uses XPhone::setKeySize()
     * @uses XPhone::setAuthenticationString()
     * @uses XPhone::setUpgradeFinishTime()
     * @uses XPhone::setRemoteDevice()
     * @uses XPhone::setDndOption()
     * @uses XPhone::setDndRingSetting()
     * @uses XPhone::setDndStatus()
     * @uses XPhone::setIsActive()
     * @uses XPhone::setIsDualMode()
     * @uses XPhone::setMobilityUserIdName()
     * @uses XPhone::setPhoneSuite()
     * @uses XPhone::setPhoneServiceDisplay()
     * @uses XPhone::setIsProtected()
     * @uses XPhone::setMtpRequired()
     * @uses XPhone::setMtpPreferedCodec()
     * @uses XPhone::setDialRulesName()
     * @uses XPhone::setSshUserId()
     * @uses XPhone::setSshPwd()
     * @uses XPhone::setDigestUser()
     * @uses XPhone::setOutboundCallRollover()
     * @uses XPhone::setHotlineDevice()
     * @uses XPhone::setSecureInformationUrl()
     * @uses XPhone::setSecureDirectoryUrl()
     * @uses XPhone::setSecureMessageUrl()
     * @uses XPhone::setSecureServicesUrl()
     * @uses XPhone::setSecureAuthenticationUrl()
     * @uses XPhone::setSecureIdleUrl()
     * @uses XPhone::setAlwaysUsePrimeLine()
     * @uses XPhone::setAlwaysUsePrimeLineForVoiceMessage()
     * @uses XPhone::setFeatureControlPolicy()
     * @uses XPhone::setDeviceTrustMode()
     * @uses XPhone::setEarlyOfferSupportForVoiceCall()
     * @uses XPhone::setRequireThirdPartyRegistration()
     * @uses XPhone::setBlockIncomingCallsWhenRoaming()
     * @uses XPhone::setHomeNetworkId()
     * @uses XPhone::setAllowPresentationSharingUsingBfcp()
     * @uses XPhone::setConfidentialAccess()
     * @uses XPhone::setRequireOffPremiseLocation()
     * @uses XPhone::setAllowiXApplicableMedia()
     * @uses XPhone::setCgpnIngressDN()
     * @uses XPhone::setUseDevicePoolCgpnIngressDN()
     * @uses XPhone::setMsisdn()
     * @uses XPhone::setEnableCallRoutingToRdWhenNoneIsActive()
     * @uses XPhone::setWifiHotspotProfile()
     * @uses XPhone::setWirelessLanProfileGroup()
     * @uses XPhone::setCtiid()
     * @param string $name
     * @param string $product
     * @param string $class
     * @param string $protocol
     * @param string $protocolSide
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonPhoneConfigName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName
     * @param string $useTrustedRelayPoint
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $phoneTemplateName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $primaryPhoneName
     * @param string $builtInBridgeStatus
     * @param string $packetCaptureMode
     * @param string $certificateOperation
     * @param string $deviceMobilityMode
     * @param string $description
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName
     * @param string $networkLocation
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName
     * @param string $networkHoldMohAudioSourceId
     * @param string $userHoldMohAudioSourceId
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig
     * @param string $versionStamp
     * @param string $traceFlag
     * @param string $mlppDomainId
     * @param string $mlppIndicationStatus
     * @param string $preemption
     * @param string $retryVideoCallAsAudio
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $securityProfileName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipProfileName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName
     * @param string $useDevicePoolCgpnTransformCss
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName
     * @param string $sendGeoLocation
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Lines $lines
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Speeddials $speeddials
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\BusyLampFields $busyLampFields
     * @param string $ringSettingIdleBlfAudibleAlert
     * @param string $ringSettingBusyBlfAudibleAlert
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\BlfDirectedCallParks $blfDirectedCallParks
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AddOnModules $addOnModules
     * @param string $userLocale
     * @param string $networkLocale
     * @param string $idleTimeout
     * @param string $authenticationUrl
     * @param string $directoryUrl
     * @param string $idleUrl
     * @param string $informationUrl
     * @param string $messagesUrl
     * @param string $proxyServerUrl
     * @param string $servicesUrl
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Services $services
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $softkeyTemplateName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $defaultProfileName
     * @param string $enableExtensionMobility
     * @param string $singleButtonBarge
     * @param string $joinAcrossLines
     * @param string $callInfoPrivacyStatus
     * @param string $hlogStatus
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ownerUserName
     * @param string $ignorePresentationIndicators
     * @param string $packetCaptureDuration
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscribeCallingSearchSpaceName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $rerouteCallingSearchSpaceName
     * @param string $allowCtiControlFlag
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName
     * @param string $unattendedPort
     * @param string $requireDtmfReception
     * @param string $rfc2833Disabled
     * @param string $authenticationMode
     * @param string $keySize
     * @param string $authenticationString
     * @param string $upgradeFinishTime
     * @param string $remoteDevice
     * @param string $dndOption
     * @param string $dndRingSetting
     * @param string $dndStatus
     * @param string $isActive
     * @param string $isDualMode
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mobilityUserIdName
     * @param string $phoneSuite
     * @param string $phoneServiceDisplay
     * @param string $isProtected
     * @param string $mtpRequired
     * @param string $mtpPreferedCodec
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialRulesName
     * @param string $sshUserId
     * @param string $sshPwd
     * @param string $digestUser
     * @param string $outboundCallRollover
     * @param string $hotlineDevice
     * @param string $secureInformationUrl
     * @param string $secureDirectoryUrl
     * @param string $secureMessageUrl
     * @param string $secureServicesUrl
     * @param string $secureAuthenticationUrl
     * @param string $secureIdleUrl
     * @param string $alwaysUsePrimeLine
     * @param string $alwaysUsePrimeLineForVoiceMessage
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $featureControlPolicy
     * @param string $deviceTrustMode
     * @param string $earlyOfferSupportForVoiceCall
     * @param string $requireThirdPartyRegistration
     * @param string $blockIncomingCallsWhenRoaming
     * @param string $homeNetworkId
     * @param string $allowPresentationSharingUsingBfcp
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess
     * @param string $requireOffPremiseLocation
     * @param string $allowiXApplicableMedia
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnIngressDN
     * @param string $useDevicePoolCgpnIngressDN
     * @param string $msisdn
     * @param string $enableCallRoutingToRdWhenNoneIsActive
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $wifiHotspotProfile
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $wirelessLanProfileGroup
     * @param int $ctiid
     */
    public function __construct($name = null, $product = null, $class = null, $protocol = null, $protocolSide = 'User', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonPhoneConfigName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName = null, $useTrustedRelayPoint = 'Default', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $phoneTemplateName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $primaryPhoneName = null, $builtInBridgeStatus = 'Default', $packetCaptureMode = 'None', $certificateOperation = 'No Pending Operation', $deviceMobilityMode = 'Default', $description = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName = null, $networkLocation = 'Use System Default', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName = null, $networkHoldMohAudioSourceId = null, $userHoldMohAudioSourceId = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation = null, \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig = null, $versionStamp = null, $traceFlag = null, $mlppDomainId = null, $mlppIndicationStatus = 'Off', $preemption = 'Default', $retryVideoCallAsAudio = 'true', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $securityProfileName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipProfileName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName = null, $useDevicePoolCgpnTransformCss = 'true', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName = null, $sendGeoLocation = null, \\Losc\CucmBundle\Model\Webservice\StructType\Lines $lines = null, \\Losc\CucmBundle\Model\Webservice\StructType\Speeddials $speeddials = null, \\Losc\CucmBundle\Model\Webservice\StructType\BusyLampFields $busyLampFields = null, $ringSettingIdleBlfAudibleAlert = 'Default', $ringSettingBusyBlfAudibleAlert = 'Default', \\Losc\CucmBundle\Model\Webservice\StructType\BlfDirectedCallParks $blfDirectedCallParks = null, \\Losc\CucmBundle\Model\Webservice\StructType\AddOnModules $addOnModules = null, $userLocale = null, $networkLocale = null, $idleTimeout = null, $authenticationUrl = null, $directoryUrl = null, $idleUrl = null, $informationUrl = null, $messagesUrl = null, $proxyServerUrl = null, $servicesUrl = null, \\Losc\CucmBundle\Model\Webservice\StructType\Services $services = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $softkeyTemplateName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $defaultProfileName = null, $enableExtensionMobility = null, $singleButtonBarge = 'Default', $joinAcrossLines = 'Default', $callInfoPrivacyStatus = 'Default', $hlogStatus = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ownerUserName = null, $ignorePresentationIndicators = 'false', $packetCaptureDuration = '0', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscribeCallingSearchSpaceName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $rerouteCallingSearchSpaceName = null, $allowCtiControlFlag = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName = null, $unattendedPort = 'false', $requireDtmfReception = 'false', $rfc2833Disabled = 'false', $authenticationMode = 'By Null String', $keySize = '1024', $authenticationString = null, $upgradeFinishTime = null, $remoteDevice = 'false', $dndOption = 'Ringer Off', $dndRingSetting = null, $dndStatus = null, $isActive = 'true', $isDualMode = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mobilityUserIdName = null, $phoneSuite = 'Default', $phoneServiceDisplay = 'Default', $isProtected = 'false', $mtpRequired = null, $mtpPreferedCodec = '711ulaw', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialRulesName = null, $sshUserId = null, $sshPwd = null, $digestUser = null, $outboundCallRollover = 'No Rollover', $hotlineDevice = 'false', $secureInformationUrl = null, $secureDirectoryUrl = null, $secureMessageUrl = null, $secureServicesUrl = null, $secureAuthenticationUrl = null, $secureIdleUrl = null, $alwaysUsePrimeLine = 'Default', $alwaysUsePrimeLineForVoiceMessage = 'Default', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $featureControlPolicy = null, $deviceTrustMode = 'Not Trusted', $earlyOfferSupportForVoiceCall = 'false', $requireThirdPartyRegistration = null, $blockIncomingCallsWhenRoaming = null, $homeNetworkId = null, $allowPresentationSharingUsingBfcp = 'false', \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess = null, $requireOffPremiseLocation = 'false', $allowiXApplicableMedia = 'false', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnIngressDN = null, $useDevicePoolCgpnIngressDN = 'true', $msisdn = null, $enableCallRoutingToRdWhenNoneIsActive = 'false', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $wifiHotspotProfile = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $wirelessLanProfileGroup = null, $ctiid = null)
    {
        $this
            ->setName($name)
            ->setProduct($product)
            ->setClass($class)
            ->setProtocol($protocol)
            ->setProtocolSide($protocolSide)
            ->setDevicePoolName($devicePoolName)
            ->setCommonPhoneConfigName($commonPhoneConfigName)
            ->setLocationName($locationName)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setPhoneTemplateName($phoneTemplateName)
            ->setPrimaryPhoneName($primaryPhoneName)
            ->setBuiltInBridgeStatus($builtInBridgeStatus)
            ->setPacketCaptureMode($packetCaptureMode)
            ->setCertificateOperation($certificateOperation)
            ->setDeviceMobilityMode($deviceMobilityMode)
            ->setDescription($description)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setNetworkLocation($networkLocation)
            ->setMediaResourceListName($mediaResourceListName)
            ->setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId)
            ->setUserHoldMohAudioSourceId($userHoldMohAudioSourceId)
            ->setAutomatedAlternateRoutingCssName($automatedAlternateRoutingCssName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setLoadInformation($loadInformation)
            ->setVendorConfig($vendorConfig)
            ->setVersionStamp($versionStamp)
            ->setTraceFlag($traceFlag)
            ->setMlppDomainId($mlppDomainId)
            ->setMlppIndicationStatus($mlppIndicationStatus)
            ->setPreemption($preemption)
            ->setRetryVideoCallAsAudio($retryVideoCallAsAudio)
            ->setSecurityProfileName($securityProfileName)
            ->setSipProfileName($sipProfileName)
            ->setCgpnTransformationCssName($cgpnTransformationCssName)
            ->setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss)
            ->setGeoLocationName($geoLocationName)
            ->setGeoLocationFilterName($geoLocationFilterName)
            ->setSendGeoLocation($sendGeoLocation)
            ->setLines($lines)
            ->setSpeeddials($speeddials)
            ->setBusyLampFields($busyLampFields)
            ->setRingSettingIdleBlfAudibleAlert($ringSettingIdleBlfAudibleAlert)
            ->setRingSettingBusyBlfAudibleAlert($ringSettingBusyBlfAudibleAlert)
            ->setBlfDirectedCallParks($blfDirectedCallParks)
            ->setAddOnModules($addOnModules)
            ->setUserLocale($userLocale)
            ->setNetworkLocale($networkLocale)
            ->setIdleTimeout($idleTimeout)
            ->setAuthenticationUrl($authenticationUrl)
            ->setDirectoryUrl($directoryUrl)
            ->setIdleUrl($idleUrl)
            ->setInformationUrl($informationUrl)
            ->setMessagesUrl($messagesUrl)
            ->setProxyServerUrl($proxyServerUrl)
            ->setServicesUrl($servicesUrl)
            ->setServices($services)
            ->setSoftkeyTemplateName($softkeyTemplateName)
            ->setDefaultProfileName($defaultProfileName)
            ->setEnableExtensionMobility($enableExtensionMobility)
            ->setSingleButtonBarge($singleButtonBarge)
            ->setJoinAcrossLines($joinAcrossLines)
            ->setCallInfoPrivacyStatus($callInfoPrivacyStatus)
            ->setHlogStatus($hlogStatus)
            ->setOwnerUserName($ownerUserName)
            ->setIgnorePresentationIndicators($ignorePresentationIndicators)
            ->setPacketCaptureDuration($packetCaptureDuration)
            ->setSubscribeCallingSearchSpaceName($subscribeCallingSearchSpaceName)
            ->setRerouteCallingSearchSpaceName($rerouteCallingSearchSpaceName)
            ->setAllowCtiControlFlag($allowCtiControlFlag)
            ->setPresenceGroupName($presenceGroupName)
            ->setUnattendedPort($unattendedPort)
            ->setRequireDtmfReception($requireDtmfReception)
            ->setRfc2833Disabled($rfc2833Disabled)
            ->setAuthenticationMode($authenticationMode)
            ->setKeySize($keySize)
            ->setAuthenticationString($authenticationString)
            ->setUpgradeFinishTime($upgradeFinishTime)
            ->setRemoteDevice($remoteDevice)
            ->setDndOption($dndOption)
            ->setDndRingSetting($dndRingSetting)
            ->setDndStatus($dndStatus)
            ->setIsActive($isActive)
            ->setIsDualMode($isDualMode)
            ->setMobilityUserIdName($mobilityUserIdName)
            ->setPhoneSuite($phoneSuite)
            ->setPhoneServiceDisplay($phoneServiceDisplay)
            ->setIsProtected($isProtected)
            ->setMtpRequired($mtpRequired)
            ->setMtpPreferedCodec($mtpPreferedCodec)
            ->setDialRulesName($dialRulesName)
            ->setSshUserId($sshUserId)
            ->setSshPwd($sshPwd)
            ->setDigestUser($digestUser)
            ->setOutboundCallRollover($outboundCallRollover)
            ->setHotlineDevice($hotlineDevice)
            ->setSecureInformationUrl($secureInformationUrl)
            ->setSecureDirectoryUrl($secureDirectoryUrl)
            ->setSecureMessageUrl($secureMessageUrl)
            ->setSecureServicesUrl($secureServicesUrl)
            ->setSecureAuthenticationUrl($secureAuthenticationUrl)
            ->setSecureIdleUrl($secureIdleUrl)
            ->setAlwaysUsePrimeLine($alwaysUsePrimeLine)
            ->setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage)
            ->setFeatureControlPolicy($featureControlPolicy)
            ->setDeviceTrustMode($deviceTrustMode)
            ->setEarlyOfferSupportForVoiceCall($earlyOfferSupportForVoiceCall)
            ->setRequireThirdPartyRegistration($requireThirdPartyRegistration)
            ->setBlockIncomingCallsWhenRoaming($blockIncomingCallsWhenRoaming)
            ->setHomeNetworkId($homeNetworkId)
            ->setAllowPresentationSharingUsingBfcp($allowPresentationSharingUsingBfcp)
            ->setConfidentialAccess($confidentialAccess)
            ->setRequireOffPremiseLocation($requireOffPremiseLocation)
            ->setAllowiXApplicableMedia($allowiXApplicableMedia)
            ->setCgpnIngressDN($cgpnIngressDN)
            ->setUseDevicePoolCgpnIngressDN($useDevicePoolCgpnIngressDN)
            ->setMsisdn($msisdn)
            ->setEnableCallRoutingToRdWhenNoneIsActive($enableCallRoutingToRdWhenNoneIsActive)
            ->setWifiHotspotProfile($wifiHotspotProfile)
            ->setWirelessLanProfileGroup($wirelessLanProfileGroup)
            ->setCtiid($ctiid);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get product value
     * @return string
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param string $product
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setProduct($product = null)
    {
        $this->product = $product;
        return $this;
    }
    /**
     * Get class value
     * @return string
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param string $class
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setClass($class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get protocol value
     * @return string
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @param string $protocol
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setProtocol($protocol = null)
    {
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get protocolSide value
     * @return string
     */
    public function getProtocolSide()
    {
        return $this->protocolSide;
    }
    /**
     * Set protocolSide value
     * @param string $protocolSide
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setProtocolSide($protocolSide = 'User')
    {
        $this->protocolSide = $protocolSide;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setDevicePoolName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get commonPhoneConfigName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getCommonPhoneConfigName()
    {
        return $this->commonPhoneConfigName;
    }
    /**
     * Set commonPhoneConfigName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonPhoneConfigName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setCommonPhoneConfigName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonPhoneConfigName = null)
    {
        $this->commonPhoneConfigName = $commonPhoneConfigName;
        return $this;
    }
    /**
     * Get locationName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setLocationName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @param string $useTrustedRelayPoint
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = 'Default')
    {
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get phoneTemplateName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getPhoneTemplateName()
    {
        return $this->phoneTemplateName;
    }
    /**
     * Set phoneTemplateName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $phoneTemplateName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setPhoneTemplateName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $phoneTemplateName = null)
    {
        $this->phoneTemplateName = $phoneTemplateName;
        return $this;
    }
    /**
     * Get primaryPhoneName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getPrimaryPhoneName()
    {
        return $this->primaryPhoneName;
    }
    /**
     * Set primaryPhoneName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $primaryPhoneName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setPrimaryPhoneName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $primaryPhoneName = null)
    {
        $this->primaryPhoneName = $primaryPhoneName;
        return $this;
    }
    /**
     * Get builtInBridgeStatus value
     * @return string
     */
    public function getBuiltInBridgeStatus()
    {
        return $this->builtInBridgeStatus;
    }
    /**
     * Set builtInBridgeStatus value
     * @param string $builtInBridgeStatus
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setBuiltInBridgeStatus($builtInBridgeStatus = 'Default')
    {
        $this->builtInBridgeStatus = $builtInBridgeStatus;
        return $this;
    }
    /**
     * Get packetCaptureMode value
     * @return string
     */
    public function getPacketCaptureMode()
    {
        return $this->packetCaptureMode;
    }
    /**
     * Set packetCaptureMode value
     * @param string $packetCaptureMode
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setPacketCaptureMode($packetCaptureMode = 'None')
    {
        $this->packetCaptureMode = $packetCaptureMode;
        return $this;
    }
    /**
     * Get certificateOperation value
     * @return string
     */
    public function getCertificateOperation()
    {
        return $this->certificateOperation;
    }
    /**
     * Set certificateOperation value
     * @param string $certificateOperation
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setCertificateOperation($certificateOperation = 'No Pending Operation')
    {
        $this->certificateOperation = $certificateOperation;
        return $this;
    }
    /**
     * Get deviceMobilityMode value
     * @return string
     */
    public function getDeviceMobilityMode()
    {
        return $this->deviceMobilityMode;
    }
    /**
     * Set deviceMobilityMode value
     * @param string $deviceMobilityMode
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setDeviceMobilityMode($deviceMobilityMode = 'Default')
    {
        $this->deviceMobilityMode = $deviceMobilityMode;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return isset($this->callingSearchSpaceName) ? $this->callingSearchSpaceName : null;
    }
    /**
     * Set callingSearchSpaceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setCallingSearchSpaceName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName = null)
    {
        if (is_null($callingSearchSpaceName) || (is_array($callingSearchSpaceName) && empty($callingSearchSpaceName))) {
            unset($this->callingSearchSpaceName);
        } else {
            $this->callingSearchSpaceName = $callingSearchSpaceName;
        }
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return isset($this->commonDeviceConfigName) ? $this->commonDeviceConfigName : null;
    }
    /**
     * Set commonDeviceConfigName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setCommonDeviceConfigName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName = null)
    {
        if (is_null($commonDeviceConfigName) || (is_array($commonDeviceConfigName) && empty($commonDeviceConfigName))) {
            unset($this->commonDeviceConfigName);
        } else {
            $this->commonDeviceConfigName = $commonDeviceConfigName;
        }
        return $this;
    }
    /**
     * Get networkLocation value
     * @return string|null
     */
    public function getNetworkLocation()
    {
        return $this->networkLocation;
    }
    /**
     * Set networkLocation value
     * @param string $networkLocation
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setNetworkLocation($networkLocation = 'Use System Default')
    {
        $this->networkLocation = $networkLocation;
        return $this;
    }
    /**
     * Get mediaResourceListName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getMediaResourceListName()
    {
        return isset($this->mediaResourceListName) ? $this->mediaResourceListName : null;
    }
    /**
     * Set mediaResourceListName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setMediaResourceListName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName = null)
    {
        if (is_null($mediaResourceListName) || (is_array($mediaResourceListName) && empty($mediaResourceListName))) {
            unset($this->mediaResourceListName);
        } else {
            $this->mediaResourceListName = $mediaResourceListName;
        }
        return $this;
    }
    /**
     * Get networkHoldMohAudioSourceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNetworkHoldMohAudioSourceId()
    {
        return isset($this->networkHoldMohAudioSourceId) ? $this->networkHoldMohAudioSourceId : null;
    }
    /**
     * Set networkHoldMohAudioSourceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $networkHoldMohAudioSourceId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId = null)
    {
        if (is_null($networkHoldMohAudioSourceId) || (is_array($networkHoldMohAudioSourceId) && empty($networkHoldMohAudioSourceId))) {
            unset($this->networkHoldMohAudioSourceId);
        } else {
            $this->networkHoldMohAudioSourceId = $networkHoldMohAudioSourceId;
        }
        return $this;
    }
    /**
     * Get userHoldMohAudioSourceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserHoldMohAudioSourceId()
    {
        return isset($this->userHoldMohAudioSourceId) ? $this->userHoldMohAudioSourceId : null;
    }
    /**
     * Set userHoldMohAudioSourceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userHoldMohAudioSourceId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setUserHoldMohAudioSourceId($userHoldMohAudioSourceId = null)
    {
        if (is_null($userHoldMohAudioSourceId) || (is_array($userHoldMohAudioSourceId) && empty($userHoldMohAudioSourceId))) {
            unset($this->userHoldMohAudioSourceId);
        } else {
            $this->userHoldMohAudioSourceId = $userHoldMohAudioSourceId;
        }
        return $this;
    }
    /**
     * Get automatedAlternateRoutingCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getAutomatedAlternateRoutingCssName()
    {
        return isset($this->automatedAlternateRoutingCssName) ? $this->automatedAlternateRoutingCssName : null;
    }
    /**
     * Set automatedAlternateRoutingCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setAutomatedAlternateRoutingCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName = null)
    {
        if (is_null($automatedAlternateRoutingCssName) || (is_array($automatedAlternateRoutingCssName) && empty($automatedAlternateRoutingCssName))) {
            unset($this->automatedAlternateRoutingCssName);
        } else {
            $this->automatedAlternateRoutingCssName = $automatedAlternateRoutingCssName;
        }
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return isset($this->aarNeighborhoodName) ? $this->aarNeighborhoodName : null;
    }
    /**
     * Set aarNeighborhoodName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setAarNeighborhoodName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName = null)
    {
        if (is_null($aarNeighborhoodName) || (is_array($aarNeighborhoodName) && empty($aarNeighborhoodName))) {
            unset($this->aarNeighborhoodName);
        } else {
            $this->aarNeighborhoodName = $aarNeighborhoodName;
        }
        return $this;
    }
    /**
     * Get loadInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation|null
     */
    public function getLoadInformation()
    {
        return isset($this->loadInformation) ? $this->loadInformation : null;
    }
    /**
     * Set loadInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setLoadInformation(\\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation = null)
    {
        if (is_null($loadInformation) || (is_array($loadInformation) && empty($loadInformation))) {
            unset($this->loadInformation);
        } else {
            $this->loadInformation = $loadInformation;
        }
        return $this;
    }
    /**
     * Get vendorConfig value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig|null
     */
    public function getVendorConfig()
    {
        return $this->vendorConfig;
    }
    /**
     * Set vendorConfig value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setVendorConfig(\\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig = null)
    {
        $this->vendorConfig = $vendorConfig;
        return $this;
    }
    /**
     * Get versionStamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVersionStamp()
    {
        return isset($this->versionStamp) ? $this->versionStamp : null;
    }
    /**
     * Set versionStamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $versionStamp
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setVersionStamp($versionStamp = null)
    {
        if (is_null($versionStamp) || (is_array($versionStamp) && empty($versionStamp))) {
            unset($this->versionStamp);
        } else {
            $this->versionStamp = $versionStamp;
        }
        return $this;
    }
    /**
     * Get traceFlag value
     * @return string|null
     */
    public function getTraceFlag()
    {
        return $this->traceFlag;
    }
    /**
     * Set traceFlag value
     * @param string $traceFlag
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setTraceFlag($traceFlag = null)
    {
        $this->traceFlag = $traceFlag;
        return $this;
    }
    /**
     * Get mlppDomainId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMlppDomainId()
    {
        return isset($this->mlppDomainId) ? $this->mlppDomainId : null;
    }
    /**
     * Set mlppDomainId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mlppDomainId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setMlppDomainId($mlppDomainId = null)
    {
        if (is_null($mlppDomainId) || (is_array($mlppDomainId) && empty($mlppDomainId))) {
            unset($this->mlppDomainId);
        } else {
            $this->mlppDomainId = $mlppDomainId;
        }
        return $this;
    }
    /**
     * Get mlppIndicationStatus value
     * @return string|null
     */
    public function getMlppIndicationStatus()
    {
        return $this->mlppIndicationStatus;
    }
    /**
     * Set mlppIndicationStatus value
     * @param string $mlppIndicationStatus
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setMlppIndicationStatus($mlppIndicationStatus = 'Off')
    {
        $this->mlppIndicationStatus = $mlppIndicationStatus;
        return $this;
    }
    /**
     * Get preemption value
     * @return string|null
     */
    public function getPreemption()
    {
        return $this->preemption;
    }
    /**
     * Set preemption value
     * @param string $preemption
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setPreemption($preemption = 'Default')
    {
        $this->preemption = $preemption;
        return $this;
    }
    /**
     * Get retryVideoCallAsAudio value
     * @return string|null
     */
    public function getRetryVideoCallAsAudio()
    {
        return $this->retryVideoCallAsAudio;
    }
    /**
     * Set retryVideoCallAsAudio value
     * @param string $retryVideoCallAsAudio
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setRetryVideoCallAsAudio($retryVideoCallAsAudio = 'true')
    {
        $this->retryVideoCallAsAudio = $retryVideoCallAsAudio;
        return $this;
    }
    /**
     * Get securityProfileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSecurityProfileName()
    {
        return isset($this->securityProfileName) ? $this->securityProfileName : null;
    }
    /**
     * Set securityProfileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $securityProfileName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setSecurityProfileName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $securityProfileName = null)
    {
        if (is_null($securityProfileName) || (is_array($securityProfileName) && empty($securityProfileName))) {
            unset($this->securityProfileName);
        } else {
            $this->securityProfileName = $securityProfileName;
        }
        return $this;
    }
    /**
     * Get sipProfileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSipProfileName()
    {
        return isset($this->sipProfileName) ? $this->sipProfileName : null;
    }
    /**
     * Set sipProfileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipProfileName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setSipProfileName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipProfileName = null)
    {
        if (is_null($sipProfileName) || (is_array($sipProfileName) && empty($sipProfileName))) {
            unset($this->sipProfileName);
        } else {
            $this->sipProfileName = $sipProfileName;
        }
        return $this;
    }
    /**
     * Get cgpnTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCgpnTransformationCssName()
    {
        return isset($this->cgpnTransformationCssName) ? $this->cgpnTransformationCssName : null;
    }
    /**
     * Set cgpnTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setCgpnTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName = null)
    {
        if (is_null($cgpnTransformationCssName) || (is_array($cgpnTransformationCssName) && empty($cgpnTransformationCssName))) {
            unset($this->cgpnTransformationCssName);
        } else {
            $this->cgpnTransformationCssName = $cgpnTransformationCssName;
        }
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCss()
    {
        return $this->useDevicePoolCgpnTransformCss;
    }
    /**
     * Set useDevicePoolCgpnTransformCss value
     * @param string $useDevicePoolCgpnTransformCss
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss = 'true')
    {
        $this->useDevicePoolCgpnTransformCss = $useDevicePoolCgpnTransformCss;
        return $this;
    }
    /**
     * Get geoLocationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getGeoLocationName()
    {
        return isset($this->geoLocationName) ? $this->geoLocationName : null;
    }
    /**
     * Set geoLocationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setGeoLocationName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName = null)
    {
        if (is_null($geoLocationName) || (is_array($geoLocationName) && empty($geoLocationName))) {
            unset($this->geoLocationName);
        } else {
            $this->geoLocationName = $geoLocationName;
        }
        return $this;
    }
    /**
     * Get geoLocationFilterName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getGeoLocationFilterName()
    {
        return isset($this->geoLocationFilterName) ? $this->geoLocationFilterName : null;
    }
    /**
     * Set geoLocationFilterName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setGeoLocationFilterName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName = null)
    {
        if (is_null($geoLocationFilterName) || (is_array($geoLocationFilterName) && empty($geoLocationFilterName))) {
            unset($this->geoLocationFilterName);
        } else {
            $this->geoLocationFilterName = $geoLocationFilterName;
        }
        return $this;
    }
    /**
     * Get sendGeoLocation value
     * @return string|null
     */
    public function getSendGeoLocation()
    {
        return $this->sendGeoLocation;
    }
    /**
     * Set sendGeoLocation value
     * @param string $sendGeoLocation
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setSendGeoLocation($sendGeoLocation = null)
    {
        $this->sendGeoLocation = $sendGeoLocation;
        return $this;
    }
    /**
     * Get lines value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\Lines|null
     */
    public function getLines()
    {
        return $this->lines;
    }
    /**
     * Set lines value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Lines $lines
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setLines(\\Losc\CucmBundle\Model\Webservice\StructType\Lines $lines = null)
    {
        $this->lines = $lines;
        return $this;
    }
    /**
     * Get speeddials value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\Speeddials|null
     */
    public function getSpeeddials()
    {
        return $this->speeddials;
    }
    /**
     * Set speeddials value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Speeddials $speeddials
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setSpeeddials(\\Losc\CucmBundle\Model\Webservice\StructType\Speeddials $speeddials = null)
    {
        $this->speeddials = $speeddials;
        return $this;
    }
    /**
     * Get busyLampFields value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\BusyLampFields|null
     */
    public function getBusyLampFields()
    {
        return $this->busyLampFields;
    }
    /**
     * Set busyLampFields value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\BusyLampFields $busyLampFields
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setBusyLampFields(\\Losc\CucmBundle\Model\Webservice\StructType\BusyLampFields $busyLampFields = null)
    {
        $this->busyLampFields = $busyLampFields;
        return $this;
    }
    /**
     * Get ringSettingIdleBlfAudibleAlert value
     * @return string|null
     */
    public function getRingSettingIdleBlfAudibleAlert()
    {
        return $this->ringSettingIdleBlfAudibleAlert;
    }
    /**
     * Set ringSettingIdleBlfAudibleAlert value
     * @param string $ringSettingIdleBlfAudibleAlert
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setRingSettingIdleBlfAudibleAlert($ringSettingIdleBlfAudibleAlert = 'Default')
    {
        $this->ringSettingIdleBlfAudibleAlert = $ringSettingIdleBlfAudibleAlert;
        return $this;
    }
    /**
     * Get ringSettingBusyBlfAudibleAlert value
     * @return string|null
     */
    public function getRingSettingBusyBlfAudibleAlert()
    {
        return $this->ringSettingBusyBlfAudibleAlert;
    }
    /**
     * Set ringSettingBusyBlfAudibleAlert value
     * @param string $ringSettingBusyBlfAudibleAlert
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setRingSettingBusyBlfAudibleAlert($ringSettingBusyBlfAudibleAlert = 'Default')
    {
        $this->ringSettingBusyBlfAudibleAlert = $ringSettingBusyBlfAudibleAlert;
        return $this;
    }
    /**
     * Get blfDirectedCallParks value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\BlfDirectedCallParks|null
     */
    public function getBlfDirectedCallParks()
    {
        return $this->blfDirectedCallParks;
    }
    /**
     * Set blfDirectedCallParks value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\BlfDirectedCallParks $blfDirectedCallParks
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setBlfDirectedCallParks(\\Losc\CucmBundle\Model\Webservice\StructType\BlfDirectedCallParks $blfDirectedCallParks = null)
    {
        $this->blfDirectedCallParks = $blfDirectedCallParks;
        return $this;
    }
    /**
     * Get addOnModules value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\AddOnModules|null
     */
    public function getAddOnModules()
    {
        return $this->addOnModules;
    }
    /**
     * Set addOnModules value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AddOnModules $addOnModules
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setAddOnModules(\\Losc\CucmBundle\Model\Webservice\StructType\AddOnModules $addOnModules = null)
    {
        $this->addOnModules = $addOnModules;
        return $this;
    }
    /**
     * Get userLocale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserLocale()
    {
        return isset($this->userLocale) ? $this->userLocale : null;
    }
    /**
     * Set userLocale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userLocale
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setUserLocale($userLocale = null)
    {
        if (is_null($userLocale) || (is_array($userLocale) && empty($userLocale))) {
            unset($this->userLocale);
        } else {
            $this->userLocale = $userLocale;
        }
        return $this;
    }
    /**
     * Get networkLocale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNetworkLocale()
    {
        return isset($this->networkLocale) ? $this->networkLocale : null;
    }
    /**
     * Set networkLocale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $networkLocale
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setNetworkLocale($networkLocale = null)
    {
        if (is_null($networkLocale) || (is_array($networkLocale) && empty($networkLocale))) {
            unset($this->networkLocale);
        } else {
            $this->networkLocale = $networkLocale;
        }
        return $this;
    }
    /**
     * Get idleTimeout value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdleTimeout()
    {
        return isset($this->idleTimeout) ? $this->idleTimeout : null;
    }
    /**
     * Set idleTimeout value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idleTimeout
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setIdleTimeout($idleTimeout = null)
    {
        if (is_null($idleTimeout) || (is_array($idleTimeout) && empty($idleTimeout))) {
            unset($this->idleTimeout);
        } else {
            $this->idleTimeout = $idleTimeout;
        }
        return $this;
    }
    /**
     * Get authenticationUrl value
     * @return string|null
     */
    public function getAuthenticationUrl()
    {
        return $this->authenticationUrl;
    }
    /**
     * Set authenticationUrl value
     * @param string $authenticationUrl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setAuthenticationUrl($authenticationUrl = null)
    {
        $this->authenticationUrl = $authenticationUrl;
        return $this;
    }
    /**
     * Get directoryUrl value
     * @return string|null
     */
    public function getDirectoryUrl()
    {
        return $this->directoryUrl;
    }
    /**
     * Set directoryUrl value
     * @param string $directoryUrl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setDirectoryUrl($directoryUrl = null)
    {
        $this->directoryUrl = $directoryUrl;
        return $this;
    }
    /**
     * Get idleUrl value
     * @return string|null
     */
    public function getIdleUrl()
    {
        return $this->idleUrl;
    }
    /**
     * Set idleUrl value
     * @param string $idleUrl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setIdleUrl($idleUrl = null)
    {
        $this->idleUrl = $idleUrl;
        return $this;
    }
    /**
     * Get informationUrl value
     * @return string|null
     */
    public function getInformationUrl()
    {
        return $this->informationUrl;
    }
    /**
     * Set informationUrl value
     * @param string $informationUrl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setInformationUrl($informationUrl = null)
    {
        $this->informationUrl = $informationUrl;
        return $this;
    }
    /**
     * Get messagesUrl value
     * @return string|null
     */
    public function getMessagesUrl()
    {
        return $this->messagesUrl;
    }
    /**
     * Set messagesUrl value
     * @param string $messagesUrl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setMessagesUrl($messagesUrl = null)
    {
        $this->messagesUrl = $messagesUrl;
        return $this;
    }
    /**
     * Get proxyServerUrl value
     * @return string|null
     */
    public function getProxyServerUrl()
    {
        return $this->proxyServerUrl;
    }
    /**
     * Set proxyServerUrl value
     * @param string $proxyServerUrl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setProxyServerUrl($proxyServerUrl = null)
    {
        $this->proxyServerUrl = $proxyServerUrl;
        return $this;
    }
    /**
     * Get servicesUrl value
     * @return string|null
     */
    public function getServicesUrl()
    {
        return $this->servicesUrl;
    }
    /**
     * Set servicesUrl value
     * @param string $servicesUrl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setServicesUrl($servicesUrl = null)
    {
        $this->servicesUrl = $servicesUrl;
        return $this;
    }
    /**
     * Get services value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\Services|null
     */
    public function getServices()
    {
        return $this->services;
    }
    /**
     * Set services value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Services $services
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setServices(\\Losc\CucmBundle\Model\Webservice\StructType\Services $services = null)
    {
        $this->services = $services;
        return $this;
    }
    /**
     * Get softkeyTemplateName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSoftkeyTemplateName()
    {
        return isset($this->softkeyTemplateName) ? $this->softkeyTemplateName : null;
    }
    /**
     * Set softkeyTemplateName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $softkeyTemplateName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setSoftkeyTemplateName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $softkeyTemplateName = null)
    {
        if (is_null($softkeyTemplateName) || (is_array($softkeyTemplateName) && empty($softkeyTemplateName))) {
            unset($this->softkeyTemplateName);
        } else {
            $this->softkeyTemplateName = $softkeyTemplateName;
        }
        return $this;
    }
    /**
     * Get defaultProfileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDefaultProfileName()
    {
        return isset($this->defaultProfileName) ? $this->defaultProfileName : null;
    }
    /**
     * Set defaultProfileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $defaultProfileName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setDefaultProfileName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $defaultProfileName = null)
    {
        if (is_null($defaultProfileName) || (is_array($defaultProfileName) && empty($defaultProfileName))) {
            unset($this->defaultProfileName);
        } else {
            $this->defaultProfileName = $defaultProfileName;
        }
        return $this;
    }
    /**
     * Get enableExtensionMobility value
     * @return string|null
     */
    public function getEnableExtensionMobility()
    {
        return $this->enableExtensionMobility;
    }
    /**
     * Set enableExtensionMobility value
     * @param string $enableExtensionMobility
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setEnableExtensionMobility($enableExtensionMobility = null)
    {
        $this->enableExtensionMobility = $enableExtensionMobility;
        return $this;
    }
    /**
     * Get singleButtonBarge value
     * @return string|null
     */
    public function getSingleButtonBarge()
    {
        return $this->singleButtonBarge;
    }
    /**
     * Set singleButtonBarge value
     * @param string $singleButtonBarge
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setSingleButtonBarge($singleButtonBarge = 'Default')
    {
        $this->singleButtonBarge = $singleButtonBarge;
        return $this;
    }
    /**
     * Get joinAcrossLines value
     * @return string|null
     */
    public function getJoinAcrossLines()
    {
        return $this->joinAcrossLines;
    }
    /**
     * Set joinAcrossLines value
     * @param string $joinAcrossLines
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setJoinAcrossLines($joinAcrossLines = 'Default')
    {
        $this->joinAcrossLines = $joinAcrossLines;
        return $this;
    }
    /**
     * Get callInfoPrivacyStatus value
     * @return string|null
     */
    public function getCallInfoPrivacyStatus()
    {
        return $this->callInfoPrivacyStatus;
    }
    /**
     * Set callInfoPrivacyStatus value
     * @param string $callInfoPrivacyStatus
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setCallInfoPrivacyStatus($callInfoPrivacyStatus = 'Default')
    {
        $this->callInfoPrivacyStatus = $callInfoPrivacyStatus;
        return $this;
    }
    /**
     * Get hlogStatus value
     * @return string|null
     */
    public function getHlogStatus()
    {
        return $this->hlogStatus;
    }
    /**
     * Set hlogStatus value
     * @param string $hlogStatus
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setHlogStatus($hlogStatus = null)
    {
        $this->hlogStatus = $hlogStatus;
        return $this;
    }
    /**
     * Get ownerUserName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getOwnerUserName()
    {
        return isset($this->ownerUserName) ? $this->ownerUserName : null;
    }
    /**
     * Set ownerUserName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ownerUserName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setOwnerUserName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ownerUserName = null)
    {
        if (is_null($ownerUserName) || (is_array($ownerUserName) && empty($ownerUserName))) {
            unset($this->ownerUserName);
        } else {
            $this->ownerUserName = $ownerUserName;
        }
        return $this;
    }
    /**
     * Get ignorePresentationIndicators value
     * @return string|null
     */
    public function getIgnorePresentationIndicators()
    {
        return $this->ignorePresentationIndicators;
    }
    /**
     * Set ignorePresentationIndicators value
     * @param string $ignorePresentationIndicators
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setIgnorePresentationIndicators($ignorePresentationIndicators = 'false')
    {
        $this->ignorePresentationIndicators = $ignorePresentationIndicators;
        return $this;
    }
    /**
     * Get packetCaptureDuration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPacketCaptureDuration()
    {
        return isset($this->packetCaptureDuration) ? $this->packetCaptureDuration : null;
    }
    /**
     * Set packetCaptureDuration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $packetCaptureDuration
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setPacketCaptureDuration($packetCaptureDuration = '0')
    {
        if (is_null($packetCaptureDuration) || (is_array($packetCaptureDuration) && empty($packetCaptureDuration))) {
            unset($this->packetCaptureDuration);
        } else {
            $this->packetCaptureDuration = $packetCaptureDuration;
        }
        return $this;
    }
    /**
     * Get subscribeCallingSearchSpaceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSubscribeCallingSearchSpaceName()
    {
        return isset($this->subscribeCallingSearchSpaceName) ? $this->subscribeCallingSearchSpaceName : null;
    }
    /**
     * Set subscribeCallingSearchSpaceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscribeCallingSearchSpaceName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setSubscribeCallingSearchSpaceName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscribeCallingSearchSpaceName = null)
    {
        if (is_null($subscribeCallingSearchSpaceName) || (is_array($subscribeCallingSearchSpaceName) && empty($subscribeCallingSearchSpaceName))) {
            unset($this->subscribeCallingSearchSpaceName);
        } else {
            $this->subscribeCallingSearchSpaceName = $subscribeCallingSearchSpaceName;
        }
        return $this;
    }
    /**
     * Get rerouteCallingSearchSpaceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getRerouteCallingSearchSpaceName()
    {
        return isset($this->rerouteCallingSearchSpaceName) ? $this->rerouteCallingSearchSpaceName : null;
    }
    /**
     * Set rerouteCallingSearchSpaceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $rerouteCallingSearchSpaceName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setRerouteCallingSearchSpaceName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $rerouteCallingSearchSpaceName = null)
    {
        if (is_null($rerouteCallingSearchSpaceName) || (is_array($rerouteCallingSearchSpaceName) && empty($rerouteCallingSearchSpaceName))) {
            unset($this->rerouteCallingSearchSpaceName);
        } else {
            $this->rerouteCallingSearchSpaceName = $rerouteCallingSearchSpaceName;
        }
        return $this;
    }
    /**
     * Get allowCtiControlFlag value
     * @return string|null
     */
    public function getAllowCtiControlFlag()
    {
        return $this->allowCtiControlFlag;
    }
    /**
     * Set allowCtiControlFlag value
     * @param string $allowCtiControlFlag
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setAllowCtiControlFlag($allowCtiControlFlag = null)
    {
        $this->allowCtiControlFlag = $allowCtiControlFlag;
        return $this;
    }
    /**
     * Get presenceGroupName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getPresenceGroupName()
    {
        return $this->presenceGroupName;
    }
    /**
     * Set presenceGroupName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setPresenceGroupName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName = null)
    {
        $this->presenceGroupName = $presenceGroupName;
        return $this;
    }
    /**
     * Get unattendedPort value
     * @return string|null
     */
    public function getUnattendedPort()
    {
        return $this->unattendedPort;
    }
    /**
     * Set unattendedPort value
     * @param string $unattendedPort
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setUnattendedPort($unattendedPort = 'false')
    {
        $this->unattendedPort = $unattendedPort;
        return $this;
    }
    /**
     * Get requireDtmfReception value
     * @return string|null
     */
    public function getRequireDtmfReception()
    {
        return $this->requireDtmfReception;
    }
    /**
     * Set requireDtmfReception value
     * @param string $requireDtmfReception
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setRequireDtmfReception($requireDtmfReception = 'false')
    {
        $this->requireDtmfReception = $requireDtmfReception;
        return $this;
    }
    /**
     * Get rfc2833Disabled value
     * @return string|null
     */
    public function getRfc2833Disabled()
    {
        return $this->rfc2833Disabled;
    }
    /**
     * Set rfc2833Disabled value
     * @param string $rfc2833Disabled
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setRfc2833Disabled($rfc2833Disabled = 'false')
    {
        $this->rfc2833Disabled = $rfc2833Disabled;
        return $this;
    }
    /**
     * Get authenticationMode value
     * @return string|null
     */
    public function getAuthenticationMode()
    {
        return $this->authenticationMode;
    }
    /**
     * Set authenticationMode value
     * @param string $authenticationMode
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setAuthenticationMode($authenticationMode = 'By Null String')
    {
        $this->authenticationMode = $authenticationMode;
        return $this;
    }
    /**
     * Get keySize value
     * @return string|null
     */
    public function getKeySize()
    {
        return $this->keySize;
    }
    /**
     * Set keySize value
     * @param string $keySize
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setKeySize($keySize = '1024')
    {
        $this->keySize = $keySize;
        return $this;
    }
    /**
     * Get authenticationString value
     * @return string|null
     */
    public function getAuthenticationString()
    {
        return $this->authenticationString;
    }
    /**
     * Set authenticationString value
     * @param string $authenticationString
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setAuthenticationString($authenticationString = null)
    {
        $this->authenticationString = $authenticationString;
        return $this;
    }
    /**
     * Get upgradeFinishTime value
     * @return string|null
     */
    public function getUpgradeFinishTime()
    {
        return $this->upgradeFinishTime;
    }
    /**
     * Set upgradeFinishTime value
     * @param string $upgradeFinishTime
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setUpgradeFinishTime($upgradeFinishTime = null)
    {
        $this->upgradeFinishTime = $upgradeFinishTime;
        return $this;
    }
    /**
     * Get remoteDevice value
     * @return string|null
     */
    public function getRemoteDevice()
    {
        return $this->remoteDevice;
    }
    /**
     * Set remoteDevice value
     * @param string $remoteDevice
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setRemoteDevice($remoteDevice = 'false')
    {
        $this->remoteDevice = $remoteDevice;
        return $this;
    }
    /**
     * Get dndOption value
     * @return string|null
     */
    public function getDndOption()
    {
        return $this->dndOption;
    }
    /**
     * Set dndOption value
     * @param string $dndOption
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setDndOption($dndOption = 'Ringer Off')
    {
        $this->dndOption = $dndOption;
        return $this;
    }
    /**
     * Get dndRingSetting value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDndRingSetting()
    {
        return isset($this->dndRingSetting) ? $this->dndRingSetting : null;
    }
    /**
     * Set dndRingSetting value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dndRingSetting
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setDndRingSetting($dndRingSetting = null)
    {
        if (is_null($dndRingSetting) || (is_array($dndRingSetting) && empty($dndRingSetting))) {
            unset($this->dndRingSetting);
        } else {
            $this->dndRingSetting = $dndRingSetting;
        }
        return $this;
    }
    /**
     * Get dndStatus value
     * @return string|null
     */
    public function getDndStatus()
    {
        return $this->dndStatus;
    }
    /**
     * Set dndStatus value
     * @param string $dndStatus
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setDndStatus($dndStatus = null)
    {
        $this->dndStatus = $dndStatus;
        return $this;
    }
    /**
     * Get isActive value
     * @return string|null
     */
    public function getIsActive()
    {
        return $this->isActive;
    }
    /**
     * Set isActive value
     * @param string $isActive
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setIsActive($isActive = 'true')
    {
        $this->isActive = $isActive;
        return $this;
    }
    /**
     * Get isDualMode value
     * @return string|null
     */
    public function getIsDualMode()
    {
        return $this->isDualMode;
    }
    /**
     * Set isDualMode value
     * @param string $isDualMode
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setIsDualMode($isDualMode = null)
    {
        $this->isDualMode = $isDualMode;
        return $this;
    }
    /**
     * Get mobilityUserIdName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getMobilityUserIdName()
    {
        return isset($this->mobilityUserIdName) ? $this->mobilityUserIdName : null;
    }
    /**
     * Set mobilityUserIdName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mobilityUserIdName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setMobilityUserIdName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mobilityUserIdName = null)
    {
        if (is_null($mobilityUserIdName) || (is_array($mobilityUserIdName) && empty($mobilityUserIdName))) {
            unset($this->mobilityUserIdName);
        } else {
            $this->mobilityUserIdName = $mobilityUserIdName;
        }
        return $this;
    }
    /**
     * Get phoneSuite value
     * @return string|null
     */
    public function getPhoneSuite()
    {
        return $this->phoneSuite;
    }
    /**
     * Set phoneSuite value
     * @param string $phoneSuite
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setPhoneSuite($phoneSuite = 'Default')
    {
        $this->phoneSuite = $phoneSuite;
        return $this;
    }
    /**
     * Get phoneServiceDisplay value
     * @return string|null
     */
    public function getPhoneServiceDisplay()
    {
        return $this->phoneServiceDisplay;
    }
    /**
     * Set phoneServiceDisplay value
     * @param string $phoneServiceDisplay
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setPhoneServiceDisplay($phoneServiceDisplay = 'Default')
    {
        $this->phoneServiceDisplay = $phoneServiceDisplay;
        return $this;
    }
    /**
     * Get isProtected value
     * @return string|null
     */
    public function getIsProtected()
    {
        return $this->isProtected;
    }
    /**
     * Set isProtected value
     * @param string $isProtected
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setIsProtected($isProtected = 'false')
    {
        $this->isProtected = $isProtected;
        return $this;
    }
    /**
     * Get mtpRequired value
     * @return string|null
     */
    public function getMtpRequired()
    {
        return $this->mtpRequired;
    }
    /**
     * Set mtpRequired value
     * @param string $mtpRequired
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setMtpRequired($mtpRequired = null)
    {
        $this->mtpRequired = $mtpRequired;
        return $this;
    }
    /**
     * Get mtpPreferedCodec value
     * @return string|null
     */
    public function getMtpPreferedCodec()
    {
        return $this->mtpPreferedCodec;
    }
    /**
     * Set mtpPreferedCodec value
     * @param string $mtpPreferedCodec
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setMtpPreferedCodec($mtpPreferedCodec = '711ulaw')
    {
        $this->mtpPreferedCodec = $mtpPreferedCodec;
        return $this;
    }
    /**
     * Get dialRulesName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDialRulesName()
    {
        return isset($this->dialRulesName) ? $this->dialRulesName : null;
    }
    /**
     * Set dialRulesName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialRulesName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setDialRulesName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dialRulesName = null)
    {
        if (is_null($dialRulesName) || (is_array($dialRulesName) && empty($dialRulesName))) {
            unset($this->dialRulesName);
        } else {
            $this->dialRulesName = $dialRulesName;
        }
        return $this;
    }
    /**
     * Get sshUserId value
     * @return string|null
     */
    public function getSshUserId()
    {
        return $this->sshUserId;
    }
    /**
     * Set sshUserId value
     * @param string $sshUserId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setSshUserId($sshUserId = null)
    {
        $this->sshUserId = $sshUserId;
        return $this;
    }
    /**
     * Get sshPwd value
     * @return string|null
     */
    public function getSshPwd()
    {
        return $this->sshPwd;
    }
    /**
     * Set sshPwd value
     * @param string $sshPwd
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setSshPwd($sshPwd = null)
    {
        $this->sshPwd = $sshPwd;
        return $this;
    }
    /**
     * Get digestUser value
     * @return string|null
     */
    public function getDigestUser()
    {
        return $this->digestUser;
    }
    /**
     * Set digestUser value
     * @param string $digestUser
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setDigestUser($digestUser = null)
    {
        $this->digestUser = $digestUser;
        return $this;
    }
    /**
     * Get outboundCallRollover value
     * @return string|null
     */
    public function getOutboundCallRollover()
    {
        return $this->outboundCallRollover;
    }
    /**
     * Set outboundCallRollover value
     * @param string $outboundCallRollover
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setOutboundCallRollover($outboundCallRollover = 'No Rollover')
    {
        $this->outboundCallRollover = $outboundCallRollover;
        return $this;
    }
    /**
     * Get hotlineDevice value
     * @return string|null
     */
    public function getHotlineDevice()
    {
        return $this->hotlineDevice;
    }
    /**
     * Set hotlineDevice value
     * @param string $hotlineDevice
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setHotlineDevice($hotlineDevice = 'false')
    {
        $this->hotlineDevice = $hotlineDevice;
        return $this;
    }
    /**
     * Get secureInformationUrl value
     * @return string|null
     */
    public function getSecureInformationUrl()
    {
        return $this->secureInformationUrl;
    }
    /**
     * Set secureInformationUrl value
     * @param string $secureInformationUrl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setSecureInformationUrl($secureInformationUrl = null)
    {
        $this->secureInformationUrl = $secureInformationUrl;
        return $this;
    }
    /**
     * Get secureDirectoryUrl value
     * @return string|null
     */
    public function getSecureDirectoryUrl()
    {
        return $this->secureDirectoryUrl;
    }
    /**
     * Set secureDirectoryUrl value
     * @param string $secureDirectoryUrl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setSecureDirectoryUrl($secureDirectoryUrl = null)
    {
        $this->secureDirectoryUrl = $secureDirectoryUrl;
        return $this;
    }
    /**
     * Get secureMessageUrl value
     * @return string|null
     */
    public function getSecureMessageUrl()
    {
        return $this->secureMessageUrl;
    }
    /**
     * Set secureMessageUrl value
     * @param string $secureMessageUrl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setSecureMessageUrl($secureMessageUrl = null)
    {
        $this->secureMessageUrl = $secureMessageUrl;
        return $this;
    }
    /**
     * Get secureServicesUrl value
     * @return string|null
     */
    public function getSecureServicesUrl()
    {
        return $this->secureServicesUrl;
    }
    /**
     * Set secureServicesUrl value
     * @param string $secureServicesUrl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setSecureServicesUrl($secureServicesUrl = null)
    {
        $this->secureServicesUrl = $secureServicesUrl;
        return $this;
    }
    /**
     * Get secureAuthenticationUrl value
     * @return string|null
     */
    public function getSecureAuthenticationUrl()
    {
        return $this->secureAuthenticationUrl;
    }
    /**
     * Set secureAuthenticationUrl value
     * @param string $secureAuthenticationUrl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setSecureAuthenticationUrl($secureAuthenticationUrl = null)
    {
        $this->secureAuthenticationUrl = $secureAuthenticationUrl;
        return $this;
    }
    /**
     * Get secureIdleUrl value
     * @return string|null
     */
    public function getSecureIdleUrl()
    {
        return $this->secureIdleUrl;
    }
    /**
     * Set secureIdleUrl value
     * @param string $secureIdleUrl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setSecureIdleUrl($secureIdleUrl = null)
    {
        $this->secureIdleUrl = $secureIdleUrl;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLine value
     * @return string|null
     */
    public function getAlwaysUsePrimeLine()
    {
        return $this->alwaysUsePrimeLine;
    }
    /**
     * Set alwaysUsePrimeLine value
     * @param string $alwaysUsePrimeLine
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setAlwaysUsePrimeLine($alwaysUsePrimeLine = 'Default')
    {
        $this->alwaysUsePrimeLine = $alwaysUsePrimeLine;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLineForVoiceMessage value
     * @return string|null
     */
    public function getAlwaysUsePrimeLineForVoiceMessage()
    {
        return $this->alwaysUsePrimeLineForVoiceMessage;
    }
    /**
     * Set alwaysUsePrimeLineForVoiceMessage value
     * @param string $alwaysUsePrimeLineForVoiceMessage
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage = 'Default')
    {
        $this->alwaysUsePrimeLineForVoiceMessage = $alwaysUsePrimeLineForVoiceMessage;
        return $this;
    }
    /**
     * Get featureControlPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getFeatureControlPolicy()
    {
        return isset($this->featureControlPolicy) ? $this->featureControlPolicy : null;
    }
    /**
     * Set featureControlPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $featureControlPolicy
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setFeatureControlPolicy(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $featureControlPolicy = null)
    {
        if (is_null($featureControlPolicy) || (is_array($featureControlPolicy) && empty($featureControlPolicy))) {
            unset($this->featureControlPolicy);
        } else {
            $this->featureControlPolicy = $featureControlPolicy;
        }
        return $this;
    }
    /**
     * Get deviceTrustMode value
     * @return string|null
     */
    public function getDeviceTrustMode()
    {
        return $this->deviceTrustMode;
    }
    /**
     * Set deviceTrustMode value
     * @param string $deviceTrustMode
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setDeviceTrustMode($deviceTrustMode = 'Not Trusted')
    {
        $this->deviceTrustMode = $deviceTrustMode;
        return $this;
    }
    /**
     * Get earlyOfferSupportForVoiceCall value
     * @return string|null
     */
    public function getEarlyOfferSupportForVoiceCall()
    {
        return $this->earlyOfferSupportForVoiceCall;
    }
    /**
     * Set earlyOfferSupportForVoiceCall value
     * @param string $earlyOfferSupportForVoiceCall
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setEarlyOfferSupportForVoiceCall($earlyOfferSupportForVoiceCall = 'false')
    {
        $this->earlyOfferSupportForVoiceCall = $earlyOfferSupportForVoiceCall;
        return $this;
    }
    /**
     * Get requireThirdPartyRegistration value
     * @return string|null
     */
    public function getRequireThirdPartyRegistration()
    {
        return $this->requireThirdPartyRegistration;
    }
    /**
     * Set requireThirdPartyRegistration value
     * @param string $requireThirdPartyRegistration
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setRequireThirdPartyRegistration($requireThirdPartyRegistration = null)
    {
        $this->requireThirdPartyRegistration = $requireThirdPartyRegistration;
        return $this;
    }
    /**
     * Get blockIncomingCallsWhenRoaming value
     * @return string|null
     */
    public function getBlockIncomingCallsWhenRoaming()
    {
        return $this->blockIncomingCallsWhenRoaming;
    }
    /**
     * Set blockIncomingCallsWhenRoaming value
     * @param string $blockIncomingCallsWhenRoaming
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setBlockIncomingCallsWhenRoaming($blockIncomingCallsWhenRoaming = null)
    {
        $this->blockIncomingCallsWhenRoaming = $blockIncomingCallsWhenRoaming;
        return $this;
    }
    /**
     * Get homeNetworkId value
     * @return string|null
     */
    public function getHomeNetworkId()
    {
        return $this->homeNetworkId;
    }
    /**
     * Set homeNetworkId value
     * @param string $homeNetworkId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setHomeNetworkId($homeNetworkId = null)
    {
        $this->homeNetworkId = $homeNetworkId;
        return $this;
    }
    /**
     * Get AllowPresentationSharingUsingBfcp value
     * @return string|null
     */
    public function getAllowPresentationSharingUsingBfcp()
    {
        return $this->AllowPresentationSharingUsingBfcp;
    }
    /**
     * Set AllowPresentationSharingUsingBfcp value
     * @param string $allowPresentationSharingUsingBfcp
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setAllowPresentationSharingUsingBfcp($allowPresentationSharingUsingBfcp = 'false')
    {
        $this->AllowPresentationSharingUsingBfcp = $allowPresentationSharingUsingBfcp;
        return $this;
    }
    /**
     * Get confidentialAccess value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess|null
     */
    public function getConfidentialAccess()
    {
        return $this->confidentialAccess;
    }
    /**
     * Set confidentialAccess value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setConfidentialAccess(\\Losc\CucmBundle\Model\Webservice\StructType\ConfidentialAccess $confidentialAccess = null)
    {
        $this->confidentialAccess = $confidentialAccess;
        return $this;
    }
    /**
     * Get requireOffPremiseLocation value
     * @return string|null
     */
    public function getRequireOffPremiseLocation()
    {
        return $this->requireOffPremiseLocation;
    }
    /**
     * Set requireOffPremiseLocation value
     * @param string $requireOffPremiseLocation
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setRequireOffPremiseLocation($requireOffPremiseLocation = 'false')
    {
        $this->requireOffPremiseLocation = $requireOffPremiseLocation;
        return $this;
    }
    /**
     * Get allowiXApplicableMedia value
     * @return string|null
     */
    public function getAllowiXApplicableMedia()
    {
        return $this->allowiXApplicableMedia;
    }
    /**
     * Set allowiXApplicableMedia value
     * @param string $allowiXApplicableMedia
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setAllowiXApplicableMedia($allowiXApplicableMedia = 'false')
    {
        $this->allowiXApplicableMedia = $allowiXApplicableMedia;
        return $this;
    }
    /**
     * Get cgpnIngressDN value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCgpnIngressDN()
    {
        return isset($this->cgpnIngressDN) ? $this->cgpnIngressDN : null;
    }
    /**
     * Set cgpnIngressDN value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnIngressDN
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setCgpnIngressDN(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnIngressDN = null)
    {
        if (is_null($cgpnIngressDN) || (is_array($cgpnIngressDN) && empty($cgpnIngressDN))) {
            unset($this->cgpnIngressDN);
        } else {
            $this->cgpnIngressDN = $cgpnIngressDN;
        }
        return $this;
    }
    /**
     * Get useDevicePoolCgpnIngressDN value
     * @return string|null
     */
    public function getUseDevicePoolCgpnIngressDN()
    {
        return $this->useDevicePoolCgpnIngressDN;
    }
    /**
     * Set useDevicePoolCgpnIngressDN value
     * @param string $useDevicePoolCgpnIngressDN
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setUseDevicePoolCgpnIngressDN($useDevicePoolCgpnIngressDN = 'true')
    {
        $this->useDevicePoolCgpnIngressDN = $useDevicePoolCgpnIngressDN;
        return $this;
    }
    /**
     * Get msisdn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMsisdn()
    {
        return isset($this->msisdn) ? $this->msisdn : null;
    }
    /**
     * Set msisdn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $msisdn
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setMsisdn($msisdn = null)
    {
        if (is_null($msisdn) || (is_array($msisdn) && empty($msisdn))) {
            unset($this->msisdn);
        } else {
            $this->msisdn = $msisdn;
        }
        return $this;
    }
    /**
     * Get enableCallRoutingToRdWhenNoneIsActive value
     * @return string|null
     */
    public function getEnableCallRoutingToRdWhenNoneIsActive()
    {
        return $this->enableCallRoutingToRdWhenNoneIsActive;
    }
    /**
     * Set enableCallRoutingToRdWhenNoneIsActive value
     * @param string $enableCallRoutingToRdWhenNoneIsActive
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setEnableCallRoutingToRdWhenNoneIsActive($enableCallRoutingToRdWhenNoneIsActive = 'false')
    {
        $this->enableCallRoutingToRdWhenNoneIsActive = $enableCallRoutingToRdWhenNoneIsActive;
        return $this;
    }
    /**
     * Get wifiHotspotProfile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getWifiHotspotProfile()
    {
        return isset($this->wifiHotspotProfile) ? $this->wifiHotspotProfile : null;
    }
    /**
     * Set wifiHotspotProfile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $wifiHotspotProfile
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setWifiHotspotProfile(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $wifiHotspotProfile = null)
    {
        if (is_null($wifiHotspotProfile) || (is_array($wifiHotspotProfile) && empty($wifiHotspotProfile))) {
            unset($this->wifiHotspotProfile);
        } else {
            $this->wifiHotspotProfile = $wifiHotspotProfile;
        }
        return $this;
    }
    /**
     * Get wirelessLanProfileGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getWirelessLanProfileGroup()
    {
        return isset($this->wirelessLanProfileGroup) ? $this->wirelessLanProfileGroup : null;
    }
    /**
     * Set wirelessLanProfileGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $wirelessLanProfileGroup
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setWirelessLanProfileGroup(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $wirelessLanProfileGroup = null)
    {
        if (is_null($wirelessLanProfileGroup) || (is_array($wirelessLanProfileGroup) && empty($wirelessLanProfileGroup))) {
            unset($this->wirelessLanProfileGroup);
        } else {
            $this->wirelessLanProfileGroup = $wirelessLanProfileGroup;
        }
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XPhone
     */
    public function setCtiid($ctiid = null)
    {
        $this->ctiid = $ctiid;
        return $this;
    }
}
