<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XIpPhoneServices StructType
 * @subpackage Structs
 */
class XIpPhoneServices extends AbstractStructBase
{
    /**
     * The serviceName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $serviceName;
    /**
     * The asciiServiceName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $asciiServiceName;
    /**
     * The serviceUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $serviceUrl;
    /**
     * The serviceCategory
     * Meta information extracted from the WSDL
     * - default: XML Service
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $serviceCategory;
    /**
     * The serviceType
     * Meta information extracted from the WSDL
     * - default: Standard IP Phone Service
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $serviceType;
    /**
     * The serviceDescription
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $serviceDescription;
    /**
     * The secureServiceUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $secureServiceUrl;
    /**
     * The serviceVendor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $serviceVendor;
    /**
     * The serviceVersion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $serviceVersion;
    /**
     * The enabled
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enabled;
    /**
     * The enterpriseSubscription
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enterpriseSubscription;
    /**
     * The parameters
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\Parameters
     */
    public $parameters;
    /**
     * Constructor method for XIpPhoneServices
     * @uses XIpPhoneServices::setServiceName()
     * @uses XIpPhoneServices::setAsciiServiceName()
     * @uses XIpPhoneServices::setServiceUrl()
     * @uses XIpPhoneServices::setServiceCategory()
     * @uses XIpPhoneServices::setServiceType()
     * @uses XIpPhoneServices::setServiceDescription()
     * @uses XIpPhoneServices::setSecureServiceUrl()
     * @uses XIpPhoneServices::setServiceVendor()
     * @uses XIpPhoneServices::setServiceVersion()
     * @uses XIpPhoneServices::setEnabled()
     * @uses XIpPhoneServices::setEnterpriseSubscription()
     * @uses XIpPhoneServices::setParameters()
     * @param string $serviceName
     * @param string $asciiServiceName
     * @param string $serviceUrl
     * @param string $serviceCategory
     * @param string $serviceType
     * @param string $serviceDescription
     * @param string $secureServiceUrl
     * @param string $serviceVendor
     * @param string $serviceVersion
     * @param string $enabled
     * @param string $enterpriseSubscription
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Parameters $parameters
     */
    public function __construct($serviceName = null, $asciiServiceName = null, $serviceUrl = null, $serviceCategory = 'XML Service', $serviceType = 'Standard IP Phone Service', $serviceDescription = null, $secureServiceUrl = null, $serviceVendor = null, $serviceVersion = null, $enabled = 'true', $enterpriseSubscription = 'false', \\Losc\CucmBundle\Model\Webservice\StructType\Parameters $parameters = null)
    {
        $this
            ->setServiceName($serviceName)
            ->setAsciiServiceName($asciiServiceName)
            ->setServiceUrl($serviceUrl)
            ->setServiceCategory($serviceCategory)
            ->setServiceType($serviceType)
            ->setServiceDescription($serviceDescription)
            ->setSecureServiceUrl($secureServiceUrl)
            ->setServiceVendor($serviceVendor)
            ->setServiceVersion($serviceVersion)
            ->setEnabled($enabled)
            ->setEnterpriseSubscription($enterpriseSubscription)
            ->setParameters($parameters);
    }
    /**
     * Get serviceName value
     * @return string
     */
    public function getServiceName()
    {
        return $this->serviceName;
    }
    /**
     * Set serviceName value
     * @param string $serviceName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XIpPhoneServices
     */
    public function setServiceName($serviceName = null)
    {
        $this->serviceName = $serviceName;
        return $this;
    }
    /**
     * Get asciiServiceName value
     * @return string
     */
    public function getAsciiServiceName()
    {
        return $this->asciiServiceName;
    }
    /**
     * Set asciiServiceName value
     * @param string $asciiServiceName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XIpPhoneServices
     */
    public function setAsciiServiceName($asciiServiceName = null)
    {
        $this->asciiServiceName = $asciiServiceName;
        return $this;
    }
    /**
     * Get serviceUrl value
     * @return string
     */
    public function getServiceUrl()
    {
        return $this->serviceUrl;
    }
    /**
     * Set serviceUrl value
     * @param string $serviceUrl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XIpPhoneServices
     */
    public function setServiceUrl($serviceUrl = null)
    {
        $this->serviceUrl = $serviceUrl;
        return $this;
    }
    /**
     * Get serviceCategory value
     * @return string
     */
    public function getServiceCategory()
    {
        return $this->serviceCategory;
    }
    /**
     * Set serviceCategory value
     * @param string $serviceCategory
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XIpPhoneServices
     */
    public function setServiceCategory($serviceCategory = 'XML Service')
    {
        $this->serviceCategory = $serviceCategory;
        return $this;
    }
    /**
     * Get serviceType value
     * @return string
     */
    public function getServiceType()
    {
        return $this->serviceType;
    }
    /**
     * Set serviceType value
     * @param string $serviceType
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XIpPhoneServices
     */
    public function setServiceType($serviceType = 'Standard IP Phone Service')
    {
        $this->serviceType = $serviceType;
        return $this;
    }
    /**
     * Get serviceDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceDescription()
    {
        return isset($this->serviceDescription) ? $this->serviceDescription : null;
    }
    /**
     * Set serviceDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceDescription
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XIpPhoneServices
     */
    public function setServiceDescription($serviceDescription = null)
    {
        if (is_null($serviceDescription) || (is_array($serviceDescription) && empty($serviceDescription))) {
            unset($this->serviceDescription);
        } else {
            $this->serviceDescription = $serviceDescription;
        }
        return $this;
    }
    /**
     * Get secureServiceUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecureServiceUrl()
    {
        return isset($this->secureServiceUrl) ? $this->secureServiceUrl : null;
    }
    /**
     * Set secureServiceUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $secureServiceUrl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XIpPhoneServices
     */
    public function setSecureServiceUrl($secureServiceUrl = null)
    {
        if (is_null($secureServiceUrl) || (is_array($secureServiceUrl) && empty($secureServiceUrl))) {
            unset($this->secureServiceUrl);
        } else {
            $this->secureServiceUrl = $secureServiceUrl;
        }
        return $this;
    }
    /**
     * Get serviceVendor value
     * @return string|null
     */
    public function getServiceVendor()
    {
        return $this->serviceVendor;
    }
    /**
     * Set serviceVendor value
     * @param string $serviceVendor
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XIpPhoneServices
     */
    public function setServiceVendor($serviceVendor = null)
    {
        $this->serviceVendor = $serviceVendor;
        return $this;
    }
    /**
     * Get serviceVersion value
     * @return string|null
     */
    public function getServiceVersion()
    {
        return $this->serviceVersion;
    }
    /**
     * Set serviceVersion value
     * @param string $serviceVersion
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XIpPhoneServices
     */
    public function setServiceVersion($serviceVersion = null)
    {
        $this->serviceVersion = $serviceVersion;
        return $this;
    }
    /**
     * Get enabled value
     * @return string|null
     */
    public function getEnabled()
    {
        return $this->enabled;
    }
    /**
     * Set enabled value
     * @param string $enabled
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XIpPhoneServices
     */
    public function setEnabled($enabled = 'true')
    {
        $this->enabled = $enabled;
        return $this;
    }
    /**
     * Get enterpriseSubscription value
     * @return string|null
     */
    public function getEnterpriseSubscription()
    {
        return $this->enterpriseSubscription;
    }
    /**
     * Set enterpriseSubscription value
     * @param string $enterpriseSubscription
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XIpPhoneServices
     */
    public function setEnterpriseSubscription($enterpriseSubscription = 'false')
    {
        $this->enterpriseSubscription = $enterpriseSubscription;
        return $this;
    }
    /**
     * Get parameters value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\Parameters|null
     */
    public function getParameters()
    {
        return $this->parameters;
    }
    /**
     * Set parameters value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Parameters $parameters
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XIpPhoneServices
     */
    public function setParameters(\\Losc\CucmBundle\Model\Webservice\StructType\Parameters $parameters = null)
    {
        $this->parameters = $parameters;
        return $this;
    }
}
