<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XGatekeeper StructType
 * @subpackage Structs
 */
class XGatekeeper extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: From Device Table
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The rrqTimeToLive
     * Meta information extracted from the WSDL
     * - documentation: Value should be numbers in range of 30 to 300
     * - default: 60
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $rrqTimeToLive;
    /**
     * The retryTimeout
     * Meta information extracted from the WSDL
     * - documentation: Value should be numbers in range of 30 to 600
     * - default: 300
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $retryTimeout;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - documentation: From Device Table
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The enableDevice
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableDevice;
    /**
     * Constructor method for XGatekeeper
     * @uses XGatekeeper::setName()
     * @uses XGatekeeper::setRrqTimeToLive()
     * @uses XGatekeeper::setRetryTimeout()
     * @uses XGatekeeper::setDescription()
     * @uses XGatekeeper::setEnableDevice()
     * @param string $name
     * @param string $rrqTimeToLive
     * @param string $retryTimeout
     * @param string $description
     * @param string $enableDevice
     */
    public function __construct($name = null, $rrqTimeToLive = '60', $retryTimeout = '300', $description = null, $enableDevice = 'true')
    {
        $this
            ->setName($name)
            ->setRrqTimeToLive($rrqTimeToLive)
            ->setRetryTimeout($retryTimeout)
            ->setDescription($description)
            ->setEnableDevice($enableDevice);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatekeeper
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get rrqTimeToLive value
     * @return string
     */
    public function getRrqTimeToLive()
    {
        return $this->rrqTimeToLive;
    }
    /**
     * Set rrqTimeToLive value
     * @param string $rrqTimeToLive
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatekeeper
     */
    public function setRrqTimeToLive($rrqTimeToLive = '60')
    {
        $this->rrqTimeToLive = $rrqTimeToLive;
        return $this;
    }
    /**
     * Get retryTimeout value
     * @return string
     */
    public function getRetryTimeout()
    {
        return $this->retryTimeout;
    }
    /**
     * Set retryTimeout value
     * @param string $retryTimeout
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatekeeper
     */
    public function setRetryTimeout($retryTimeout = '300')
    {
        $this->retryTimeout = $retryTimeout;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatekeeper
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get enableDevice value
     * @return string|null
     */
    public function getEnableDevice()
    {
        return $this->enableDevice;
    }
    /**
     * Set enableDevice value
     * @param string $enableDevice
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XGatekeeper
     */
    public function setEnableDevice($enableDevice = 'true')
    {
        $this->enableDevice = $enableDevice;
        return $this;
    }
}
