<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XCredentialPolicy StructType
 * @subpackage Structs
 */
class XCredentialPolicy extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The failedLogon
     * Meta information extracted from the WSDL
     * - documentation: Failed logon must be a number in the range 0 to 100. If 0 is entered, NoLimitForFailedLogon is true
     * - default: 3
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $failedLogon;
    /**
     * The resetFailedLogonAttempts
     * Meta information extracted from the WSDL
     * - documentation: Reset Failed logon attempts must be a number in the range 1 to 120. (minutes)
     * - default: 30
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $resetFailedLogonAttempts;
    /**
     * The lockoutDuration
     * Meta information extracted from the WSDL
     * - documentation: Lockout duration must be a number in the range 0 to 1440. (minutes), If 0 is entered then Administrator Must Unlock is true.
     * - default: 30
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $lockoutDuration;
    /**
     * The credChangeDuration
     * Meta information extracted from the WSDL
     * - documentation: Credential change duration must be a number in the range 0 to 129600. (minutes)
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $credChangeDuration;
    /**
     * The credExpiresAfter
     * Meta information extracted from the WSDL
     * - documentation: Credential expires after must be a number in the range 0 to 365. (Days). If 0 is entered, then neverExpires is true
     * - default: 180
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $credExpiresAfter;
    /**
     * The minCredLength
     * Meta information extracted from the WSDL
     * - documentation: Minimum credential length must be a number in the range 0 to 64.
     * - default: 8
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $minCredLength;
    /**
     * The prevCredStoredNum
     * Meta information extracted from the WSDL
     * - documentation: Stored number of previous credentials must be a number in the range 0 to 25.
     * - default: 12
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $prevCredStoredNum;
    /**
     * The inactiveDaysAllowed
     * Meta information extracted from the WSDL
     * - documentation: Inactive days allowed must be a number in the range 0 to 5000.
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $inactiveDaysAllowed;
    /**
     * The expiryWarningDays
     * Meta information extracted from the WSDL
     * - documentation: Expiry warning days must be a number in the range 0 to 90.
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $expiryWarningDays;
    /**
     * The trivialCredCheck
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $trivialCredCheck;
    /**
     * Constructor method for XCredentialPolicy
     * @uses XCredentialPolicy::setName()
     * @uses XCredentialPolicy::setFailedLogon()
     * @uses XCredentialPolicy::setResetFailedLogonAttempts()
     * @uses XCredentialPolicy::setLockoutDuration()
     * @uses XCredentialPolicy::setCredChangeDuration()
     * @uses XCredentialPolicy::setCredExpiresAfter()
     * @uses XCredentialPolicy::setMinCredLength()
     * @uses XCredentialPolicy::setPrevCredStoredNum()
     * @uses XCredentialPolicy::setInactiveDaysAllowed()
     * @uses XCredentialPolicy::setExpiryWarningDays()
     * @uses XCredentialPolicy::setTrivialCredCheck()
     * @param string $name
     * @param string $failedLogon
     * @param string $resetFailedLogonAttempts
     * @param string $lockoutDuration
     * @param string $credChangeDuration
     * @param string $credExpiresAfter
     * @param string $minCredLength
     * @param string $prevCredStoredNum
     * @param string $inactiveDaysAllowed
     * @param string $expiryWarningDays
     * @param string $trivialCredCheck
     */
    public function __construct($name = null, $failedLogon = '3', $resetFailedLogonAttempts = '30', $lockoutDuration = '30', $credChangeDuration = '0', $credExpiresAfter = '180', $minCredLength = '8', $prevCredStoredNum = '12', $inactiveDaysAllowed = '0', $expiryWarningDays = '0', $trivialCredCheck = 'true')
    {
        $this
            ->setName($name)
            ->setFailedLogon($failedLogon)
            ->setResetFailedLogonAttempts($resetFailedLogonAttempts)
            ->setLockoutDuration($lockoutDuration)
            ->setCredChangeDuration($credChangeDuration)
            ->setCredExpiresAfter($credExpiresAfter)
            ->setMinCredLength($minCredLength)
            ->setPrevCredStoredNum($prevCredStoredNum)
            ->setInactiveDaysAllowed($inactiveDaysAllowed)
            ->setExpiryWarningDays($expiryWarningDays)
            ->setTrivialCredCheck($trivialCredCheck);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCredentialPolicy
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get failedLogon value
     * @return string
     */
    public function getFailedLogon()
    {
        return $this->failedLogon;
    }
    /**
     * Set failedLogon value
     * @param string $failedLogon
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCredentialPolicy
     */
    public function setFailedLogon($failedLogon = '3')
    {
        $this->failedLogon = $failedLogon;
        return $this;
    }
    /**
     * Get resetFailedLogonAttempts value
     * @return string
     */
    public function getResetFailedLogonAttempts()
    {
        return $this->resetFailedLogonAttempts;
    }
    /**
     * Set resetFailedLogonAttempts value
     * @param string $resetFailedLogonAttempts
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCredentialPolicy
     */
    public function setResetFailedLogonAttempts($resetFailedLogonAttempts = '30')
    {
        $this->resetFailedLogonAttempts = $resetFailedLogonAttempts;
        return $this;
    }
    /**
     * Get lockoutDuration value
     * @return string
     */
    public function getLockoutDuration()
    {
        return $this->lockoutDuration;
    }
    /**
     * Set lockoutDuration value
     * @param string $lockoutDuration
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCredentialPolicy
     */
    public function setLockoutDuration($lockoutDuration = '30')
    {
        $this->lockoutDuration = $lockoutDuration;
        return $this;
    }
    /**
     * Get credChangeDuration value
     * @return string
     */
    public function getCredChangeDuration()
    {
        return $this->credChangeDuration;
    }
    /**
     * Set credChangeDuration value
     * @param string $credChangeDuration
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCredentialPolicy
     */
    public function setCredChangeDuration($credChangeDuration = '0')
    {
        $this->credChangeDuration = $credChangeDuration;
        return $this;
    }
    /**
     * Get credExpiresAfter value
     * @return string
     */
    public function getCredExpiresAfter()
    {
        return $this->credExpiresAfter;
    }
    /**
     * Set credExpiresAfter value
     * @param string $credExpiresAfter
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCredentialPolicy
     */
    public function setCredExpiresAfter($credExpiresAfter = '180')
    {
        $this->credExpiresAfter = $credExpiresAfter;
        return $this;
    }
    /**
     * Get minCredLength value
     * @return string
     */
    public function getMinCredLength()
    {
        return $this->minCredLength;
    }
    /**
     * Set minCredLength value
     * @param string $minCredLength
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCredentialPolicy
     */
    public function setMinCredLength($minCredLength = '8')
    {
        $this->minCredLength = $minCredLength;
        return $this;
    }
    /**
     * Get prevCredStoredNum value
     * @return string
     */
    public function getPrevCredStoredNum()
    {
        return $this->prevCredStoredNum;
    }
    /**
     * Set prevCredStoredNum value
     * @param string $prevCredStoredNum
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCredentialPolicy
     */
    public function setPrevCredStoredNum($prevCredStoredNum = '12')
    {
        $this->prevCredStoredNum = $prevCredStoredNum;
        return $this;
    }
    /**
     * Get inactiveDaysAllowed value
     * @return string
     */
    public function getInactiveDaysAllowed()
    {
        return $this->inactiveDaysAllowed;
    }
    /**
     * Set inactiveDaysAllowed value
     * @param string $inactiveDaysAllowed
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCredentialPolicy
     */
    public function setInactiveDaysAllowed($inactiveDaysAllowed = '0')
    {
        $this->inactiveDaysAllowed = $inactiveDaysAllowed;
        return $this;
    }
    /**
     * Get expiryWarningDays value
     * @return string
     */
    public function getExpiryWarningDays()
    {
        return $this->expiryWarningDays;
    }
    /**
     * Set expiryWarningDays value
     * @param string $expiryWarningDays
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCredentialPolicy
     */
    public function setExpiryWarningDays($expiryWarningDays = '0')
    {
        $this->expiryWarningDays = $expiryWarningDays;
        return $this;
    }
    /**
     * Get trivialCredCheck value
     * @return string
     */
    public function getTrivialCredCheck()
    {
        return $this->trivialCredCheck;
    }
    /**
     * Set trivialCredCheck value
     * @param string $trivialCredCheck
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCredentialPolicy
     */
    public function setTrivialCredCheck($trivialCredCheck = 'true')
    {
        $this->trivialCredCheck = $trivialCredCheck;
        return $this;
    }
}
