<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XCiscoCatalyst6000T1VoIPGatewayPri StructType
 * @subpackage Structs
 */
class XCiscoCatalyst6000T1VoIPGatewayPri extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: The device name,using only URL-friendly characters
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The product
     * Meta information extracted from the WSDL
     * - documentation: Product ID string. read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $product;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - documentation: Class ID string. Class information is read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $class;
    /**
     * The protocol
     * Meta information extracted from the WSDL
     * - documentation: Protocol option is read-only,except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $protocol;
    /**
     * The protocolSide
     * Meta information extracted from the WSDL
     * - documentation: Side information is read-only except when creating a device
     * - default: User
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $protocolSide;
    /**
     * The devicePoolName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $devicePoolName;
    /**
     * The locationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $locationName;
    /**
     * The redirectInboundNumberIe
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $redirectInboundNumberIe;
    /**
     * The calledPlan
     * Meta information extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $calledPlan;
    /**
     * The calledPri
     * Meta information extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $calledPri;
    /**
     * The callingPartySelection
     * Meta information extracted from the WSDL
     * - default: Originator
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $callingPartySelection;
    /**
     * The callingPlan
     * Meta information extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $callingPlan;
    /**
     * The callingPri
     * Meta information extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $callingPri;
    /**
     * The chanIe
     * Meta information extracted from the WSDL
     * - default: Use Number when 1B
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $chanIe;
    /**
     * The clockReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $clockReference;
    /**
     * The dChannelEnable
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $dChannelEnable;
    /**
     * The channelSelectionOrder
     * Meta information extracted from the WSDL
     * - default: Top Down
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $channelSelectionOrder;
    /**
     * The displayIE
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $displayIE;
    /**
     * The pcmType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $pcmType;
    /**
     * The csuParam
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $csuParam;
    /**
     * The firstDelay
     * Meta information extracted from the WSDL
     * - default: 32
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $firstDelay;
    /**
     * The interfaceIdPresent
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $interfaceIdPresent;
    /**
     * The interfaceId
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $interfaceId;
    /**
     * The intraDelay
     * Meta information extracted from the WSDL
     * - default: 4
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $intraDelay;
    /**
     * The mcdnEnable
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $mcdnEnable;
    /**
     * The redirectOutboundNumberIe
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $redirectOutboundNumberIe;
    /**
     * The numDigitsToStrip
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $numDigitsToStrip;
    /**
     * The passingPrecedenceLevelThrough
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $passingPrecedenceLevelThrough;
    /**
     * The callingLinePresentationBit
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $callingLinePresentationBit;
    /**
     * The connectedLineIdPresentation
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $connectedLineIdPresentation;
    /**
     * The priProtocol
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $priProtocol;
    /**
     * The securityAccessLevel
     * Meta information extracted from the WSDL
     * - default: 2
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $securityAccessLevel;
    /**
     * The sendCallingNameInFacilityIe
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $sendCallingNameInFacilityIe;
    /**
     * The sendExLeadingCharInDispIe
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $sendExLeadingCharInDispIe;
    /**
     * The sendRestart
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $sendRestart;
    /**
     * The setupNonIsdnPi
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $setupNonIsdnPi;
    /**
     * The sigDigits
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * - nillable: false
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\SigDigits
     */
    public $sigDigits;
    /**
     * The span
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $span;
    /**
     * The statusPoll
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $statusPoll;
    /**
     * The smdiBasePort
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $smdiBasePort;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - documentation: Optional description of the device
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The callingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The commonDeviceConfigName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $commonDeviceConfigName;
    /**
     * The networkLocation
     * Meta information extracted from the WSDL
     * - documentation: The new Device Destination for Trunk to Trunk Transfer and Drop Conference Feature is required for most gateways ,except FXS gateways and phones.Not Nullable.
     * - default: Use System Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $networkLocation;
    /**
     * The networkLocale
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $networkLocale;
    /**
     * The mediaResourceListName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $mediaResourceListName;
    /**
     * The automatedAlternateRoutingCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $automatedAlternateRoutingCssName;
    /**
     * The aarNeighborhoodName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $aarNeighborhoodName;
    /**
     * The loadInformation
     * Meta information extracted from the WSDL
     * - documentation: For devices with load information, if any special load information is specified the special attribute is set to TRUE.Otherwise,the load information is default for the product.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation
     */
    public $loadInformation;
    /**
     * The vendorConfig
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig
     */
    public $vendorConfig;
    /**
     * The mlppDomainId
     * Meta information extracted from the WSDL
     * - documentation: This setting only effects devices that support MLPP. Use -1 to set to null
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $mlppDomainId;
    /**
     * The mlppIndicationStatus
     * Meta information extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - default: Off
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $mlppIndicationStatus;
    /**
     * The mlppPreemption
     * Meta information extracted from the WSDL
     * - documentation: This setting only affects devices that support MLPP.
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $mlppPreemption;
    /**
     * The useTrustedRelayPoint
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The cgpnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $cgpnTransformationCssName;
    /**
     * The useDevicePoolCgpnTransformCss
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCss;
    /**
     * The geoLocationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $geoLocationName;
    /**
     * The callerIdDn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callerIdDn;
    /**
     * The prefix
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $prefix;
    /**
     * The packetCaptureMode
     * Meta information extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $packetCaptureMode;
    /**
     * The packetCaptureDuration
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $packetCaptureDuration;
    /**
     * The transmitUtf8
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $transmitUtf8;
    /**
     * The v150
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $v150;
    /**
     * The asn1RoseOidEncoding
     * Meta information extracted from the WSDL
     * - documentation: Applicable for only if PRI variant is QSIG
     * - default: No Changes
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $asn1RoseOidEncoding;
    /**
     * The QSIGVariant
     * Meta information extracted from the WSDL
     * - documentation: Applicable for only PRI variant is QSIG
     * - default: No Changes
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $QSIGVariant;
    /**
     * The unattendedPort
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $unattendedPort;
    /**
     * The cdpnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $cdpnTransformationCssName;
    /**
     * The useDevicePoolCdpnTransformCss
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCdpnTransformCss;
    /**
     * The nationalPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $nationalPrefix;
    /**
     * The internationalPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $internationalPrefix;
    /**
     * The unknownPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $unknownPrefix;
    /**
     * The subscriberPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $subscriberPrefix;
    /**
     * The geoLocationFilterName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $geoLocationFilterName;
    /**
     * The nationalStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $nationalStripDigits;
    /**
     * The internationalStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $internationalStripDigits;
    /**
     * The unknownStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $unknownStripDigits;
    /**
     * The subscriberStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $subscriberStripDigits;
    /**
     * The nationalTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $nationalTransformationCssName;
    /**
     * The internationalTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $internationalTransformationCssName;
    /**
     * The unknownTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $unknownTransformationCssName;
    /**
     * The subscriberTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $subscriberTransformationCssName;
    /**
     * The useDevicePoolCgpnTransformCssNatl
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssNatl;
    /**
     * The useDevicePoolCgpnTransformCssIntl
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssIntl;
    /**
     * The useDevicePoolCgpnTransformCssUnkn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssUnkn;
    /**
     * The useDevicePoolCgpnTransformCssSubs
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssSubs;
    /**
     * The pstnAccess
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $pstnAccess;
    /**
     * The imeE164TransformationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $imeE164TransformationName;
    /**
     * Constructor method for XCiscoCatalyst6000T1VoIPGatewayPri
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setName()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setProduct()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setClass()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setProtocol()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setProtocolSide()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setDevicePoolName()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setLocationName()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setRedirectInboundNumberIe()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setCalledPlan()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setCalledPri()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setCallingPartySelection()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setCallingPlan()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setCallingPri()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setChanIe()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setClockReference()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setDChannelEnable()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setChannelSelectionOrder()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setDisplayIE()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setPcmType()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setCsuParam()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setFirstDelay()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setInterfaceIdPresent()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setInterfaceId()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setIntraDelay()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setMcdnEnable()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setRedirectOutboundNumberIe()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setNumDigitsToStrip()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setPassingPrecedenceLevelThrough()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setCallingLinePresentationBit()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setConnectedLineIdPresentation()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setPriProtocol()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setSecurityAccessLevel()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setSendCallingNameInFacilityIe()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setSendExLeadingCharInDispIe()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setSendRestart()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setSetupNonIsdnPi()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setSigDigits()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setSpan()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setStatusPoll()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setSmdiBasePort()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setDescription()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setCallingSearchSpaceName()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setCommonDeviceConfigName()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setNetworkLocation()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setNetworkLocale()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setMediaResourceListName()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setAutomatedAlternateRoutingCssName()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setAarNeighborhoodName()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setLoadInformation()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setVendorConfig()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setMlppDomainId()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setMlppIndicationStatus()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setMlppPreemption()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setUseTrustedRelayPoint()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setCgpnTransformationCssName()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setUseDevicePoolCgpnTransformCss()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setGeoLocationName()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setCallerIdDn()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setPrefix()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setPacketCaptureMode()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setPacketCaptureDuration()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setTransmitUtf8()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setV150()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setAsn1RoseOidEncoding()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setQSIGVariant()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setUnattendedPort()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setCdpnTransformationCssName()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setUseDevicePoolCdpnTransformCss()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setNationalPrefix()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setInternationalPrefix()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setUnknownPrefix()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setSubscriberPrefix()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setGeoLocationFilterName()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setNationalStripDigits()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setInternationalStripDigits()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setUnknownStripDigits()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setSubscriberStripDigits()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setNationalTransformationCssName()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setInternationalTransformationCssName()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setUnknownTransformationCssName()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setSubscriberTransformationCssName()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setUseDevicePoolCgpnTransformCssNatl()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setUseDevicePoolCgpnTransformCssIntl()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setUseDevicePoolCgpnTransformCssUnkn()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setUseDevicePoolCgpnTransformCssSubs()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setPstnAccess()
     * @uses XCiscoCatalyst6000T1VoIPGatewayPri::setImeE164TransformationName()
     * @param string $name
     * @param string $product
     * @param string $class
     * @param string $protocol
     * @param string $protocolSide
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName
     * @param string $redirectInboundNumberIe
     * @param string $calledPlan
     * @param string $calledPri
     * @param string $callingPartySelection
     * @param string $callingPlan
     * @param string $callingPri
     * @param string $chanIe
     * @param string $clockReference
     * @param string $dChannelEnable
     * @param string $channelSelectionOrder
     * @param string $displayIE
     * @param string $pcmType
     * @param string $csuParam
     * @param string $firstDelay
     * @param string $interfaceIdPresent
     * @param string $interfaceId
     * @param string $intraDelay
     * @param string $mcdnEnable
     * @param string $redirectOutboundNumberIe
     * @param string $numDigitsToStrip
     * @param string $passingPrecedenceLevelThrough
     * @param string $callingLinePresentationBit
     * @param string $connectedLineIdPresentation
     * @param string $priProtocol
     * @param string $securityAccessLevel
     * @param string $sendCallingNameInFacilityIe
     * @param string $sendExLeadingCharInDispIe
     * @param string $sendRestart
     * @param string $setupNonIsdnPi
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\SigDigits $sigDigits
     * @param string $span
     * @param string $statusPoll
     * @param string $smdiBasePort
     * @param string $description
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName
     * @param string $networkLocation
     * @param string $networkLocale
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig
     * @param string $mlppDomainId
     * @param string $mlppIndicationStatus
     * @param string $mlppPreemption
     * @param string $useTrustedRelayPoint
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName
     * @param string $useDevicePoolCgpnTransformCss
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName
     * @param string $callerIdDn
     * @param string $prefix
     * @param string $packetCaptureMode
     * @param string $packetCaptureDuration
     * @param string $transmitUtf8
     * @param string $v150
     * @param string $asn1RoseOidEncoding
     * @param string $qSIGVariant
     * @param string $unattendedPort
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName
     * @param string $useDevicePoolCdpnTransformCss
     * @param string $nationalPrefix
     * @param string $internationalPrefix
     * @param string $unknownPrefix
     * @param string $subscriberPrefix
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName
     * @param string $nationalStripDigits
     * @param string $internationalStripDigits
     * @param string $unknownStripDigits
     * @param string $subscriberStripDigits
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $nationalTransformationCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $internationalTransformationCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $unknownTransformationCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscriberTransformationCssName
     * @param string $useDevicePoolCgpnTransformCssNatl
     * @param string $useDevicePoolCgpnTransformCssIntl
     * @param string $useDevicePoolCgpnTransformCssUnkn
     * @param string $useDevicePoolCgpnTransformCssSubs
     * @param string $pstnAccess
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeE164TransformationName
     */
    public function __construct($name = null, $product = null, $class = null, $protocol = null, $protocolSide = 'User', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName = null, $redirectInboundNumberIe = null, $calledPlan = 'Cisco CallManager', $calledPri = 'Cisco CallManager', $callingPartySelection = 'Originator', $callingPlan = 'Cisco CallManager', $callingPri = 'Cisco CallManager', $chanIe = 'Use Number when 1B', $clockReference = null, $dChannelEnable = null, $channelSelectionOrder = 'Top Down', $displayIE = null, $pcmType = null, $csuParam = null, $firstDelay = '32', $interfaceIdPresent = null, $interfaceId = '0', $intraDelay = '4', $mcdnEnable = null, $redirectOutboundNumberIe = null, $numDigitsToStrip = '0', $passingPrecedenceLevelThrough = null, $callingLinePresentationBit = 'Default', $connectedLineIdPresentation = 'Default', $priProtocol = null, $securityAccessLevel = '2', $sendCallingNameInFacilityIe = null, $sendExLeadingCharInDispIe = null, $sendRestart = null, $setupNonIsdnPi = null, \\Losc\CucmBundle\Model\Webservice\StructType\SigDigits $sigDigits = null, $span = null, $statusPoll = null, $smdiBasePort = '0', $description = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName = null, $networkLocation = 'Use System Default', $networkLocale = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation = null, \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig = null, $mlppDomainId = null, $mlppIndicationStatus = 'Off', $mlppPreemption = 'Default', $useTrustedRelayPoint = 'Default', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName = null, $useDevicePoolCgpnTransformCss = 'true', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName = null, $callerIdDn = null, $prefix = null, $packetCaptureMode = 'None', $packetCaptureDuration = '0', $transmitUtf8 = 'false', $v150 = 'false', $asn1RoseOidEncoding = 'No Changes', $qSIGVariant = 'No Changes', $unattendedPort = 'false', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName = null, $useDevicePoolCdpnTransformCss = 'true', $nationalPrefix = null, $internationalPrefix = null, $unknownPrefix = null, $subscriberPrefix = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName = null, $nationalStripDigits = null, $internationalStripDigits = null, $unknownStripDigits = null, $subscriberStripDigits = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $nationalTransformationCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $internationalTransformationCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $unknownTransformationCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscriberTransformationCssName = null, $useDevicePoolCgpnTransformCssNatl = 'true', $useDevicePoolCgpnTransformCssIntl = 'true', $useDevicePoolCgpnTransformCssUnkn = 'true', $useDevicePoolCgpnTransformCssSubs = 'true', $pstnAccess = 'true', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeE164TransformationName = null)
    {
        $this
            ->setName($name)
            ->setProduct($product)
            ->setClass($class)
            ->setProtocol($protocol)
            ->setProtocolSide($protocolSide)
            ->setDevicePoolName($devicePoolName)
            ->setLocationName($locationName)
            ->setRedirectInboundNumberIe($redirectInboundNumberIe)
            ->setCalledPlan($calledPlan)
            ->setCalledPri($calledPri)
            ->setCallingPartySelection($callingPartySelection)
            ->setCallingPlan($callingPlan)
            ->setCallingPri($callingPri)
            ->setChanIe($chanIe)
            ->setClockReference($clockReference)
            ->setDChannelEnable($dChannelEnable)
            ->setChannelSelectionOrder($channelSelectionOrder)
            ->setDisplayIE($displayIE)
            ->setPcmType($pcmType)
            ->setCsuParam($csuParam)
            ->setFirstDelay($firstDelay)
            ->setInterfaceIdPresent($interfaceIdPresent)
            ->setInterfaceId($interfaceId)
            ->setIntraDelay($intraDelay)
            ->setMcdnEnable($mcdnEnable)
            ->setRedirectOutboundNumberIe($redirectOutboundNumberIe)
            ->setNumDigitsToStrip($numDigitsToStrip)
            ->setPassingPrecedenceLevelThrough($passingPrecedenceLevelThrough)
            ->setCallingLinePresentationBit($callingLinePresentationBit)
            ->setConnectedLineIdPresentation($connectedLineIdPresentation)
            ->setPriProtocol($priProtocol)
            ->setSecurityAccessLevel($securityAccessLevel)
            ->setSendCallingNameInFacilityIe($sendCallingNameInFacilityIe)
            ->setSendExLeadingCharInDispIe($sendExLeadingCharInDispIe)
            ->setSendRestart($sendRestart)
            ->setSetupNonIsdnPi($setupNonIsdnPi)
            ->setSigDigits($sigDigits)
            ->setSpan($span)
            ->setStatusPoll($statusPoll)
            ->setSmdiBasePort($smdiBasePort)
            ->setDescription($description)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setNetworkLocation($networkLocation)
            ->setNetworkLocale($networkLocale)
            ->setMediaResourceListName($mediaResourceListName)
            ->setAutomatedAlternateRoutingCssName($automatedAlternateRoutingCssName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setLoadInformation($loadInformation)
            ->setVendorConfig($vendorConfig)
            ->setMlppDomainId($mlppDomainId)
            ->setMlppIndicationStatus($mlppIndicationStatus)
            ->setMlppPreemption($mlppPreemption)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setCgpnTransformationCssName($cgpnTransformationCssName)
            ->setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss)
            ->setGeoLocationName($geoLocationName)
            ->setCallerIdDn($callerIdDn)
            ->setPrefix($prefix)
            ->setPacketCaptureMode($packetCaptureMode)
            ->setPacketCaptureDuration($packetCaptureDuration)
            ->setTransmitUtf8($transmitUtf8)
            ->setV150($v150)
            ->setAsn1RoseOidEncoding($asn1RoseOidEncoding)
            ->setQSIGVariant($qSIGVariant)
            ->setUnattendedPort($unattendedPort)
            ->setCdpnTransformationCssName($cdpnTransformationCssName)
            ->setUseDevicePoolCdpnTransformCss($useDevicePoolCdpnTransformCss)
            ->setNationalPrefix($nationalPrefix)
            ->setInternationalPrefix($internationalPrefix)
            ->setUnknownPrefix($unknownPrefix)
            ->setSubscriberPrefix($subscriberPrefix)
            ->setGeoLocationFilterName($geoLocationFilterName)
            ->setNationalStripDigits($nationalStripDigits)
            ->setInternationalStripDigits($internationalStripDigits)
            ->setUnknownStripDigits($unknownStripDigits)
            ->setSubscriberStripDigits($subscriberStripDigits)
            ->setNationalTransformationCssName($nationalTransformationCssName)
            ->setInternationalTransformationCssName($internationalTransformationCssName)
            ->setUnknownTransformationCssName($unknownTransformationCssName)
            ->setSubscriberTransformationCssName($subscriberTransformationCssName)
            ->setUseDevicePoolCgpnTransformCssNatl($useDevicePoolCgpnTransformCssNatl)
            ->setUseDevicePoolCgpnTransformCssIntl($useDevicePoolCgpnTransformCssIntl)
            ->setUseDevicePoolCgpnTransformCssUnkn($useDevicePoolCgpnTransformCssUnkn)
            ->setUseDevicePoolCgpnTransformCssSubs($useDevicePoolCgpnTransformCssSubs)
            ->setPstnAccess($pstnAccess)
            ->setImeE164TransformationName($imeE164TransformationName);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get product value
     * @return string
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param string $product
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setProduct($product = null)
    {
        $this->product = $product;
        return $this;
    }
    /**
     * Get class value
     * @return string
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param string $class
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setClass($class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get protocol value
     * @return string
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @param string $protocol
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setProtocol($protocol = null)
    {
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get protocolSide value
     * @return string
     */
    public function getProtocolSide()
    {
        return $this->protocolSide;
    }
    /**
     * Set protocolSide value
     * @param string $protocolSide
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setProtocolSide($protocolSide = 'User')
    {
        $this->protocolSide = $protocolSide;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setDevicePoolName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get locationName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setLocationName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get redirectInboundNumberIe value
     * @return string
     */
    public function getRedirectInboundNumberIe()
    {
        return $this->redirectInboundNumberIe;
    }
    /**
     * Set redirectInboundNumberIe value
     * @param string $redirectInboundNumberIe
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setRedirectInboundNumberIe($redirectInboundNumberIe = null)
    {
        $this->redirectInboundNumberIe = $redirectInboundNumberIe;
        return $this;
    }
    /**
     * Get calledPlan value
     * @return string
     */
    public function getCalledPlan()
    {
        return $this->calledPlan;
    }
    /**
     * Set calledPlan value
     * @param string $calledPlan
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setCalledPlan($calledPlan = 'Cisco CallManager')
    {
        $this->calledPlan = $calledPlan;
        return $this;
    }
    /**
     * Get calledPri value
     * @return string
     */
    public function getCalledPri()
    {
        return $this->calledPri;
    }
    /**
     * Set calledPri value
     * @param string $calledPri
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setCalledPri($calledPri = 'Cisco CallManager')
    {
        $this->calledPri = $calledPri;
        return $this;
    }
    /**
     * Get callingPartySelection value
     * @return string
     */
    public function getCallingPartySelection()
    {
        return $this->callingPartySelection;
    }
    /**
     * Set callingPartySelection value
     * @param string $callingPartySelection
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setCallingPartySelection($callingPartySelection = 'Originator')
    {
        $this->callingPartySelection = $callingPartySelection;
        return $this;
    }
    /**
     * Get callingPlan value
     * @return string
     */
    public function getCallingPlan()
    {
        return $this->callingPlan;
    }
    /**
     * Set callingPlan value
     * @param string $callingPlan
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setCallingPlan($callingPlan = 'Cisco CallManager')
    {
        $this->callingPlan = $callingPlan;
        return $this;
    }
    /**
     * Get callingPri value
     * @return string
     */
    public function getCallingPri()
    {
        return $this->callingPri;
    }
    /**
     * Set callingPri value
     * @param string $callingPri
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setCallingPri($callingPri = 'Cisco CallManager')
    {
        $this->callingPri = $callingPri;
        return $this;
    }
    /**
     * Get chanIe value
     * @return string
     */
    public function getChanIe()
    {
        return $this->chanIe;
    }
    /**
     * Set chanIe value
     * @param string $chanIe
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setChanIe($chanIe = 'Use Number when 1B')
    {
        $this->chanIe = $chanIe;
        return $this;
    }
    /**
     * Get clockReference value
     * @return string
     */
    public function getClockReference()
    {
        return $this->clockReference;
    }
    /**
     * Set clockReference value
     * @param string $clockReference
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setClockReference($clockReference = null)
    {
        $this->clockReference = $clockReference;
        return $this;
    }
    /**
     * Get dChannelEnable value
     * @return string
     */
    public function getDChannelEnable()
    {
        return $this->dChannelEnable;
    }
    /**
     * Set dChannelEnable value
     * @param string $dChannelEnable
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setDChannelEnable($dChannelEnable = null)
    {
        $this->dChannelEnable = $dChannelEnable;
        return $this;
    }
    /**
     * Get channelSelectionOrder value
     * @return string
     */
    public function getChannelSelectionOrder()
    {
        return $this->channelSelectionOrder;
    }
    /**
     * Set channelSelectionOrder value
     * @param string $channelSelectionOrder
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setChannelSelectionOrder($channelSelectionOrder = 'Top Down')
    {
        $this->channelSelectionOrder = $channelSelectionOrder;
        return $this;
    }
    /**
     * Get displayIE value
     * @return string
     */
    public function getDisplayIE()
    {
        return $this->displayIE;
    }
    /**
     * Set displayIE value
     * @param string $displayIE
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setDisplayIE($displayIE = null)
    {
        $this->displayIE = $displayIE;
        return $this;
    }
    /**
     * Get pcmType value
     * @return string
     */
    public function getPcmType()
    {
        return $this->pcmType;
    }
    /**
     * Set pcmType value
     * @param string $pcmType
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setPcmType($pcmType = null)
    {
        $this->pcmType = $pcmType;
        return $this;
    }
    /**
     * Get csuParam value
     * @return string
     */
    public function getCsuParam()
    {
        return $this->csuParam;
    }
    /**
     * Set csuParam value
     * @param string $csuParam
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setCsuParam($csuParam = null)
    {
        $this->csuParam = $csuParam;
        return $this;
    }
    /**
     * Get firstDelay value
     * @return string
     */
    public function getFirstDelay()
    {
        return $this->firstDelay;
    }
    /**
     * Set firstDelay value
     * @param string $firstDelay
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setFirstDelay($firstDelay = '32')
    {
        $this->firstDelay = $firstDelay;
        return $this;
    }
    /**
     * Get interfaceIdPresent value
     * @return string
     */
    public function getInterfaceIdPresent()
    {
        return $this->interfaceIdPresent;
    }
    /**
     * Set interfaceIdPresent value
     * @param string $interfaceIdPresent
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setInterfaceIdPresent($interfaceIdPresent = null)
    {
        $this->interfaceIdPresent = $interfaceIdPresent;
        return $this;
    }
    /**
     * Get interfaceId value
     * @return string
     */
    public function getInterfaceId()
    {
        return $this->interfaceId;
    }
    /**
     * Set interfaceId value
     * @param string $interfaceId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setInterfaceId($interfaceId = '0')
    {
        $this->interfaceId = $interfaceId;
        return $this;
    }
    /**
     * Get intraDelay value
     * @return string
     */
    public function getIntraDelay()
    {
        return $this->intraDelay;
    }
    /**
     * Set intraDelay value
     * @param string $intraDelay
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setIntraDelay($intraDelay = '4')
    {
        $this->intraDelay = $intraDelay;
        return $this;
    }
    /**
     * Get mcdnEnable value
     * @return string
     */
    public function getMcdnEnable()
    {
        return $this->mcdnEnable;
    }
    /**
     * Set mcdnEnable value
     * @param string $mcdnEnable
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setMcdnEnable($mcdnEnable = null)
    {
        $this->mcdnEnable = $mcdnEnable;
        return $this;
    }
    /**
     * Get redirectOutboundNumberIe value
     * @return string
     */
    public function getRedirectOutboundNumberIe()
    {
        return $this->redirectOutboundNumberIe;
    }
    /**
     * Set redirectOutboundNumberIe value
     * @param string $redirectOutboundNumberIe
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setRedirectOutboundNumberIe($redirectOutboundNumberIe = null)
    {
        $this->redirectOutboundNumberIe = $redirectOutboundNumberIe;
        return $this;
    }
    /**
     * Get numDigitsToStrip value
     * @return string
     */
    public function getNumDigitsToStrip()
    {
        return $this->numDigitsToStrip;
    }
    /**
     * Set numDigitsToStrip value
     * @param string $numDigitsToStrip
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setNumDigitsToStrip($numDigitsToStrip = '0')
    {
        $this->numDigitsToStrip = $numDigitsToStrip;
        return $this;
    }
    /**
     * Get passingPrecedenceLevelThrough value
     * @return string
     */
    public function getPassingPrecedenceLevelThrough()
    {
        return $this->passingPrecedenceLevelThrough;
    }
    /**
     * Set passingPrecedenceLevelThrough value
     * @param string $passingPrecedenceLevelThrough
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setPassingPrecedenceLevelThrough($passingPrecedenceLevelThrough = null)
    {
        $this->passingPrecedenceLevelThrough = $passingPrecedenceLevelThrough;
        return $this;
    }
    /**
     * Get callingLinePresentationBit value
     * @return string
     */
    public function getCallingLinePresentationBit()
    {
        return $this->callingLinePresentationBit;
    }
    /**
     * Set callingLinePresentationBit value
     * @param string $callingLinePresentationBit
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setCallingLinePresentationBit($callingLinePresentationBit = 'Default')
    {
        $this->callingLinePresentationBit = $callingLinePresentationBit;
        return $this;
    }
    /**
     * Get connectedLineIdPresentation value
     * @return string
     */
    public function getConnectedLineIdPresentation()
    {
        return $this->connectedLineIdPresentation;
    }
    /**
     * Set connectedLineIdPresentation value
     * @param string $connectedLineIdPresentation
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setConnectedLineIdPresentation($connectedLineIdPresentation = 'Default')
    {
        $this->connectedLineIdPresentation = $connectedLineIdPresentation;
        return $this;
    }
    /**
     * Get priProtocol value
     * @return string
     */
    public function getPriProtocol()
    {
        return $this->priProtocol;
    }
    /**
     * Set priProtocol value
     * @param string $priProtocol
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setPriProtocol($priProtocol = null)
    {
        $this->priProtocol = $priProtocol;
        return $this;
    }
    /**
     * Get securityAccessLevel value
     * @return string
     */
    public function getSecurityAccessLevel()
    {
        return $this->securityAccessLevel;
    }
    /**
     * Set securityAccessLevel value
     * @param string $securityAccessLevel
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setSecurityAccessLevel($securityAccessLevel = '2')
    {
        $this->securityAccessLevel = $securityAccessLevel;
        return $this;
    }
    /**
     * Get sendCallingNameInFacilityIe value
     * @return string
     */
    public function getSendCallingNameInFacilityIe()
    {
        return $this->sendCallingNameInFacilityIe;
    }
    /**
     * Set sendCallingNameInFacilityIe value
     * @param string $sendCallingNameInFacilityIe
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setSendCallingNameInFacilityIe($sendCallingNameInFacilityIe = null)
    {
        $this->sendCallingNameInFacilityIe = $sendCallingNameInFacilityIe;
        return $this;
    }
    /**
     * Get sendExLeadingCharInDispIe value
     * @return string
     */
    public function getSendExLeadingCharInDispIe()
    {
        return $this->sendExLeadingCharInDispIe;
    }
    /**
     * Set sendExLeadingCharInDispIe value
     * @param string $sendExLeadingCharInDispIe
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setSendExLeadingCharInDispIe($sendExLeadingCharInDispIe = null)
    {
        $this->sendExLeadingCharInDispIe = $sendExLeadingCharInDispIe;
        return $this;
    }
    /**
     * Get sendRestart value
     * @return string
     */
    public function getSendRestart()
    {
        return $this->sendRestart;
    }
    /**
     * Set sendRestart value
     * @param string $sendRestart
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setSendRestart($sendRestart = null)
    {
        $this->sendRestart = $sendRestart;
        return $this;
    }
    /**
     * Get setupNonIsdnPi value
     * @return string
     */
    public function getSetupNonIsdnPi()
    {
        return $this->setupNonIsdnPi;
    }
    /**
     * Set setupNonIsdnPi value
     * @param string $setupNonIsdnPi
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setSetupNonIsdnPi($setupNonIsdnPi = null)
    {
        $this->setupNonIsdnPi = $setupNonIsdnPi;
        return $this;
    }
    /**
     * Get sigDigits value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SigDigits
     */
    public function getSigDigits()
    {
        return $this->sigDigits;
    }
    /**
     * Set sigDigits value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\SigDigits $sigDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setSigDigits(\\Losc\CucmBundle\Model\Webservice\StructType\SigDigits $sigDigits = null)
    {
        $this->sigDigits = $sigDigits;
        return $this;
    }
    /**
     * Get span value
     * @return string
     */
    public function getSpan()
    {
        return $this->span;
    }
    /**
     * Set span value
     * @param string $span
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setSpan($span = null)
    {
        $this->span = $span;
        return $this;
    }
    /**
     * Get statusPoll value
     * @return string
     */
    public function getStatusPoll()
    {
        return $this->statusPoll;
    }
    /**
     * Set statusPoll value
     * @param string $statusPoll
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setStatusPoll($statusPoll = null)
    {
        $this->statusPoll = $statusPoll;
        return $this;
    }
    /**
     * Get smdiBasePort value
     * @return string
     */
    public function getSmdiBasePort()
    {
        return $this->smdiBasePort;
    }
    /**
     * Set smdiBasePort value
     * @param string $smdiBasePort
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setSmdiBasePort($smdiBasePort = '0')
    {
        $this->smdiBasePort = $smdiBasePort;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return isset($this->callingSearchSpaceName) ? $this->callingSearchSpaceName : null;
    }
    /**
     * Set callingSearchSpaceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setCallingSearchSpaceName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName = null)
    {
        if (is_null($callingSearchSpaceName) || (is_array($callingSearchSpaceName) && empty($callingSearchSpaceName))) {
            unset($this->callingSearchSpaceName);
        } else {
            $this->callingSearchSpaceName = $callingSearchSpaceName;
        }
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return isset($this->commonDeviceConfigName) ? $this->commonDeviceConfigName : null;
    }
    /**
     * Set commonDeviceConfigName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setCommonDeviceConfigName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName = null)
    {
        if (is_null($commonDeviceConfigName) || (is_array($commonDeviceConfigName) && empty($commonDeviceConfigName))) {
            unset($this->commonDeviceConfigName);
        } else {
            $this->commonDeviceConfigName = $commonDeviceConfigName;
        }
        return $this;
    }
    /**
     * Get networkLocation value
     * @return string|null
     */
    public function getNetworkLocation()
    {
        return $this->networkLocation;
    }
    /**
     * Set networkLocation value
     * @param string $networkLocation
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setNetworkLocation($networkLocation = 'Use System Default')
    {
        $this->networkLocation = $networkLocation;
        return $this;
    }
    /**
     * Get networkLocale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNetworkLocale()
    {
        return isset($this->networkLocale) ? $this->networkLocale : null;
    }
    /**
     * Set networkLocale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $networkLocale
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setNetworkLocale($networkLocale = null)
    {
        if (is_null($networkLocale) || (is_array($networkLocale) && empty($networkLocale))) {
            unset($this->networkLocale);
        } else {
            $this->networkLocale = $networkLocale;
        }
        return $this;
    }
    /**
     * Get mediaResourceListName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getMediaResourceListName()
    {
        return isset($this->mediaResourceListName) ? $this->mediaResourceListName : null;
    }
    /**
     * Set mediaResourceListName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setMediaResourceListName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName = null)
    {
        if (is_null($mediaResourceListName) || (is_array($mediaResourceListName) && empty($mediaResourceListName))) {
            unset($this->mediaResourceListName);
        } else {
            $this->mediaResourceListName = $mediaResourceListName;
        }
        return $this;
    }
    /**
     * Get automatedAlternateRoutingCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getAutomatedAlternateRoutingCssName()
    {
        return isset($this->automatedAlternateRoutingCssName) ? $this->automatedAlternateRoutingCssName : null;
    }
    /**
     * Set automatedAlternateRoutingCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setAutomatedAlternateRoutingCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName = null)
    {
        if (is_null($automatedAlternateRoutingCssName) || (is_array($automatedAlternateRoutingCssName) && empty($automatedAlternateRoutingCssName))) {
            unset($this->automatedAlternateRoutingCssName);
        } else {
            $this->automatedAlternateRoutingCssName = $automatedAlternateRoutingCssName;
        }
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return isset($this->aarNeighborhoodName) ? $this->aarNeighborhoodName : null;
    }
    /**
     * Set aarNeighborhoodName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setAarNeighborhoodName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName = null)
    {
        if (is_null($aarNeighborhoodName) || (is_array($aarNeighborhoodName) && empty($aarNeighborhoodName))) {
            unset($this->aarNeighborhoodName);
        } else {
            $this->aarNeighborhoodName = $aarNeighborhoodName;
        }
        return $this;
    }
    /**
     * Get loadInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation|null
     */
    public function getLoadInformation()
    {
        return isset($this->loadInformation) ? $this->loadInformation : null;
    }
    /**
     * Set loadInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setLoadInformation(\\Losc\CucmBundle\Model\Webservice\StructType\XLoadInformation $loadInformation = null)
    {
        if (is_null($loadInformation) || (is_array($loadInformation) && empty($loadInformation))) {
            unset($this->loadInformation);
        } else {
            $this->loadInformation = $loadInformation;
        }
        return $this;
    }
    /**
     * Get vendorConfig value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig|null
     */
    public function getVendorConfig()
    {
        return $this->vendorConfig;
    }
    /**
     * Set vendorConfig value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setVendorConfig(\\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig = null)
    {
        $this->vendorConfig = $vendorConfig;
        return $this;
    }
    /**
     * Get mlppDomainId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMlppDomainId()
    {
        return isset($this->mlppDomainId) ? $this->mlppDomainId : null;
    }
    /**
     * Set mlppDomainId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mlppDomainId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setMlppDomainId($mlppDomainId = null)
    {
        if (is_null($mlppDomainId) || (is_array($mlppDomainId) && empty($mlppDomainId))) {
            unset($this->mlppDomainId);
        } else {
            $this->mlppDomainId = $mlppDomainId;
        }
        return $this;
    }
    /**
     * Get mlppIndicationStatus value
     * @return string|null
     */
    public function getMlppIndicationStatus()
    {
        return $this->mlppIndicationStatus;
    }
    /**
     * Set mlppIndicationStatus value
     * @param string $mlppIndicationStatus
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setMlppIndicationStatus($mlppIndicationStatus = 'Off')
    {
        $this->mlppIndicationStatus = $mlppIndicationStatus;
        return $this;
    }
    /**
     * Get mlppPreemption value
     * @return string|null
     */
    public function getMlppPreemption()
    {
        return $this->mlppPreemption;
    }
    /**
     * Set mlppPreemption value
     * @param string $mlppPreemption
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setMlppPreemption($mlppPreemption = 'Default')
    {
        $this->mlppPreemption = $mlppPreemption;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @param string $useTrustedRelayPoint
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = 'Default')
    {
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get cgpnTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCgpnTransformationCssName()
    {
        return isset($this->cgpnTransformationCssName) ? $this->cgpnTransformationCssName : null;
    }
    /**
     * Set cgpnTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setCgpnTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName = null)
    {
        if (is_null($cgpnTransformationCssName) || (is_array($cgpnTransformationCssName) && empty($cgpnTransformationCssName))) {
            unset($this->cgpnTransformationCssName);
        } else {
            $this->cgpnTransformationCssName = $cgpnTransformationCssName;
        }
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCss()
    {
        return $this->useDevicePoolCgpnTransformCss;
    }
    /**
     * Set useDevicePoolCgpnTransformCss value
     * @param string $useDevicePoolCgpnTransformCss
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss = 'true')
    {
        $this->useDevicePoolCgpnTransformCss = $useDevicePoolCgpnTransformCss;
        return $this;
    }
    /**
     * Get geoLocationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getGeoLocationName()
    {
        return isset($this->geoLocationName) ? $this->geoLocationName : null;
    }
    /**
     * Set geoLocationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setGeoLocationName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName = null)
    {
        if (is_null($geoLocationName) || (is_array($geoLocationName) && empty($geoLocationName))) {
            unset($this->geoLocationName);
        } else {
            $this->geoLocationName = $geoLocationName;
        }
        return $this;
    }
    /**
     * Get callerIdDn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallerIdDn()
    {
        return isset($this->callerIdDn) ? $this->callerIdDn : null;
    }
    /**
     * Set callerIdDn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $callerIdDn
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setCallerIdDn($callerIdDn = null)
    {
        if (is_null($callerIdDn) || (is_array($callerIdDn) && empty($callerIdDn))) {
            unset($this->callerIdDn);
        } else {
            $this->callerIdDn = $callerIdDn;
        }
        return $this;
    }
    /**
     * Get prefix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrefix()
    {
        return isset($this->prefix) ? $this->prefix : null;
    }
    /**
     * Set prefix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setPrefix($prefix = null)
    {
        if (is_null($prefix) || (is_array($prefix) && empty($prefix))) {
            unset($this->prefix);
        } else {
            $this->prefix = $prefix;
        }
        return $this;
    }
    /**
     * Get packetCaptureMode value
     * @return string|null
     */
    public function getPacketCaptureMode()
    {
        return $this->packetCaptureMode;
    }
    /**
     * Set packetCaptureMode value
     * @param string $packetCaptureMode
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setPacketCaptureMode($packetCaptureMode = 'None')
    {
        $this->packetCaptureMode = $packetCaptureMode;
        return $this;
    }
    /**
     * Get packetCaptureDuration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPacketCaptureDuration()
    {
        return isset($this->packetCaptureDuration) ? $this->packetCaptureDuration : null;
    }
    /**
     * Set packetCaptureDuration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $packetCaptureDuration
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setPacketCaptureDuration($packetCaptureDuration = '0')
    {
        if (is_null($packetCaptureDuration) || (is_array($packetCaptureDuration) && empty($packetCaptureDuration))) {
            unset($this->packetCaptureDuration);
        } else {
            $this->packetCaptureDuration = $packetCaptureDuration;
        }
        return $this;
    }
    /**
     * Get transmitUtf8 value
     * @return string|null
     */
    public function getTransmitUtf8()
    {
        return $this->transmitUtf8;
    }
    /**
     * Set transmitUtf8 value
     * @param string $transmitUtf8
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setTransmitUtf8($transmitUtf8 = 'false')
    {
        $this->transmitUtf8 = $transmitUtf8;
        return $this;
    }
    /**
     * Get v150 value
     * @return string|null
     */
    public function getV150()
    {
        return $this->v150;
    }
    /**
     * Set v150 value
     * @param string $v150
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setV150($v150 = 'false')
    {
        $this->v150 = $v150;
        return $this;
    }
    /**
     * Get asn1RoseOidEncoding value
     * @return string|null
     */
    public function getAsn1RoseOidEncoding()
    {
        return $this->asn1RoseOidEncoding;
    }
    /**
     * Set asn1RoseOidEncoding value
     * @param string $asn1RoseOidEncoding
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setAsn1RoseOidEncoding($asn1RoseOidEncoding = 'No Changes')
    {
        $this->asn1RoseOidEncoding = $asn1RoseOidEncoding;
        return $this;
    }
    /**
     * Get QSIGVariant value
     * @return string|null
     */
    public function getQSIGVariant()
    {
        return $this->QSIGVariant;
    }
    /**
     * Set QSIGVariant value
     * @param string $qSIGVariant
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setQSIGVariant($qSIGVariant = 'No Changes')
    {
        $this->QSIGVariant = $qSIGVariant;
        return $this;
    }
    /**
     * Get unattendedPort value
     * @return string|null
     */
    public function getUnattendedPort()
    {
        return $this->unattendedPort;
    }
    /**
     * Set unattendedPort value
     * @param string $unattendedPort
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setUnattendedPort($unattendedPort = 'false')
    {
        $this->unattendedPort = $unattendedPort;
        return $this;
    }
    /**
     * Get cdpnTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCdpnTransformationCssName()
    {
        return isset($this->cdpnTransformationCssName) ? $this->cdpnTransformationCssName : null;
    }
    /**
     * Set cdpnTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setCdpnTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName = null)
    {
        if (is_null($cdpnTransformationCssName) || (is_array($cdpnTransformationCssName) && empty($cdpnTransformationCssName))) {
            unset($this->cdpnTransformationCssName);
        } else {
            $this->cdpnTransformationCssName = $cdpnTransformationCssName;
        }
        return $this;
    }
    /**
     * Get useDevicePoolCdpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCdpnTransformCss()
    {
        return $this->useDevicePoolCdpnTransformCss;
    }
    /**
     * Set useDevicePoolCdpnTransformCss value
     * @param string $useDevicePoolCdpnTransformCss
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setUseDevicePoolCdpnTransformCss($useDevicePoolCdpnTransformCss = 'true')
    {
        $this->useDevicePoolCdpnTransformCss = $useDevicePoolCdpnTransformCss;
        return $this;
    }
    /**
     * Get nationalPrefix value
     * @return string|null
     */
    public function getNationalPrefix()
    {
        return $this->nationalPrefix;
    }
    /**
     * Set nationalPrefix value
     * @param string $nationalPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setNationalPrefix($nationalPrefix = null)
    {
        $this->nationalPrefix = $nationalPrefix;
        return $this;
    }
    /**
     * Get internationalPrefix value
     * @return string|null
     */
    public function getInternationalPrefix()
    {
        return $this->internationalPrefix;
    }
    /**
     * Set internationalPrefix value
     * @param string $internationalPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setInternationalPrefix($internationalPrefix = null)
    {
        $this->internationalPrefix = $internationalPrefix;
        return $this;
    }
    /**
     * Get unknownPrefix value
     * @return string|null
     */
    public function getUnknownPrefix()
    {
        return $this->unknownPrefix;
    }
    /**
     * Set unknownPrefix value
     * @param string $unknownPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setUnknownPrefix($unknownPrefix = null)
    {
        $this->unknownPrefix = $unknownPrefix;
        return $this;
    }
    /**
     * Get subscriberPrefix value
     * @return string|null
     */
    public function getSubscriberPrefix()
    {
        return $this->subscriberPrefix;
    }
    /**
     * Set subscriberPrefix value
     * @param string $subscriberPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setSubscriberPrefix($subscriberPrefix = null)
    {
        $this->subscriberPrefix = $subscriberPrefix;
        return $this;
    }
    /**
     * Get geoLocationFilterName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getGeoLocationFilterName()
    {
        return isset($this->geoLocationFilterName) ? $this->geoLocationFilterName : null;
    }
    /**
     * Set geoLocationFilterName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setGeoLocationFilterName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName = null)
    {
        if (is_null($geoLocationFilterName) || (is_array($geoLocationFilterName) && empty($geoLocationFilterName))) {
            unset($this->geoLocationFilterName);
        } else {
            $this->geoLocationFilterName = $geoLocationFilterName;
        }
        return $this;
    }
    /**
     * Get nationalStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNationalStripDigits()
    {
        return isset($this->nationalStripDigits) ? $this->nationalStripDigits : null;
    }
    /**
     * Set nationalStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nationalStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setNationalStripDigits($nationalStripDigits = null)
    {
        if (is_null($nationalStripDigits) || (is_array($nationalStripDigits) && empty($nationalStripDigits))) {
            unset($this->nationalStripDigits);
        } else {
            $this->nationalStripDigits = $nationalStripDigits;
        }
        return $this;
    }
    /**
     * Get internationalStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInternationalStripDigits()
    {
        return isset($this->internationalStripDigits) ? $this->internationalStripDigits : null;
    }
    /**
     * Set internationalStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $internationalStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setInternationalStripDigits($internationalStripDigits = null)
    {
        if (is_null($internationalStripDigits) || (is_array($internationalStripDigits) && empty($internationalStripDigits))) {
            unset($this->internationalStripDigits);
        } else {
            $this->internationalStripDigits = $internationalStripDigits;
        }
        return $this;
    }
    /**
     * Get unknownStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUnknownStripDigits()
    {
        return isset($this->unknownStripDigits) ? $this->unknownStripDigits : null;
    }
    /**
     * Set unknownStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $unknownStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setUnknownStripDigits($unknownStripDigits = null)
    {
        if (is_null($unknownStripDigits) || (is_array($unknownStripDigits) && empty($unknownStripDigits))) {
            unset($this->unknownStripDigits);
        } else {
            $this->unknownStripDigits = $unknownStripDigits;
        }
        return $this;
    }
    /**
     * Get subscriberStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriberStripDigits()
    {
        return isset($this->subscriberStripDigits) ? $this->subscriberStripDigits : null;
    }
    /**
     * Set subscriberStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriberStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setSubscriberStripDigits($subscriberStripDigits = null)
    {
        if (is_null($subscriberStripDigits) || (is_array($subscriberStripDigits) && empty($subscriberStripDigits))) {
            unset($this->subscriberStripDigits);
        } else {
            $this->subscriberStripDigits = $subscriberStripDigits;
        }
        return $this;
    }
    /**
     * Get nationalTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getNationalTransformationCssName()
    {
        return isset($this->nationalTransformationCssName) ? $this->nationalTransformationCssName : null;
    }
    /**
     * Set nationalTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $nationalTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setNationalTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $nationalTransformationCssName = null)
    {
        if (is_null($nationalTransformationCssName) || (is_array($nationalTransformationCssName) && empty($nationalTransformationCssName))) {
            unset($this->nationalTransformationCssName);
        } else {
            $this->nationalTransformationCssName = $nationalTransformationCssName;
        }
        return $this;
    }
    /**
     * Get internationalTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getInternationalTransformationCssName()
    {
        return isset($this->internationalTransformationCssName) ? $this->internationalTransformationCssName : null;
    }
    /**
     * Set internationalTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $internationalTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setInternationalTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $internationalTransformationCssName = null)
    {
        if (is_null($internationalTransformationCssName) || (is_array($internationalTransformationCssName) && empty($internationalTransformationCssName))) {
            unset($this->internationalTransformationCssName);
        } else {
            $this->internationalTransformationCssName = $internationalTransformationCssName;
        }
        return $this;
    }
    /**
     * Get unknownTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getUnknownTransformationCssName()
    {
        return isset($this->unknownTransformationCssName) ? $this->unknownTransformationCssName : null;
    }
    /**
     * Set unknownTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $unknownTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setUnknownTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $unknownTransformationCssName = null)
    {
        if (is_null($unknownTransformationCssName) || (is_array($unknownTransformationCssName) && empty($unknownTransformationCssName))) {
            unset($this->unknownTransformationCssName);
        } else {
            $this->unknownTransformationCssName = $unknownTransformationCssName;
        }
        return $this;
    }
    /**
     * Get subscriberTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSubscriberTransformationCssName()
    {
        return isset($this->subscriberTransformationCssName) ? $this->subscriberTransformationCssName : null;
    }
    /**
     * Set subscriberTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscriberTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setSubscriberTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscriberTransformationCssName = null)
    {
        if (is_null($subscriberTransformationCssName) || (is_array($subscriberTransformationCssName) && empty($subscriberTransformationCssName))) {
            unset($this->subscriberTransformationCssName);
        } else {
            $this->subscriberTransformationCssName = $subscriberTransformationCssName;
        }
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssNatl value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssNatl()
    {
        return $this->useDevicePoolCgpnTransformCssNatl;
    }
    /**
     * Set useDevicePoolCgpnTransformCssNatl value
     * @param string $useDevicePoolCgpnTransformCssNatl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setUseDevicePoolCgpnTransformCssNatl($useDevicePoolCgpnTransformCssNatl = 'true')
    {
        $this->useDevicePoolCgpnTransformCssNatl = $useDevicePoolCgpnTransformCssNatl;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssIntl value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssIntl()
    {
        return $this->useDevicePoolCgpnTransformCssIntl;
    }
    /**
     * Set useDevicePoolCgpnTransformCssIntl value
     * @param string $useDevicePoolCgpnTransformCssIntl
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setUseDevicePoolCgpnTransformCssIntl($useDevicePoolCgpnTransformCssIntl = 'true')
    {
        $this->useDevicePoolCgpnTransformCssIntl = $useDevicePoolCgpnTransformCssIntl;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssUnkn value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssUnkn()
    {
        return $this->useDevicePoolCgpnTransformCssUnkn;
    }
    /**
     * Set useDevicePoolCgpnTransformCssUnkn value
     * @param string $useDevicePoolCgpnTransformCssUnkn
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setUseDevicePoolCgpnTransformCssUnkn($useDevicePoolCgpnTransformCssUnkn = 'true')
    {
        $this->useDevicePoolCgpnTransformCssUnkn = $useDevicePoolCgpnTransformCssUnkn;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssSubs value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssSubs()
    {
        return $this->useDevicePoolCgpnTransformCssSubs;
    }
    /**
     * Set useDevicePoolCgpnTransformCssSubs value
     * @param string $useDevicePoolCgpnTransformCssSubs
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setUseDevicePoolCgpnTransformCssSubs($useDevicePoolCgpnTransformCssSubs = 'true')
    {
        $this->useDevicePoolCgpnTransformCssSubs = $useDevicePoolCgpnTransformCssSubs;
        return $this;
    }
    /**
     * Get pstnAccess value
     * @return string|null
     */
    public function getPstnAccess()
    {
        return $this->pstnAccess;
    }
    /**
     * Set pstnAccess value
     * @param string $pstnAccess
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setPstnAccess($pstnAccess = 'true')
    {
        $this->pstnAccess = $pstnAccess;
        return $this;
    }
    /**
     * Get imeE164TransformationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getImeE164TransformationName()
    {
        return isset($this->imeE164TransformationName) ? $this->imeE164TransformationName : null;
    }
    /**
     * Set imeE164TransformationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeE164TransformationName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCiscoCatalyst6000T1VoIPGatewayPri
     */
    public function setImeE164TransformationName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeE164TransformationName = null)
    {
        if (is_null($imeE164TransformationName) || (is_array($imeE164TransformationName) && empty($imeE164TransformationName))) {
            unset($this->imeE164TransformationName);
        } else {
            $this->imeE164TransformationName = $imeE164TransformationName;
        }
        return $this;
    }
}
