<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XCcdHostedDNGroup StructType
 * @subpackage Structs
 */
class XCcdHostedDNGroup extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The pstnFailoverStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $pstnFailoverStripDigits;
    /**
     * The pstnFailoverPrependDigits
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $pstnFailoverPrependDigits;
    /**
     * The usePstnFailover
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $usePstnFailover;
    /**
     * Constructor method for XCcdHostedDNGroup
     * @uses XCcdHostedDNGroup::setName()
     * @uses XCcdHostedDNGroup::setDescription()
     * @uses XCcdHostedDNGroup::setPstnFailoverStripDigits()
     * @uses XCcdHostedDNGroup::setPstnFailoverPrependDigits()
     * @uses XCcdHostedDNGroup::setUsePstnFailover()
     * @param string $name
     * @param string $description
     * @param string $pstnFailoverStripDigits
     * @param string $pstnFailoverPrependDigits
     * @param string $usePstnFailover
     */
    public function __construct($name = null, $description = null, $pstnFailoverStripDigits = null, $pstnFailoverPrependDigits = null, $usePstnFailover = 'false')
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setPstnFailoverStripDigits($pstnFailoverStripDigits)
            ->setPstnFailoverPrependDigits($pstnFailoverPrependDigits)
            ->setUsePstnFailover($usePstnFailover);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCcdHostedDNGroup
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCcdHostedDNGroup
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get pstnFailoverStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPstnFailoverStripDigits()
    {
        return isset($this->pstnFailoverStripDigits) ? $this->pstnFailoverStripDigits : null;
    }
    /**
     * Set pstnFailoverStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pstnFailoverStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCcdHostedDNGroup
     */
    public function setPstnFailoverStripDigits($pstnFailoverStripDigits = null)
    {
        if (is_null($pstnFailoverStripDigits) || (is_array($pstnFailoverStripDigits) && empty($pstnFailoverStripDigits))) {
            unset($this->pstnFailoverStripDigits);
        } else {
            $this->pstnFailoverStripDigits = $pstnFailoverStripDigits;
        }
        return $this;
    }
    /**
     * Get pstnFailoverPrependDigits value
     * @return string|null
     */
    public function getPstnFailoverPrependDigits()
    {
        return $this->pstnFailoverPrependDigits;
    }
    /**
     * Set pstnFailoverPrependDigits value
     * @param string $pstnFailoverPrependDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCcdHostedDNGroup
     */
    public function setPstnFailoverPrependDigits($pstnFailoverPrependDigits = null)
    {
        $this->pstnFailoverPrependDigits = $pstnFailoverPrependDigits;
        return $this;
    }
    /**
     * Get usePstnFailover value
     * @return string|null
     */
    public function getUsePstnFailover()
    {
        return $this->usePstnFailover;
    }
    /**
     * Set usePstnFailover value
     * @param string $usePstnFailover
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XCcdHostedDNGroup
     */
    public function setUsePstnFailover($usePstnFailover = 'false')
    {
        $this->usePstnFailover = $usePstnFailover;
        return $this;
    }
}
