<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XButton StructType
 * @subpackage Structs
 */
class XButton extends AbstractStructBase
{
    /**
     * The feature
     * Meta information extracted from the WSDL
     * - documentation: The feature invoked by this button.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $feature;
    /**
     * The buttonNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $buttonNumber;
    /**
     * The label
     * Meta information extracted from the WSDL
     * - documentation: The label invoked by this button.
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $label;
    /**
     * Constructor method for XButton
     * @uses XButton::setFeature()
     * @uses XButton::setButtonNumber()
     * @uses XButton::setLabel()
     * @param string $feature
     * @param string $buttonNumber
     * @param string $label
     */
    public function __construct($feature = null, $buttonNumber = null, $label = null)
    {
        $this
            ->setFeature($feature)
            ->setButtonNumber($buttonNumber)
            ->setLabel($label);
    }
    /**
     * Get feature value
     * @return string
     */
    public function getFeature()
    {
        return $this->feature;
    }
    /**
     * Set feature value
     * @param string $feature
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XButton
     */
    public function setFeature($feature = null)
    {
        $this->feature = $feature;
        return $this;
    }
    /**
     * Get buttonNumber value
     * @return string
     */
    public function getButtonNumber()
    {
        return $this->buttonNumber;
    }
    /**
     * Set buttonNumber value
     * @param string $buttonNumber
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XButton
     */
    public function setButtonNumber($buttonNumber = null)
    {
        $this->buttonNumber = $buttonNumber;
        return $this;
    }
    /**
     * Get label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->label;
    }
    /**
     * Set label value
     * @param string $label
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XButton
     */
    public function setLabel($label = null)
    {
        $this->label = $label;
        return $this;
    }
}
