<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XBillingServer StructType
 * @subpackage Structs
 */
class XBillingServer extends AbstractStructBase
{
    /**
     * The hostName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $hostName;
    /**
     * The userId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $userId;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $password;
    /**
     * The directory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $directory;
    /**
     * The billingServerProtocol
     * Meta information extracted from the WSDL
     * - default: SFTP
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $billingServerProtocol;
    /**
     * The resendOnFailure
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $resendOnFailure;
    /**
     * Constructor method for XBillingServer
     * @uses XBillingServer::setHostName()
     * @uses XBillingServer::setUserId()
     * @uses XBillingServer::setPassword()
     * @uses XBillingServer::setDirectory()
     * @uses XBillingServer::setBillingServerProtocol()
     * @uses XBillingServer::setResendOnFailure()
     * @param string $hostName
     * @param string $userId
     * @param string $password
     * @param string $directory
     * @param string $billingServerProtocol
     * @param string $resendOnFailure
     */
    public function __construct($hostName = null, $userId = null, $password = null, $directory = null, $billingServerProtocol = 'SFTP', $resendOnFailure = 'true')
    {
        $this
            ->setHostName($hostName)
            ->setUserId($userId)
            ->setPassword($password)
            ->setDirectory($directory)
            ->setBillingServerProtocol($billingServerProtocol)
            ->setResendOnFailure($resendOnFailure);
    }
    /**
     * Get hostName value
     * @return string
     */
    public function getHostName()
    {
        return $this->hostName;
    }
    /**
     * Set hostName value
     * @param string $hostName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XBillingServer
     */
    public function setHostName($hostName = null)
    {
        $this->hostName = $hostName;
        return $this;
    }
    /**
     * Get userId value
     * @return string
     */
    public function getUserId()
    {
        return $this->userId;
    }
    /**
     * Set userId value
     * @param string $userId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XBillingServer
     */
    public function setUserId($userId = null)
    {
        $this->userId = $userId;
        return $this;
    }
    /**
     * Get password value
     * @return string
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XBillingServer
     */
    public function setPassword($password = null)
    {
        $this->password = $password;
        return $this;
    }
    /**
     * Get directory value
     * @return string
     */
    public function getDirectory()
    {
        return $this->directory;
    }
    /**
     * Set directory value
     * @param string $directory
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XBillingServer
     */
    public function setDirectory($directory = null)
    {
        $this->directory = $directory;
        return $this;
    }
    /**
     * Get billingServerProtocol value
     * @return string
     */
    public function getBillingServerProtocol()
    {
        return $this->billingServerProtocol;
    }
    /**
     * Set billingServerProtocol value
     * @param string $billingServerProtocol
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XBillingServer
     */
    public function setBillingServerProtocol($billingServerProtocol = 'SFTP')
    {
        $this->billingServerProtocol = $billingServerProtocol;
        return $this;
    }
    /**
     * Get resendOnFailure value
     * @return string|null
     */
    public function getResendOnFailure()
    {
        return $this->resendOnFailure;
    }
    /**
     * Set resendOnFailure value
     * @param string $resendOnFailure
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XBillingServer
     */
    public function setResendOnFailure($resendOnFailure = 'true')
    {
        $this->resendOnFailure = $resendOnFailure;
        return $this;
    }
}
