<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateTvsCertificateReq StructType
 * @subpackage Structs
 */
class UpdateTvsCertificateReq extends APIRequest
{
    /**
     * The issuerName
     * Meta information extracted from the WSDL
     * - choice: uuid | issuerName | serialNumber
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $issuerName;
    /**
     * The serialNumber
     * Meta information extracted from the WSDL
     * - choice: uuid | issuerName | serialNumber
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $serialNumber;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | issuerName | serialNumber
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The timeToLive
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $timeToLive;
    /**
     * Constructor method for UpdateTvsCertificateReq
     * @uses UpdateTvsCertificateReq::setIssuerName()
     * @uses UpdateTvsCertificateReq::setSerialNumber()
     * @uses UpdateTvsCertificateReq::setUuid()
     * @uses UpdateTvsCertificateReq::setTimeToLive()
     * @param string $issuerName
     * @param string $serialNumber
     * @param string $uuid
     * @param int $timeToLive
     */
    public function __construct($issuerName = null, $serialNumber = null, $uuid = null, $timeToLive = null)
    {
        $this
            ->setIssuerName($issuerName)
            ->setSerialNumber($serialNumber)
            ->setUuid($uuid)
            ->setTimeToLive($timeToLive);
    }
    /**
     * Get issuerName value
     * @return string
     */
    public function getIssuerName()
    {
        return isset($this->issuerName) ? $this->issuerName : null;
    }
    /**
     * Set issuerName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $issuerName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateTvsCertificateReq
     */
    public function setIssuerName($issuerName = null)
    {
        if (is_null($issuerName) || (is_array($issuerName) && empty($issuerName))) {
            unset($this->issuerName);
        } else {
            $this->issuerName = $issuerName;
        }
        return $this;
    }
    /**
     * Get serialNumber value
     * @return string
     */
    public function getSerialNumber()
    {
        return isset($this->serialNumber) ? $this->serialNumber : null;
    }
    /**
     * Set serialNumber value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $serialNumber
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateTvsCertificateReq
     */
    public function setSerialNumber($serialNumber = null)
    {
        if (is_null($serialNumber) || (is_array($serialNumber) && empty($serialNumber))) {
            unset($this->serialNumber);
        } else {
            $this->serialNumber = $serialNumber;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateTvsCertificateReq
     */
    public function setUuid($uuid = null)
    {
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get timeToLive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTimeToLive()
    {
        return isset($this->timeToLive) ? $this->timeToLive : null;
    }
    /**
     * Set timeToLive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $timeToLive
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateTvsCertificateReq
     */
    public function setTimeToLive($timeToLive = null)
    {
        if (is_null($timeToLive) || (is_array($timeToLive) && empty($timeToLive))) {
            unset($this->timeToLive);
        } else {
            $this->timeToLive = $timeToLive;
        }
        return $this;
    }
}
