<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateSafForwarderReq StructType
 * @subpackage Structs
 */
class UpdateSafForwarderReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The clientLabel
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $clientLabel;
    /**
     * The safSecurityProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $safSecurityProfile;
    /**
     * The ipAddress
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ipAddress;
    /**
     * The port
     * Meta information extracted from the WSDL
     * - default: 5050
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $port;
    /**
     * The enableTcpKeepAlive
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableTcpKeepAlive;
    /**
     * The safReconnectInterval
     * Meta information extracted from the WSDL
     * - default: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $safReconnectInterval;
    /**
     * The safNotificationsWindowSize
     * Meta information extracted from the WSDL
     * - default: 7
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $safNotificationsWindowSize;
    /**
     * The removeAssociatedCucms
     * Meta information extracted from the WSDL
     * - choice: removeAssociatedCucms | addAssociatedCucms | associatedCucms
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\RemoveAssociatedCucms
     */
    public $removeAssociatedCucms;
    /**
     * The addAssociatedCucms
     * Meta information extracted from the WSDL
     * - choice: removeAssociatedCucms | addAssociatedCucms | associatedCucms
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\AddAssociatedCucms
     */
    public $addAssociatedCucms;
    /**
     * The associatedCucms
     * Meta information extracted from the WSDL
     * - choice: removeAssociatedCucms | addAssociatedCucms | associatedCucms
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedCucms
     */
    public $associatedCucms;
    /**
     * Constructor method for UpdateSafForwarderReq
     * @uses UpdateSafForwarderReq::setNewName()
     * @uses UpdateSafForwarderReq::setDescription()
     * @uses UpdateSafForwarderReq::setClientLabel()
     * @uses UpdateSafForwarderReq::setSafSecurityProfile()
     * @uses UpdateSafForwarderReq::setIpAddress()
     * @uses UpdateSafForwarderReq::setPort()
     * @uses UpdateSafForwarderReq::setEnableTcpKeepAlive()
     * @uses UpdateSafForwarderReq::setSafReconnectInterval()
     * @uses UpdateSafForwarderReq::setSafNotificationsWindowSize()
     * @uses UpdateSafForwarderReq::setRemoveAssociatedCucms()
     * @uses UpdateSafForwarderReq::setAddAssociatedCucms()
     * @uses UpdateSafForwarderReq::setAssociatedCucms()
     * @param string $newName
     * @param string $description
     * @param string $clientLabel
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $safSecurityProfile
     * @param string $ipAddress
     * @param string $port
     * @param string $enableTcpKeepAlive
     * @param string $safReconnectInterval
     * @param string $safNotificationsWindowSize
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveAssociatedCucms $removeAssociatedCucms
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AddAssociatedCucms $addAssociatedCucms
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedCucms $associatedCucms
     */
    public function __construct($newName = null, $description = null, $clientLabel = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $safSecurityProfile = null, $ipAddress = null, $port = '5050', $enableTcpKeepAlive = 'true', $safReconnectInterval = '20', $safNotificationsWindowSize = '7', \\Losc\CucmBundle\Model\Webservice\StructType\RemoveAssociatedCucms $removeAssociatedCucms = null, \\Losc\CucmBundle\Model\Webservice\StructType\AddAssociatedCucms $addAssociatedCucms = null, \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedCucms $associatedCucms = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setClientLabel($clientLabel)
            ->setSafSecurityProfile($safSecurityProfile)
            ->setIpAddress($ipAddress)
            ->setPort($port)
            ->setEnableTcpKeepAlive($enableTcpKeepAlive)
            ->setSafReconnectInterval($safReconnectInterval)
            ->setSafNotificationsWindowSize($safNotificationsWindowSize)
            ->setRemoveAssociatedCucms($removeAssociatedCucms)
            ->setAddAssociatedCucms($addAssociatedCucms)
            ->setAssociatedCucms($associatedCucms);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSafForwarderReq
     */
    public function setNewName($newName = null)
    {
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSafForwarderReq
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get clientLabel value
     * @return string|null
     */
    public function getClientLabel()
    {
        return $this->clientLabel;
    }
    /**
     * Set clientLabel value
     * @param string $clientLabel
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSafForwarderReq
     */
    public function setClientLabel($clientLabel = null)
    {
        $this->clientLabel = $clientLabel;
        return $this;
    }
    /**
     * Get safSecurityProfile value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSafSecurityProfile()
    {
        return $this->safSecurityProfile;
    }
    /**
     * Set safSecurityProfile value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $safSecurityProfile
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSafForwarderReq
     */
    public function setSafSecurityProfile(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $safSecurityProfile = null)
    {
        $this->safSecurityProfile = $safSecurityProfile;
        return $this;
    }
    /**
     * Get ipAddress value
     * @return string|null
     */
    public function getIpAddress()
    {
        return $this->ipAddress;
    }
    /**
     * Set ipAddress value
     * @param string $ipAddress
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSafForwarderReq
     */
    public function setIpAddress($ipAddress = null)
    {
        $this->ipAddress = $ipAddress;
        return $this;
    }
    /**
     * Get port value
     * @return string|null
     */
    public function getPort()
    {
        return $this->port;
    }
    /**
     * Set port value
     * @param string $port
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSafForwarderReq
     */
    public function setPort($port = '5050')
    {
        $this->port = $port;
        return $this;
    }
    /**
     * Get enableTcpKeepAlive value
     * @return string|null
     */
    public function getEnableTcpKeepAlive()
    {
        return $this->enableTcpKeepAlive;
    }
    /**
     * Set enableTcpKeepAlive value
     * @param string $enableTcpKeepAlive
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSafForwarderReq
     */
    public function setEnableTcpKeepAlive($enableTcpKeepAlive = 'true')
    {
        $this->enableTcpKeepAlive = $enableTcpKeepAlive;
        return $this;
    }
    /**
     * Get safReconnectInterval value
     * @return string|null
     */
    public function getSafReconnectInterval()
    {
        return $this->safReconnectInterval;
    }
    /**
     * Set safReconnectInterval value
     * @param string $safReconnectInterval
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSafForwarderReq
     */
    public function setSafReconnectInterval($safReconnectInterval = '20')
    {
        $this->safReconnectInterval = $safReconnectInterval;
        return $this;
    }
    /**
     * Get safNotificationsWindowSize value
     * @return string|null
     */
    public function getSafNotificationsWindowSize()
    {
        return $this->safNotificationsWindowSize;
    }
    /**
     * Set safNotificationsWindowSize value
     * @param string $safNotificationsWindowSize
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSafForwarderReq
     */
    public function setSafNotificationsWindowSize($safNotificationsWindowSize = '7')
    {
        $this->safNotificationsWindowSize = $safNotificationsWindowSize;
        return $this;
    }
    /**
     * Get removeAssociatedCucms value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RemoveAssociatedCucms|null
     */
    public function getRemoveAssociatedCucms()
    {
        return isset($this->removeAssociatedCucms) ? $this->removeAssociatedCucms : null;
    }
    /**
     * Set removeAssociatedCucms value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RemoveAssociatedCucms $removeAssociatedCucms
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSafForwarderReq
     */
    public function setRemoveAssociatedCucms(\\Losc\CucmBundle\Model\Webservice\StructType\RemoveAssociatedCucms $removeAssociatedCucms = null)
    {
        if (is_null($removeAssociatedCucms) || (is_array($removeAssociatedCucms) && empty($removeAssociatedCucms))) {
            unset($this->removeAssociatedCucms);
        } else {
            $this->removeAssociatedCucms = $removeAssociatedCucms;
        }
        return $this;
    }
    /**
     * Get addAssociatedCucms value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\AddAssociatedCucms|null
     */
    public function getAddAssociatedCucms()
    {
        return isset($this->addAssociatedCucms) ? $this->addAssociatedCucms : null;
    }
    /**
     * Set addAssociatedCucms value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AddAssociatedCucms $addAssociatedCucms
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSafForwarderReq
     */
    public function setAddAssociatedCucms(\\Losc\CucmBundle\Model\Webservice\StructType\AddAssociatedCucms $addAssociatedCucms = null)
    {
        if (is_null($addAssociatedCucms) || (is_array($addAssociatedCucms) && empty($addAssociatedCucms))) {
            unset($this->addAssociatedCucms);
        } else {
            $this->addAssociatedCucms = $addAssociatedCucms;
        }
        return $this;
    }
    /**
     * Get associatedCucms value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedCucms|null
     */
    public function getAssociatedCucms()
    {
        return isset($this->associatedCucms) ? $this->associatedCucms : null;
    }
    /**
     * Set associatedCucms value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedCucms $associatedCucms
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateSafForwarderReq
     */
    public function setAssociatedCucms(\\Losc\CucmBundle\Model\Webservice\StructType\AssociatedCucms $associatedCucms = null)
    {
        if (is_null($associatedCucms) || (is_array($associatedCucms) && empty($associatedCucms))) {
            unset($this->associatedCucms);
        } else {
            $this->associatedCucms = $associatedCucms;
        }
        return $this;
    }
}
