<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateResourcePriorityNamespaceReq StructType
 * @subpackage Structs
 */
class UpdateResourcePriorityNamespaceReq extends APIRequest
{
    /**
     * The namespace
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | namespace
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $namespace;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | namespace
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The newNamespace
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newNamespace;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The isDefault
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isDefault;
    /**
     * Constructor method for UpdateResourcePriorityNamespaceReq
     * @uses UpdateResourcePriorityNamespaceReq::setNamespace()
     * @uses UpdateResourcePriorityNamespaceReq::setUuid()
     * @uses UpdateResourcePriorityNamespaceReq::setNewNamespace()
     * @uses UpdateResourcePriorityNamespaceReq::setDescription()
     * @uses UpdateResourcePriorityNamespaceReq::setIsDefault()
     * @param string $namespace
     * @param string $uuid
     * @param string $newNamespace
     * @param string $description
     * @param string $isDefault
     */
    public function __construct($namespace = null, $uuid = null, $newNamespace = null, $description = null, $isDefault = null)
    {
        $this
            ->setNamespace($namespace)
            ->setUuid($uuid)
            ->setNewNamespace($newNamespace)
            ->setDescription($description)
            ->setIsDefault($isDefault);
    }
    /**
     * Get namespace value
     * @return string
     */
    public function getNamespace()
    {
        return isset($this->namespace) ? $this->namespace : null;
    }
    /**
     * Set namespace value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $namespace
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateResourcePriorityNamespaceReq
     */
    public function setNamespace($namespace = null)
    {
        if (is_null($namespace) || (is_array($namespace) && empty($namespace))) {
            unset($this->namespace);
        } else {
            $this->namespace = $namespace;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateResourcePriorityNamespaceReq
     */
    public function setUuid($uuid = null)
    {
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get newNamespace value
     * @return string|null
     */
    public function getNewNamespace()
    {
        return $this->newNamespace;
    }
    /**
     * Set newNamespace value
     * @param string $newNamespace
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateResourcePriorityNamespaceReq
     */
    public function setNewNamespace($newNamespace = null)
    {
        $this->newNamespace = $newNamespace;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateResourcePriorityNamespaceReq
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get isDefault value
     * @return string|null
     */
    public function getIsDefault()
    {
        return $this->isDefault;
    }
    /**
     * Set isDefault value
     * @param string $isDefault
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateResourcePriorityNamespaceReq
     */
    public function setIsDefault($isDefault = null)
    {
        $this->isDefault = $isDefault;
        return $this;
    }
}
