<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateRegionMatrixReq StructType
 * @subpackage Structs
 */
class UpdateRegionMatrixReq extends APIRequest
{
    /**
     * The regionAName
     * Meta information extracted from the WSDL
     * - choice: uuid | regionAName | regionBName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $regionAName;
    /**
     * The regionBName
     * Meta information extracted from the WSDL
     * - choice: uuid | regionAName | regionBName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $regionBName;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | regionAName | regionBName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The bandwidth
     * Meta information extracted from the WSDL
     * - documentation: The new bandwidth value for this particular region relationship.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $bandwidth;
    /**
     * The videoBandwidth
     * Meta information extracted from the WSDL
     * - default: 384
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $videoBandwidth;
    /**
     * The codecPreference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $codecPreference;
    /**
     * Constructor method for UpdateRegionMatrixReq
     * @uses UpdateRegionMatrixReq::setRegionAName()
     * @uses UpdateRegionMatrixReq::setRegionBName()
     * @uses UpdateRegionMatrixReq::setUuid()
     * @uses UpdateRegionMatrixReq::setBandwidth()
     * @uses UpdateRegionMatrixReq::setVideoBandwidth()
     * @uses UpdateRegionMatrixReq::setCodecPreference()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $regionAName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $regionBName
     * @param string $uuid
     * @param string $bandwidth
     * @param string $videoBandwidth
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $codecPreference
     */
    public function __construct(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $regionAName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $regionBName = null, $uuid = null, $bandwidth = null, $videoBandwidth = '384', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $codecPreference = null)
    {
        $this
            ->setRegionAName($regionAName)
            ->setRegionBName($regionBName)
            ->setUuid($uuid)
            ->setBandwidth($bandwidth)
            ->setVideoBandwidth($videoBandwidth)
            ->setCodecPreference($codecPreference);
    }
    /**
     * Get regionAName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getRegionAName()
    {
        return isset($this->regionAName) ? $this->regionAName : null;
    }
    /**
     * Set regionAName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $regionAName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateRegionMatrixReq
     */
    public function setRegionAName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $regionAName = null)
    {
        if (is_null($regionAName) || (is_array($regionAName) && empty($regionAName))) {
            unset($this->regionAName);
        } else {
            $this->regionAName = $regionAName;
        }
        return $this;
    }
    /**
     * Get regionBName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getRegionBName()
    {
        return isset($this->regionBName) ? $this->regionBName : null;
    }
    /**
     * Set regionBName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $regionBName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateRegionMatrixReq
     */
    public function setRegionBName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $regionBName = null)
    {
        if (is_null($regionBName) || (is_array($regionBName) && empty($regionBName))) {
            unset($this->regionBName);
        } else {
            $this->regionBName = $regionBName;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateRegionMatrixReq
     */
    public function setUuid($uuid = null)
    {
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get bandwidth value
     * @return string|null
     */
    public function getBandwidth()
    {
        return $this->bandwidth;
    }
    /**
     * Set bandwidth value
     * @param string $bandwidth
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateRegionMatrixReq
     */
    public function setBandwidth($bandwidth = null)
    {
        $this->bandwidth = $bandwidth;
        return $this;
    }
    /**
     * Get videoBandwidth value
     * @return string|null
     */
    public function getVideoBandwidth()
    {
        return $this->videoBandwidth;
    }
    /**
     * Set videoBandwidth value
     * @param string $videoBandwidth
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateRegionMatrixReq
     */
    public function setVideoBandwidth($videoBandwidth = '384')
    {
        $this->videoBandwidth = $videoBandwidth;
        return $this;
    }
    /**
     * Get codecPreference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCodecPreference()
    {
        return isset($this->codecPreference) ? $this->codecPreference : null;
    }
    /**
     * Set codecPreference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $codecPreference
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateRegionMatrixReq
     */
    public function setCodecPreference(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $codecPreference = null)
    {
        if (is_null($codecPreference) || (is_array($codecPreference) && empty($codecPreference))) {
            unset($this->codecPreference);
        } else {
            $this->codecPreference = $codecPreference;
        }
        return $this;
    }
}
