<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateProcessNodeReq StructType
 * @subpackage Structs
 */
class UpdateProcessNodeReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - documentation: The primary hostname of the process node.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The mac
     * Meta information extracted from the WSDL
     * - documentation: The mac address of the host.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: ([0-9]|[a-f]|[A-F]){12}
     * @var string
     */
    public $mac;
    /**
     * The ipv6Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ipv6Name;
    /**
     * The lbmHubGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $lbmHubGroup;
    /**
     * The cupDomain
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cupDomain;
    /**
     * Constructor method for UpdateProcessNodeReq
     * @uses UpdateProcessNodeReq::setNewName()
     * @uses UpdateProcessNodeReq::setDescription()
     * @uses UpdateProcessNodeReq::setMac()
     * @uses UpdateProcessNodeReq::setIpv6Name()
     * @uses UpdateProcessNodeReq::setLbmHubGroup()
     * @uses UpdateProcessNodeReq::setCupDomain()
     * @param string $newName
     * @param string $description
     * @param string $mac
     * @param string $ipv6Name
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $lbmHubGroup
     * @param string $cupDomain
     */
    public function __construct($newName = null, $description = null, $mac = null, $ipv6Name = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $lbmHubGroup = null, $cupDomain = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setMac($mac)
            ->setIpv6Name($ipv6Name)
            ->setLbmHubGroup($lbmHubGroup)
            ->setCupDomain($cupDomain);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateProcessNodeReq
     */
    public function setNewName($newName = null)
    {
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateProcessNodeReq
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get mac value
     * @return string|null
     */
    public function getMac()
    {
        return $this->mac;
    }
    /**
     * Set mac value
     * @param string $mac
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateProcessNodeReq
     */
    public function setMac($mac = null)
    {
        $this->mac = $mac;
        return $this;
    }
    /**
     * Get ipv6Name value
     * @return string|null
     */
    public function getIpv6Name()
    {
        return $this->ipv6Name;
    }
    /**
     * Set ipv6Name value
     * @param string $ipv6Name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateProcessNodeReq
     */
    public function setIpv6Name($ipv6Name = null)
    {
        $this->ipv6Name = $ipv6Name;
        return $this;
    }
    /**
     * Get lbmHubGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getLbmHubGroup()
    {
        return isset($this->lbmHubGroup) ? $this->lbmHubGroup : null;
    }
    /**
     * Set lbmHubGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $lbmHubGroup
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateProcessNodeReq
     */
    public function setLbmHubGroup(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $lbmHubGroup = null)
    {
        if (is_null($lbmHubGroup) || (is_array($lbmHubGroup) && empty($lbmHubGroup))) {
            unset($this->lbmHubGroup);
        } else {
            $this->lbmHubGroup = $lbmHubGroup;
        }
        return $this;
    }
    /**
     * Get cupDomain value
     * @return string|null
     */
    public function getCupDomain()
    {
        return $this->cupDomain;
    }
    /**
     * Set cupDomain value
     * @param string $cupDomain
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateProcessNodeReq
     */
    public function setCupDomain($cupDomain = null)
    {
        $this->cupDomain = $cupDomain;
        return $this;
    }
}
