<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdatePhoneNtpReq StructType
 * @subpackage Structs
 */
class UpdatePhoneNtpReq extends APIRequest
{
    /**
     * The ipAddress
     * Meta information extracted from the WSDL
     * - choice: uuid | ipAddress
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $ipAddress;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | ipAddress
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The newIpAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newIpAddress;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The mode
     * Meta information extracted from the WSDL
     * - default: Directed Broadcast
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $mode;
    /**
     * Constructor method for UpdatePhoneNtpReq
     * @uses UpdatePhoneNtpReq::setIpAddress()
     * @uses UpdatePhoneNtpReq::setUuid()
     * @uses UpdatePhoneNtpReq::setNewIpAddress()
     * @uses UpdatePhoneNtpReq::setDescription()
     * @uses UpdatePhoneNtpReq::setMode()
     * @param string $ipAddress
     * @param string $uuid
     * @param string $newIpAddress
     * @param string $description
     * @param string $mode
     */
    public function __construct($ipAddress = null, $uuid = null, $newIpAddress = null, $description = null, $mode = 'Directed Broadcast')
    {
        $this
            ->setIpAddress($ipAddress)
            ->setUuid($uuid)
            ->setNewIpAddress($newIpAddress)
            ->setDescription($description)
            ->setMode($mode);
    }
    /**
     * Get ipAddress value
     * @return string
     */
    public function getIpAddress()
    {
        return isset($this->ipAddress) ? $this->ipAddress : null;
    }
    /**
     * Set ipAddress value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $ipAddress
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdatePhoneNtpReq
     */
    public function setIpAddress($ipAddress = null)
    {
        if (is_null($ipAddress) || (is_array($ipAddress) && empty($ipAddress))) {
            unset($this->ipAddress);
        } else {
            $this->ipAddress = $ipAddress;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdatePhoneNtpReq
     */
    public function setUuid($uuid = null)
    {
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get newIpAddress value
     * @return string|null
     */
    public function getNewIpAddress()
    {
        return $this->newIpAddress;
    }
    /**
     * Set newIpAddress value
     * @param string $newIpAddress
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdatePhoneNtpReq
     */
    public function setNewIpAddress($newIpAddress = null)
    {
        $this->newIpAddress = $newIpAddress;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdatePhoneNtpReq
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get mode value
     * @return string|null
     */
    public function getMode()
    {
        return $this->mode;
    }
    /**
     * Set mode value
     * @param string $mode
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdatePhoneNtpReq
     */
    public function setMode($mode = 'Directed Broadcast')
    {
        $this->mode = $mode;
        return $this;
    }
}
