<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateImeExclusionNumberReq StructType
 * @subpackage Structs
 */
class UpdateImeExclusionNumberReq extends APIRequest
{
    /**
     * The pattern
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | pattern
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $pattern;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | pattern
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The newPattern
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newPattern;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The imeExclusionNumberGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $imeExclusionNumberGroupName;
    /**
     * Constructor method for UpdateImeExclusionNumberReq
     * @uses UpdateImeExclusionNumberReq::setPattern()
     * @uses UpdateImeExclusionNumberReq::setUuid()
     * @uses UpdateImeExclusionNumberReq::setNewPattern()
     * @uses UpdateImeExclusionNumberReq::setDescription()
     * @uses UpdateImeExclusionNumberReq::setImeExclusionNumberGroupName()
     * @param string $pattern
     * @param string $uuid
     * @param string $newPattern
     * @param string $description
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeExclusionNumberGroupName
     */
    public function __construct($pattern = null, $uuid = null, $newPattern = null, $description = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeExclusionNumberGroupName = null)
    {
        $this
            ->setPattern($pattern)
            ->setUuid($uuid)
            ->setNewPattern($newPattern)
            ->setDescription($description)
            ->setImeExclusionNumberGroupName($imeExclusionNumberGroupName);
    }
    /**
     * Get pattern value
     * @return string
     */
    public function getPattern()
    {
        return isset($this->pattern) ? $this->pattern : null;
    }
    /**
     * Set pattern value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $pattern
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateImeExclusionNumberReq
     */
    public function setPattern($pattern = null)
    {
        if (is_null($pattern) || (is_array($pattern) && empty($pattern))) {
            unset($this->pattern);
        } else {
            $this->pattern = $pattern;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateImeExclusionNumberReq
     */
    public function setUuid($uuid = null)
    {
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get newPattern value
     * @return string|null
     */
    public function getNewPattern()
    {
        return $this->newPattern;
    }
    /**
     * Set newPattern value
     * @param string $newPattern
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateImeExclusionNumberReq
     */
    public function setNewPattern($newPattern = null)
    {
        $this->newPattern = $newPattern;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateImeExclusionNumberReq
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get imeExclusionNumberGroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getImeExclusionNumberGroupName()
    {
        return isset($this->imeExclusionNumberGroupName) ? $this->imeExclusionNumberGroupName : null;
    }
    /**
     * Set imeExclusionNumberGroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeExclusionNumberGroupName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateImeExclusionNumberReq
     */
    public function setImeExclusionNumberGroupName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeExclusionNumberGroupName = null)
    {
        if (is_null($imeExclusionNumberGroupName) || (is_array($imeExclusionNumberGroupName) && empty($imeExclusionNumberGroupName))) {
            unset($this->imeExclusionNumberGroupName);
        } else {
            $this->imeExclusionNumberGroupName = $imeExclusionNumberGroupName;
        }
        return $this;
    }
}
