<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateImeEnrolledPatternReq StructType
 * @subpackage Structs
 */
class UpdateImeEnrolledPatternReq extends APIRequest
{
    /**
     * The pattern
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | pattern
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $pattern;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | pattern
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The newPattern
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newPattern;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The imeEnrolledPatternGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $imeEnrolledPatternGroupName;
    /**
     * Constructor method for UpdateImeEnrolledPatternReq
     * @uses UpdateImeEnrolledPatternReq::setPattern()
     * @uses UpdateImeEnrolledPatternReq::setUuid()
     * @uses UpdateImeEnrolledPatternReq::setNewPattern()
     * @uses UpdateImeEnrolledPatternReq::setDescription()
     * @uses UpdateImeEnrolledPatternReq::setImeEnrolledPatternGroupName()
     * @param string $pattern
     * @param string $uuid
     * @param string $newPattern
     * @param string $description
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeEnrolledPatternGroupName
     */
    public function __construct($pattern = null, $uuid = null, $newPattern = null, $description = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeEnrolledPatternGroupName = null)
    {
        $this
            ->setPattern($pattern)
            ->setUuid($uuid)
            ->setNewPattern($newPattern)
            ->setDescription($description)
            ->setImeEnrolledPatternGroupName($imeEnrolledPatternGroupName);
    }
    /**
     * Get pattern value
     * @return string
     */
    public function getPattern()
    {
        return isset($this->pattern) ? $this->pattern : null;
    }
    /**
     * Set pattern value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $pattern
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateImeEnrolledPatternReq
     */
    public function setPattern($pattern = null)
    {
        if (is_null($pattern) || (is_array($pattern) && empty($pattern))) {
            unset($this->pattern);
        } else {
            $this->pattern = $pattern;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateImeEnrolledPatternReq
     */
    public function setUuid($uuid = null)
    {
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get newPattern value
     * @return string|null
     */
    public function getNewPattern()
    {
        return $this->newPattern;
    }
    /**
     * Set newPattern value
     * @param string $newPattern
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateImeEnrolledPatternReq
     */
    public function setNewPattern($newPattern = null)
    {
        $this->newPattern = $newPattern;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateImeEnrolledPatternReq
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get imeEnrolledPatternGroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getImeEnrolledPatternGroupName()
    {
        return isset($this->imeEnrolledPatternGroupName) ? $this->imeEnrolledPatternGroupName : null;
    }
    /**
     * Set imeEnrolledPatternGroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeEnrolledPatternGroupName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateImeEnrolledPatternReq
     */
    public function setImeEnrolledPatternGroupName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeEnrolledPatternGroupName = null)
    {
        if (is_null($imeEnrolledPatternGroupName) || (is_array($imeEnrolledPatternGroupName) && empty($imeEnrolledPatternGroupName))) {
            unset($this->imeEnrolledPatternGroupName);
        } else {
            $this->imeEnrolledPatternGroupName = $imeEnrolledPatternGroupName;
        }
        return $this;
    }
}
