<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateEmccFeatureConfigReq StructType
 * @subpackage Structs
 */
class UpdateEmccFeatureConfigReq extends APIRequest
{
    /**
     * The parameterName
     * Meta information extracted from the WSDL
     * - documentation: Name of the Emcc Parameter
     * - base: xsd:string
     * - choice: uuid | parameterName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $parameterName;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | parameterName
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The value
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $value;
    /**
     * Constructor method for UpdateEmccFeatureConfigReq
     * @uses UpdateEmccFeatureConfigReq::setParameterName()
     * @uses UpdateEmccFeatureConfigReq::setUuid()
     * @uses UpdateEmccFeatureConfigReq::setValue()
     * @param string $parameterName
     * @param string $uuid
     * @param string $value
     */
    public function __construct($parameterName = null, $uuid = null, $value = null)
    {
        $this
            ->setParameterName($parameterName)
            ->setUuid($uuid)
            ->setValue($value);
    }
    /**
     * Get parameterName value
     * @return string
     */
    public function getParameterName()
    {
        return isset($this->parameterName) ? $this->parameterName : null;
    }
    /**
     * Set parameterName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $parameterName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateEmccFeatureConfigReq
     */
    public function setParameterName($parameterName = null)
    {
        if (is_null($parameterName) || (is_array($parameterName) && empty($parameterName))) {
            unset($this->parameterName);
        } else {
            $this->parameterName = $parameterName;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateEmccFeatureConfigReq
     */
    public function setUuid($uuid = null)
    {
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get value value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValue()
    {
        return isset($this->value) ? $this->value : null;
    }
    /**
     * Set value value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateEmccFeatureConfigReq
     */
    public function setValue($value = null)
    {
        if (is_null($value) || (is_array($value) && empty($value))) {
            unset($this->value);
        } else {
            $this->value = $value;
        }
        return $this;
    }
}
