<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCommonPhoneConfigReq StructType
 * @subpackage Structs
 */
class UpdateCommonPhoneConfigReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The unlockPwd
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $unlockPwd;
    /**
     * The dndOption
     * Meta information extracted from the WSDL
     * - default: Ringer Off
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $dndOption;
    /**
     * The dndAlertingType
     * Meta information extracted from the WSDL
     * - default: Beep Only
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $dndAlertingType;
    /**
     * The backgroundImage
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $backgroundImage;
    /**
     * The phonePersonalization
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $phonePersonalization;
    /**
     * The phoneServiceDisplay
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $phoneServiceDisplay;
    /**
     * The sshUserId
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $sshUserId;
    /**
     * The sshPwd
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $sshPwd;
    /**
     * The vendorConfig
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig
     */
    public $vendorConfig;
    /**
     * The alwaysUsePrimeLine
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $alwaysUsePrimeLine;
    /**
     * The alwaysUsePrimeLineForVoiceMessage
     * Meta information extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $alwaysUsePrimeLineForVoiceMessage;
    /**
     * The vpnGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $vpnGroupName;
    /**
     * The vpnProfileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $vpnProfileName;
    /**
     * The featureControlPolicy
     * Meta information extracted from the WSDL
     * - documentation: This tag is valid only for RT Phones.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $featureControlPolicy;
    /**
     * The wifiHotspotProfile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $wifiHotspotProfile;
    /**
     * Constructor method for UpdateCommonPhoneConfigReq
     * @uses UpdateCommonPhoneConfigReq::setNewName()
     * @uses UpdateCommonPhoneConfigReq::setDescription()
     * @uses UpdateCommonPhoneConfigReq::setUnlockPwd()
     * @uses UpdateCommonPhoneConfigReq::setDndOption()
     * @uses UpdateCommonPhoneConfigReq::setDndAlertingType()
     * @uses UpdateCommonPhoneConfigReq::setBackgroundImage()
     * @uses UpdateCommonPhoneConfigReq::setPhonePersonalization()
     * @uses UpdateCommonPhoneConfigReq::setPhoneServiceDisplay()
     * @uses UpdateCommonPhoneConfigReq::setSshUserId()
     * @uses UpdateCommonPhoneConfigReq::setSshPwd()
     * @uses UpdateCommonPhoneConfigReq::setVendorConfig()
     * @uses UpdateCommonPhoneConfigReq::setAlwaysUsePrimeLine()
     * @uses UpdateCommonPhoneConfigReq::setAlwaysUsePrimeLineForVoiceMessage()
     * @uses UpdateCommonPhoneConfigReq::setVpnGroupName()
     * @uses UpdateCommonPhoneConfigReq::setVpnProfileName()
     * @uses UpdateCommonPhoneConfigReq::setFeatureControlPolicy()
     * @uses UpdateCommonPhoneConfigReq::setWifiHotspotProfile()
     * @param string $newName
     * @param string $description
     * @param string $unlockPwd
     * @param string $dndOption
     * @param string $dndAlertingType
     * @param string $backgroundImage
     * @param string $phonePersonalization
     * @param string $phoneServiceDisplay
     * @param string $sshUserId
     * @param string $sshPwd
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig
     * @param string $alwaysUsePrimeLine
     * @param string $alwaysUsePrimeLineForVoiceMessage
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $vpnGroupName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $vpnProfileName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $featureControlPolicy
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $wifiHotspotProfile
     */
    public function __construct($newName = null, $description = null, $unlockPwd = null, $dndOption = 'Ringer Off', $dndAlertingType = 'Beep Only', $backgroundImage = 'true', $phonePersonalization = 'Default', $phoneServiceDisplay = 'Default', $sshUserId = null, $sshPwd = null, \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig = null, $alwaysUsePrimeLine = 'Default', $alwaysUsePrimeLineForVoiceMessage = 'Default', \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $vpnGroupName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $vpnProfileName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $featureControlPolicy = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $wifiHotspotProfile = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setUnlockPwd($unlockPwd)
            ->setDndOption($dndOption)
            ->setDndAlertingType($dndAlertingType)
            ->setBackgroundImage($backgroundImage)
            ->setPhonePersonalization($phonePersonalization)
            ->setPhoneServiceDisplay($phoneServiceDisplay)
            ->setSshUserId($sshUserId)
            ->setSshPwd($sshPwd)
            ->setVendorConfig($vendorConfig)
            ->setAlwaysUsePrimeLine($alwaysUsePrimeLine)
            ->setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage)
            ->setVpnGroupName($vpnGroupName)
            ->setVpnProfileName($vpnProfileName)
            ->setFeatureControlPolicy($featureControlPolicy)
            ->setWifiHotspotProfile($wifiHotspotProfile);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCommonPhoneConfigReq
     */
    public function setNewName($newName = null)
    {
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCommonPhoneConfigReq
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get unlockPwd value
     * @return string|null
     */
    public function getUnlockPwd()
    {
        return $this->unlockPwd;
    }
    /**
     * Set unlockPwd value
     * @param string $unlockPwd
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCommonPhoneConfigReq
     */
    public function setUnlockPwd($unlockPwd = null)
    {
        $this->unlockPwd = $unlockPwd;
        return $this;
    }
    /**
     * Get dndOption value
     * @return string|null
     */
    public function getDndOption()
    {
        return $this->dndOption;
    }
    /**
     * Set dndOption value
     * @param string $dndOption
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCommonPhoneConfigReq
     */
    public function setDndOption($dndOption = 'Ringer Off')
    {
        $this->dndOption = $dndOption;
        return $this;
    }
    /**
     * Get dndAlertingType value
     * @return string|null
     */
    public function getDndAlertingType()
    {
        return $this->dndAlertingType;
    }
    /**
     * Set dndAlertingType value
     * @param string $dndAlertingType
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCommonPhoneConfigReq
     */
    public function setDndAlertingType($dndAlertingType = 'Beep Only')
    {
        $this->dndAlertingType = $dndAlertingType;
        return $this;
    }
    /**
     * Get backgroundImage value
     * @return string|null
     */
    public function getBackgroundImage()
    {
        return $this->backgroundImage;
    }
    /**
     * Set backgroundImage value
     * @param string $backgroundImage
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCommonPhoneConfigReq
     */
    public function setBackgroundImage($backgroundImage = 'true')
    {
        $this->backgroundImage = $backgroundImage;
        return $this;
    }
    /**
     * Get phonePersonalization value
     * @return string|null
     */
    public function getPhonePersonalization()
    {
        return $this->phonePersonalization;
    }
    /**
     * Set phonePersonalization value
     * @param string $phonePersonalization
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCommonPhoneConfigReq
     */
    public function setPhonePersonalization($phonePersonalization = 'Default')
    {
        $this->phonePersonalization = $phonePersonalization;
        return $this;
    }
    /**
     * Get phoneServiceDisplay value
     * @return string|null
     */
    public function getPhoneServiceDisplay()
    {
        return $this->phoneServiceDisplay;
    }
    /**
     * Set phoneServiceDisplay value
     * @param string $phoneServiceDisplay
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCommonPhoneConfigReq
     */
    public function setPhoneServiceDisplay($phoneServiceDisplay = 'Default')
    {
        $this->phoneServiceDisplay = $phoneServiceDisplay;
        return $this;
    }
    /**
     * Get sshUserId value
     * @return string|null
     */
    public function getSshUserId()
    {
        return $this->sshUserId;
    }
    /**
     * Set sshUserId value
     * @param string $sshUserId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCommonPhoneConfigReq
     */
    public function setSshUserId($sshUserId = null)
    {
        $this->sshUserId = $sshUserId;
        return $this;
    }
    /**
     * Get sshPwd value
     * @return string|null
     */
    public function getSshPwd()
    {
        return $this->sshPwd;
    }
    /**
     * Set sshPwd value
     * @param string $sshPwd
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCommonPhoneConfigReq
     */
    public function setSshPwd($sshPwd = null)
    {
        $this->sshPwd = $sshPwd;
        return $this;
    }
    /**
     * Get vendorConfig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig|null
     */
    public function getVendorConfig()
    {
        return isset($this->vendorConfig) ? $this->vendorConfig : null;
    }
    /**
     * Set vendorConfig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCommonPhoneConfigReq
     */
    public function setVendorConfig(\\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig = null)
    {
        if (is_null($vendorConfig) || (is_array($vendorConfig) && empty($vendorConfig))) {
            unset($this->vendorConfig);
        } else {
            $this->vendorConfig = $vendorConfig;
        }
        return $this;
    }
    /**
     * Get alwaysUsePrimeLine value
     * @return string|null
     */
    public function getAlwaysUsePrimeLine()
    {
        return $this->alwaysUsePrimeLine;
    }
    /**
     * Set alwaysUsePrimeLine value
     * @param string $alwaysUsePrimeLine
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCommonPhoneConfigReq
     */
    public function setAlwaysUsePrimeLine($alwaysUsePrimeLine = 'Default')
    {
        $this->alwaysUsePrimeLine = $alwaysUsePrimeLine;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLineForVoiceMessage value
     * @return string|null
     */
    public function getAlwaysUsePrimeLineForVoiceMessage()
    {
        return $this->alwaysUsePrimeLineForVoiceMessage;
    }
    /**
     * Set alwaysUsePrimeLineForVoiceMessage value
     * @param string $alwaysUsePrimeLineForVoiceMessage
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCommonPhoneConfigReq
     */
    public function setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage = 'Default')
    {
        $this->alwaysUsePrimeLineForVoiceMessage = $alwaysUsePrimeLineForVoiceMessage;
        return $this;
    }
    /**
     * Get vpnGroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getVpnGroupName()
    {
        return isset($this->vpnGroupName) ? $this->vpnGroupName : null;
    }
    /**
     * Set vpnGroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $vpnGroupName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCommonPhoneConfigReq
     */
    public function setVpnGroupName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $vpnGroupName = null)
    {
        if (is_null($vpnGroupName) || (is_array($vpnGroupName) && empty($vpnGroupName))) {
            unset($this->vpnGroupName);
        } else {
            $this->vpnGroupName = $vpnGroupName;
        }
        return $this;
    }
    /**
     * Get vpnProfileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getVpnProfileName()
    {
        return isset($this->vpnProfileName) ? $this->vpnProfileName : null;
    }
    /**
     * Set vpnProfileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $vpnProfileName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCommonPhoneConfigReq
     */
    public function setVpnProfileName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $vpnProfileName = null)
    {
        if (is_null($vpnProfileName) || (is_array($vpnProfileName) && empty($vpnProfileName))) {
            unset($this->vpnProfileName);
        } else {
            $this->vpnProfileName = $vpnProfileName;
        }
        return $this;
    }
    /**
     * Get featureControlPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getFeatureControlPolicy()
    {
        return isset($this->featureControlPolicy) ? $this->featureControlPolicy : null;
    }
    /**
     * Set featureControlPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $featureControlPolicy
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCommonPhoneConfigReq
     */
    public function setFeatureControlPolicy(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $featureControlPolicy = null)
    {
        if (is_null($featureControlPolicy) || (is_array($featureControlPolicy) && empty($featureControlPolicy))) {
            unset($this->featureControlPolicy);
        } else {
            $this->featureControlPolicy = $featureControlPolicy;
        }
        return $this;
    }
    /**
     * Get wifiHotspotProfile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getWifiHotspotProfile()
    {
        return isset($this->wifiHotspotProfile) ? $this->wifiHotspotProfile : null;
    }
    /**
     * Set wifiHotspotProfile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $wifiHotspotProfile
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCommonPhoneConfigReq
     */
    public function setWifiHotspotProfile(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $wifiHotspotProfile = null)
    {
        if (is_null($wifiHotspotProfile) || (is_array($wifiHotspotProfile) && empty($wifiHotspotProfile))) {
            unset($this->wifiHotspotProfile);
        } else {
            $this->wifiHotspotProfile = $wifiHotspotProfile;
        }
        return $this;
    }
}
