<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCcdHostedDNReq StructType
 * @subpackage Structs
 */
class UpdateCcdHostedDNReq extends APIRequest
{
    /**
     * The hostedPattern
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | hostedPattern
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $hostedPattern;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | hostedPattern
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The newHostedPattern
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newHostedPattern;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The CcdHostedDnGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $CcdHostedDnGroup;
    /**
     * The pstnFailoverStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $pstnFailoverStripDigits;
    /**
     * The pstnFailoverPrependDigits
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $pstnFailoverPrependDigits;
    /**
     * The usePstnFailover
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $usePstnFailover;
    /**
     * Constructor method for UpdateCcdHostedDNReq
     * @uses UpdateCcdHostedDNReq::setHostedPattern()
     * @uses UpdateCcdHostedDNReq::setUuid()
     * @uses UpdateCcdHostedDNReq::setNewHostedPattern()
     * @uses UpdateCcdHostedDNReq::setDescription()
     * @uses UpdateCcdHostedDNReq::setCcdHostedDnGroup()
     * @uses UpdateCcdHostedDNReq::setPstnFailoverStripDigits()
     * @uses UpdateCcdHostedDNReq::setPstnFailoverPrependDigits()
     * @uses UpdateCcdHostedDNReq::setUsePstnFailover()
     * @param string $hostedPattern
     * @param string $uuid
     * @param string $newHostedPattern
     * @param string $description
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ccdHostedDnGroup
     * @param string $pstnFailoverStripDigits
     * @param string $pstnFailoverPrependDigits
     * @param string $usePstnFailover
     */
    public function __construct($hostedPattern = null, $uuid = null, $newHostedPattern = null, $description = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ccdHostedDnGroup = null, $pstnFailoverStripDigits = null, $pstnFailoverPrependDigits = null, $usePstnFailover = 'false')
    {
        $this
            ->setHostedPattern($hostedPattern)
            ->setUuid($uuid)
            ->setNewHostedPattern($newHostedPattern)
            ->setDescription($description)
            ->setCcdHostedDnGroup($ccdHostedDnGroup)
            ->setPstnFailoverStripDigits($pstnFailoverStripDigits)
            ->setPstnFailoverPrependDigits($pstnFailoverPrependDigits)
            ->setUsePstnFailover($usePstnFailover);
    }
    /**
     * Get hostedPattern value
     * @return string
     */
    public function getHostedPattern()
    {
        return isset($this->hostedPattern) ? $this->hostedPattern : null;
    }
    /**
     * Set hostedPattern value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $hostedPattern
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCcdHostedDNReq
     */
    public function setHostedPattern($hostedPattern = null)
    {
        if (is_null($hostedPattern) || (is_array($hostedPattern) && empty($hostedPattern))) {
            unset($this->hostedPattern);
        } else {
            $this->hostedPattern = $hostedPattern;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCcdHostedDNReq
     */
    public function setUuid($uuid = null)
    {
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get newHostedPattern value
     * @return string|null
     */
    public function getNewHostedPattern()
    {
        return $this->newHostedPattern;
    }
    /**
     * Set newHostedPattern value
     * @param string $newHostedPattern
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCcdHostedDNReq
     */
    public function setNewHostedPattern($newHostedPattern = null)
    {
        $this->newHostedPattern = $newHostedPattern;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCcdHostedDNReq
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get CcdHostedDnGroup value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCcdHostedDnGroup()
    {
        return $this->CcdHostedDnGroup;
    }
    /**
     * Set CcdHostedDnGroup value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ccdHostedDnGroup
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCcdHostedDNReq
     */
    public function setCcdHostedDnGroup(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ccdHostedDnGroup = null)
    {
        $this->CcdHostedDnGroup = $ccdHostedDnGroup;
        return $this;
    }
    /**
     * Get pstnFailoverStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPstnFailoverStripDigits()
    {
        return isset($this->pstnFailoverStripDigits) ? $this->pstnFailoverStripDigits : null;
    }
    /**
     * Set pstnFailoverStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pstnFailoverStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCcdHostedDNReq
     */
    public function setPstnFailoverStripDigits($pstnFailoverStripDigits = null)
    {
        if (is_null($pstnFailoverStripDigits) || (is_array($pstnFailoverStripDigits) && empty($pstnFailoverStripDigits))) {
            unset($this->pstnFailoverStripDigits);
        } else {
            $this->pstnFailoverStripDigits = $pstnFailoverStripDigits;
        }
        return $this;
    }
    /**
     * Get pstnFailoverPrependDigits value
     * @return string|null
     */
    public function getPstnFailoverPrependDigits()
    {
        return $this->pstnFailoverPrependDigits;
    }
    /**
     * Set pstnFailoverPrependDigits value
     * @param string $pstnFailoverPrependDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCcdHostedDNReq
     */
    public function setPstnFailoverPrependDigits($pstnFailoverPrependDigits = null)
    {
        $this->pstnFailoverPrependDigits = $pstnFailoverPrependDigits;
        return $this;
    }
    /**
     * Get usePstnFailover value
     * @return string|null
     */
    public function getUsePstnFailover()
    {
        return $this->usePstnFailover;
    }
    /**
     * Set usePstnFailover value
     * @param string $usePstnFailover
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCcdHostedDNReq
     */
    public function setUsePstnFailover($usePstnFailover = 'false')
    {
        $this->usePstnFailover = $usePstnFailover;
        return $this;
    }
}
