<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCallManagerReq StructType
 * @subpackage Structs
 */
class UpdateCallManagerReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The autoRegistration
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\AutoRegistration
     */
    public $autoRegistration;
    /**
     * The ports
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\Ports
     */
    public $ports;
    /**
     * The lbmGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $lbmGroup;
    /**
     * Constructor method for UpdateCallManagerReq
     * @uses UpdateCallManagerReq::setNewName()
     * @uses UpdateCallManagerReq::setDescription()
     * @uses UpdateCallManagerReq::setAutoRegistration()
     * @uses UpdateCallManagerReq::setPorts()
     * @uses UpdateCallManagerReq::setLbmGroup()
     * @param string $newName
     * @param string $description
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AutoRegistration $autoRegistration
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Ports $ports
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $lbmGroup
     */
    public function __construct($newName = null, $description = null, \\Losc\CucmBundle\Model\Webservice\StructType\AutoRegistration $autoRegistration = null, \\Losc\CucmBundle\Model\Webservice\StructType\Ports $ports = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $lbmGroup = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setAutoRegistration($autoRegistration)
            ->setPorts($ports)
            ->setLbmGroup($lbmGroup);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCallManagerReq
     */
    public function setNewName($newName = null)
    {
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCallManagerReq
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get autoRegistration value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\AutoRegistration|null
     */
    public function getAutoRegistration()
    {
        return $this->autoRegistration;
    }
    /**
     * Set autoRegistration value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AutoRegistration $autoRegistration
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCallManagerReq
     */
    public function setAutoRegistration(\\Losc\CucmBundle\Model\Webservice\StructType\AutoRegistration $autoRegistration = null)
    {
        $this->autoRegistration = $autoRegistration;
        return $this;
    }
    /**
     * Get ports value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\Ports|null
     */
    public function getPorts()
    {
        return $this->ports;
    }
    /**
     * Set ports value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Ports $ports
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCallManagerReq
     */
    public function setPorts(\\Losc\CucmBundle\Model\Webservice\StructType\Ports $ports = null)
    {
        $this->ports = $ports;
        return $this;
    }
    /**
     * Get lbmGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getLbmGroup()
    {
        return isset($this->lbmGroup) ? $this->lbmGroup : null;
    }
    /**
     * Set lbmGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $lbmGroup
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateCallManagerReq
     */
    public function setLbmGroup(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $lbmGroup = null)
    {
        if (is_null($lbmGroup) || (is_array($lbmGroup) && empty($lbmGroup))) {
            unset($this->lbmGroup);
        } else {
            $this->lbmGroup = $lbmGroup;
        }
        return $this;
    }
}
