<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateBillingServerReq StructType
 * @subpackage Structs
 */
class UpdateBillingServerReq extends APIRequest
{
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - nillable: false
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The userId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $userId;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $password;
    /**
     * The resendOnFailure
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: true
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $resendOnFailure;
    /**
     * The billingServerProtocol
     * Meta information extracted from the WSDL
     * - default: SFTP
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $billingServerProtocol;
    /**
     * Constructor method for UpdateBillingServerReq
     * @uses UpdateBillingServerReq::setUuid()
     * @uses UpdateBillingServerReq::setUserId()
     * @uses UpdateBillingServerReq::setPassword()
     * @uses UpdateBillingServerReq::setResendOnFailure()
     * @uses UpdateBillingServerReq::setBillingServerProtocol()
     * @param string $uuid
     * @param string $userId
     * @param string $password
     * @param string $resendOnFailure
     * @param string $billingServerProtocol
     */
    public function __construct($uuid = null, $userId = null, $password = null, $resendOnFailure = 'true', $billingServerProtocol = 'SFTP')
    {
        $this
            ->setUuid($uuid)
            ->setUserId($userId)
            ->setPassword($password)
            ->setResendOnFailure($resendOnFailure)
            ->setBillingServerProtocol($billingServerProtocol);
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateBillingServerReq
     */
    public function setUuid($uuid = null)
    {
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get userId value
     * @return string|null
     */
    public function getUserId()
    {
        return $this->userId;
    }
    /**
     * Set userId value
     * @param string $userId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateBillingServerReq
     */
    public function setUserId($userId = null)
    {
        $this->userId = $userId;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateBillingServerReq
     */
    public function setPassword($password = null)
    {
        $this->password = $password;
        return $this;
    }
    /**
     * Get resendOnFailure value
     * @return string|null
     */
    public function getResendOnFailure()
    {
        return $this->resendOnFailure;
    }
    /**
     * Set resendOnFailure value
     * @param string $resendOnFailure
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateBillingServerReq
     */
    public function setResendOnFailure($resendOnFailure = 'true')
    {
        $this->resendOnFailure = $resendOnFailure;
        return $this;
    }
    /**
     * Get billingServerProtocol value
     * @return string|null
     */
    public function getBillingServerProtocol()
    {
        return $this->billingServerProtocol;
    }
    /**
     * Set billingServerProtocol value
     * @param string $billingServerProtocol
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateBillingServerReq
     */
    public function setBillingServerProtocol($billingServerProtocol = 'SFTP')
    {
        $this->billingServerProtocol = $billingServerProtocol;
        return $this;
    }
}
