<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateAppUserReq StructType
 * @subpackage Structs
 */
class UpdateAppUserReq extends APIRequest
{
    /**
     * The userid
     * Meta information extracted from the WSDL
     * - choice: uuid | userid
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $userid;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: uuid | userid
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The newUserid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newUserid;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - documentation: Valid range is 1-127 characters.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The passwordCredentials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\PasswordCredentials
     */
    public $passwordCredentials;
    /**
     * The digestCredentials
     * Meta information extracted from the WSDL
     * - documentation: Valid range is 1-42 characters.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $digestCredentials;
    /**
     * The presenceGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $presenceGroupName;
    /**
     * The acceptPresenceSubscription
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $acceptPresenceSubscription;
    /**
     * The acceptOutOfDialogRefer
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $acceptOutOfDialogRefer;
    /**
     * The acceptUnsolicitedNotification
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $acceptUnsolicitedNotification;
    /**
     * The allowReplaceHeader
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowReplaceHeader;
    /**
     * The associatedDevices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedDevices
     */
    public $associatedDevices;
    /**
     * The associatedGroups
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedGroups
     */
    public $associatedGroups;
    /**
     * The ctiControlledDeviceProfiles
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\CtiControlledDeviceProfiles
     */
    public $ctiControlledDeviceProfiles;
    /**
     * Constructor method for UpdateAppUserReq
     * @uses UpdateAppUserReq::setUserid()
     * @uses UpdateAppUserReq::setUuid()
     * @uses UpdateAppUserReq::setNewUserid()
     * @uses UpdateAppUserReq::setPassword()
     * @uses UpdateAppUserReq::setPasswordCredentials()
     * @uses UpdateAppUserReq::setDigestCredentials()
     * @uses UpdateAppUserReq::setPresenceGroupName()
     * @uses UpdateAppUserReq::setAcceptPresenceSubscription()
     * @uses UpdateAppUserReq::setAcceptOutOfDialogRefer()
     * @uses UpdateAppUserReq::setAcceptUnsolicitedNotification()
     * @uses UpdateAppUserReq::setAllowReplaceHeader()
     * @uses UpdateAppUserReq::setAssociatedDevices()
     * @uses UpdateAppUserReq::setAssociatedGroups()
     * @uses UpdateAppUserReq::setCtiControlledDeviceProfiles()
     * @param string $userid
     * @param string $uuid
     * @param string $newUserid
     * @param string $password
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\PasswordCredentials $passwordCredentials
     * @param string $digestCredentials
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName
     * @param string $acceptPresenceSubscription
     * @param string $acceptOutOfDialogRefer
     * @param string $acceptUnsolicitedNotification
     * @param string $allowReplaceHeader
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedDevices $associatedDevices
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedGroups $associatedGroups
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\CtiControlledDeviceProfiles $ctiControlledDeviceProfiles
     */
    public function __construct($userid = null, $uuid = null, $newUserid = null, $password = null, \\Losc\CucmBundle\Model\Webservice\StructType\PasswordCredentials $passwordCredentials = null, $digestCredentials = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName = null, $acceptPresenceSubscription = 'false', $acceptOutOfDialogRefer = 'false', $acceptUnsolicitedNotification = 'false', $allowReplaceHeader = 'false', \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedDevices $associatedDevices = null, \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedGroups $associatedGroups = null, \\Losc\CucmBundle\Model\Webservice\StructType\CtiControlledDeviceProfiles $ctiControlledDeviceProfiles = null)
    {
        $this
            ->setUserid($userid)
            ->setUuid($uuid)
            ->setNewUserid($newUserid)
            ->setPassword($password)
            ->setPasswordCredentials($passwordCredentials)
            ->setDigestCredentials($digestCredentials)
            ->setPresenceGroupName($presenceGroupName)
            ->setAcceptPresenceSubscription($acceptPresenceSubscription)
            ->setAcceptOutOfDialogRefer($acceptOutOfDialogRefer)
            ->setAcceptUnsolicitedNotification($acceptUnsolicitedNotification)
            ->setAllowReplaceHeader($allowReplaceHeader)
            ->setAssociatedDevices($associatedDevices)
            ->setAssociatedGroups($associatedGroups)
            ->setCtiControlledDeviceProfiles($ctiControlledDeviceProfiles);
    }
    /**
     * Get userid value
     * @return string
     */
    public function getUserid()
    {
        return isset($this->userid) ? $this->userid : null;
    }
    /**
     * Set userid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $userid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateAppUserReq
     */
    public function setUserid($userid = null)
    {
        if (is_null($userid) || (is_array($userid) && empty($userid))) {
            unset($this->userid);
        } else {
            $this->userid = $userid;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateAppUserReq
     */
    public function setUuid($uuid = null)
    {
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
    /**
     * Get newUserid value
     * @return string|null
     */
    public function getNewUserid()
    {
        return $this->newUserid;
    }
    /**
     * Set newUserid value
     * @param string $newUserid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateAppUserReq
     */
    public function setNewUserid($newUserid = null)
    {
        $this->newUserid = $newUserid;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateAppUserReq
     */
    public function setPassword($password = null)
    {
        $this->password = $password;
        return $this;
    }
    /**
     * Get passwordCredentials value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\PasswordCredentials|null
     */
    public function getPasswordCredentials()
    {
        return $this->passwordCredentials;
    }
    /**
     * Set passwordCredentials value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\PasswordCredentials $passwordCredentials
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateAppUserReq
     */
    public function setPasswordCredentials(\\Losc\CucmBundle\Model\Webservice\StructType\PasswordCredentials $passwordCredentials = null)
    {
        $this->passwordCredentials = $passwordCredentials;
        return $this;
    }
    /**
     * Get digestCredentials value
     * @return string|null
     */
    public function getDigestCredentials()
    {
        return $this->digestCredentials;
    }
    /**
     * Set digestCredentials value
     * @param string $digestCredentials
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateAppUserReq
     */
    public function setDigestCredentials($digestCredentials = null)
    {
        $this->digestCredentials = $digestCredentials;
        return $this;
    }
    /**
     * Get presenceGroupName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getPresenceGroupName()
    {
        return $this->presenceGroupName;
    }
    /**
     * Set presenceGroupName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateAppUserReq
     */
    public function setPresenceGroupName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName = null)
    {
        $this->presenceGroupName = $presenceGroupName;
        return $this;
    }
    /**
     * Get acceptPresenceSubscription value
     * @return string|null
     */
    public function getAcceptPresenceSubscription()
    {
        return $this->acceptPresenceSubscription;
    }
    /**
     * Set acceptPresenceSubscription value
     * @param string $acceptPresenceSubscription
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateAppUserReq
     */
    public function setAcceptPresenceSubscription($acceptPresenceSubscription = 'false')
    {
        $this->acceptPresenceSubscription = $acceptPresenceSubscription;
        return $this;
    }
    /**
     * Get acceptOutOfDialogRefer value
     * @return string|null
     */
    public function getAcceptOutOfDialogRefer()
    {
        return $this->acceptOutOfDialogRefer;
    }
    /**
     * Set acceptOutOfDialogRefer value
     * @param string $acceptOutOfDialogRefer
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateAppUserReq
     */
    public function setAcceptOutOfDialogRefer($acceptOutOfDialogRefer = 'false')
    {
        $this->acceptOutOfDialogRefer = $acceptOutOfDialogRefer;
        return $this;
    }
    /**
     * Get acceptUnsolicitedNotification value
     * @return string|null
     */
    public function getAcceptUnsolicitedNotification()
    {
        return $this->acceptUnsolicitedNotification;
    }
    /**
     * Set acceptUnsolicitedNotification value
     * @param string $acceptUnsolicitedNotification
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateAppUserReq
     */
    public function setAcceptUnsolicitedNotification($acceptUnsolicitedNotification = 'false')
    {
        $this->acceptUnsolicitedNotification = $acceptUnsolicitedNotification;
        return $this;
    }
    /**
     * Get allowReplaceHeader value
     * @return string|null
     */
    public function getAllowReplaceHeader()
    {
        return $this->allowReplaceHeader;
    }
    /**
     * Set allowReplaceHeader value
     * @param string $allowReplaceHeader
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateAppUserReq
     */
    public function setAllowReplaceHeader($allowReplaceHeader = 'false')
    {
        $this->allowReplaceHeader = $allowReplaceHeader;
        return $this;
    }
    /**
     * Get associatedDevices value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedDevices|null
     */
    public function getAssociatedDevices()
    {
        return $this->associatedDevices;
    }
    /**
     * Set associatedDevices value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedDevices $associatedDevices
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateAppUserReq
     */
    public function setAssociatedDevices(\\Losc\CucmBundle\Model\Webservice\StructType\AssociatedDevices $associatedDevices = null)
    {
        $this->associatedDevices = $associatedDevices;
        return $this;
    }
    /**
     * Get associatedGroups value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedGroups|null
     */
    public function getAssociatedGroups()
    {
        return $this->associatedGroups;
    }
    /**
     * Set associatedGroups value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedGroups $associatedGroups
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateAppUserReq
     */
    public function setAssociatedGroups(\\Losc\CucmBundle\Model\Webservice\StructType\AssociatedGroups $associatedGroups = null)
    {
        $this->associatedGroups = $associatedGroups;
        return $this;
    }
    /**
     * Get ctiControlledDeviceProfiles value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\CtiControlledDeviceProfiles|null
     */
    public function getCtiControlledDeviceProfiles()
    {
        return $this->ctiControlledDeviceProfiles;
    }
    /**
     * Set ctiControlledDeviceProfiles value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\CtiControlledDeviceProfiles $ctiControlledDeviceProfiles
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateAppUserReq
     */
    public function setCtiControlledDeviceProfiles(\\Losc\CucmBundle\Model\Webservice\StructType\CtiControlledDeviceProfiles $ctiControlledDeviceProfiles = null)
    {
        $this->ctiControlledDeviceProfiles = $ctiControlledDeviceProfiles;
        return $this;
    }
}
