<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateAnnouncementReq StructType
 * @subpackage Structs
 */
class UpdateAnnouncementReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $description;
    /**
     * The announcementFile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $announcementFile;
    /**
     * Constructor method for UpdateAnnouncementReq
     * @uses UpdateAnnouncementReq::setNewName()
     * @uses UpdateAnnouncementReq::setDescription()
     * @uses UpdateAnnouncementReq::setAnnouncementFile()
     * @param string $newName
     * @param string $description
     * @param string $announcementFile
     */
    public function __construct($newName = null, $description = null, $announcementFile = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setAnnouncementFile($announcementFile);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateAnnouncementReq
     */
    public function setNewName($newName = null)
    {
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : null;
    }
    /**
     * Set description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateAnnouncementReq
     */
    public function setDescription($description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->description);
        } else {
            $this->description = $description;
        }
        return $this;
    }
    /**
     * Get announcementFile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAnnouncementFile()
    {
        return isset($this->announcementFile) ? $this->announcementFile : null;
    }
    /**
     * Set announcementFile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $announcementFile
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\UpdateAnnouncementReq
     */
    public function setAnnouncementFile($announcementFile = null)
    {
        if (is_null($announcementFile) || (is_array($announcementFile) && empty($announcementFile))) {
            unset($this->announcementFile);
        } else {
            $this->announcementFile = $announcementFile;
        }
        return $this;
    }
}
