<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for server StructType
 * @subpackage Structs
 */
class Server extends AbstractStructBase
{
    /**
     * The hostName
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $hostName;
    /**
     * The ldapPortNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ldapPortNumber;
    /**
     * The sslEnabled
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $sslEnabled;
    /**
     * The ldapPort
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ldapPort;
    /**
     * Constructor method for server
     * @uses Server::setHostName()
     * @uses Server::setLdapPortNumber()
     * @uses Server::setSslEnabled()
     * @uses Server::setLdapPort()
     * @param string $hostName
     * @param string $ldapPortNumber
     * @param string $sslEnabled
     * @param string $ldapPort
     */
    public function __construct($hostName = null, $ldapPortNumber = null, $sslEnabled = null, $ldapPort = null)
    {
        $this
            ->setHostName($hostName)
            ->setLdapPortNumber($ldapPortNumber)
            ->setSslEnabled($sslEnabled)
            ->setLdapPort($ldapPort);
    }
    /**
     * Get hostName value
     * @return string|null
     */
    public function getHostName()
    {
        return $this->hostName;
    }
    /**
     * Set hostName value
     * @param string $hostName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\Server
     */
    public function setHostName($hostName = null)
    {
        $this->hostName = $hostName;
        return $this;
    }
    /**
     * Get ldapPortNumber value
     * @return string|null
     */
    public function getLdapPortNumber()
    {
        return $this->ldapPortNumber;
    }
    /**
     * Set ldapPortNumber value
     * @param string $ldapPortNumber
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\Server
     */
    public function setLdapPortNumber($ldapPortNumber = null)
    {
        $this->ldapPortNumber = $ldapPortNumber;
        return $this;
    }
    /**
     * Get sslEnabled value
     * @return string|null
     */
    public function getSslEnabled()
    {
        return $this->sslEnabled;
    }
    /**
     * Set sslEnabled value
     * @param string $sslEnabled
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\Server
     */
    public function setSslEnabled($sslEnabled = null)
    {
        $this->sslEnabled = $sslEnabled;
        return $this;
    }
    /**
     * Get ldapPort value
     * @return string|null
     */
    public function getLdapPort()
    {
        return $this->ldapPort;
    }
    /**
     * Set ldapPort value
     * @param string $ldapPort
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\Server
     */
    public function setLdapPort($ldapPort = null)
    {
        $this->ldapPort = $ldapPort;
        return $this;
    }
}
