<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RVg224 StructType
 * @subpackage Structs
 */
class RVg224 extends AbstractStructBase
{
    /**
     * The domainName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $domainName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The product
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $product;
    /**
     * The protocol
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $protocol;
    /**
     * The callManagerGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callManagerGroupName;
    /**
     * The units
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\Units
     */
    public $units;
    /**
     * The vendorConfig
     * Meta information extracted from the WSDL
     * - documentation: It contains Product Specific Configuration Information like Fax mode, Modem Passthorugh, etc.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig
     */
    public $vendorConfig;
    /**
     * The versionStamp
     * Meta information extracted from the WSDL
     * - documentation: Read only. UUID that is changed each time the VG224 is updated.
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $versionStamp;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RVg224
     * @uses RVg224::setDomainName()
     * @uses RVg224::setDescription()
     * @uses RVg224::setProduct()
     * @uses RVg224::setProtocol()
     * @uses RVg224::setCallManagerGroupName()
     * @uses RVg224::setUnits()
     * @uses RVg224::setVendorConfig()
     * @uses RVg224::setVersionStamp()
     * @uses RVg224::setUuid()
     * @param string $domainName
     * @param string $description
     * @param string $product
     * @param string $protocol
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callManagerGroupName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Units $units
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig
     * @param string $versionStamp
     * @param string $uuid
     */
    public function __construct($domainName = null, $description = null, $product = null, $protocol = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callManagerGroupName = null, \\Losc\CucmBundle\Model\Webservice\StructType\Units $units = null, \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig = null, $versionStamp = null, $uuid = null)
    {
        $this
            ->setDomainName($domainName)
            ->setDescription($description)
            ->setProduct($product)
            ->setProtocol($protocol)
            ->setCallManagerGroupName($callManagerGroupName)
            ->setUnits($units)
            ->setVendorConfig($vendorConfig)
            ->setVersionStamp($versionStamp)
            ->setUuid($uuid);
    }
    /**
     * Get domainName value
     * @return string|null
     */
    public function getDomainName()
    {
        return $this->domainName;
    }
    /**
     * Set domainName value
     * @param string $domainName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RVg224
     */
    public function setDomainName($domainName = null)
    {
        $this->domainName = $domainName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RVg224
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get product value
     * @return string|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param string $product
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RVg224
     */
    public function setProduct($product = null)
    {
        $this->product = $product;
        return $this;
    }
    /**
     * Get protocol value
     * @return string|null
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @param string $protocol
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RVg224
     */
    public function setProtocol($protocol = null)
    {
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get callManagerGroupName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallManagerGroupName()
    {
        return $this->callManagerGroupName;
    }
    /**
     * Set callManagerGroupName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callManagerGroupName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RVg224
     */
    public function setCallManagerGroupName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callManagerGroupName = null)
    {
        $this->callManagerGroupName = $callManagerGroupName;
        return $this;
    }
    /**
     * Get units value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\Units|null
     */
    public function getUnits()
    {
        return $this->units;
    }
    /**
     * Set units value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Units $units
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RVg224
     */
    public function setUnits(\\Losc\CucmBundle\Model\Webservice\StructType\Units $units = null)
    {
        $this->units = $units;
        return $this;
    }
    /**
     * Get vendorConfig value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig|null
     */
    public function getVendorConfig()
    {
        return $this->vendorConfig;
    }
    /**
     * Set vendorConfig value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RVg224
     */
    public function setVendorConfig(\\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig = null)
    {
        $this->vendorConfig = $vendorConfig;
        return $this;
    }
    /**
     * Get versionStamp value
     * @return string|null
     */
    public function getVersionStamp()
    {
        return $this->versionStamp;
    }
    /**
     * Set versionStamp value
     * @param string $versionStamp
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RVg224
     */
    public function setVersionStamp($versionStamp = null)
    {
        $this->versionStamp = $versionStamp;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RVg224
     */
    public function setUuid($uuid = null)
    {
        $this->uuid = $uuid;
        return $this;
    }
}
