<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RH323Phone StructType
 * @subpackage Structs
 */
class RH323Phone extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: The device name,using only URL-friendly characters
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - documentation: Optional description of the device
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The product
     * Meta information extracted from the WSDL
     * - documentation: Product ID string. read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $product;
    /**
     * The model
     * Meta information extracted from the WSDL
     * - documentation: Model ID string. Read Only
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $model;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - documentation: Class ID string. Class information is read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $class;
    /**
     * The protocol
     * Meta information extracted from the WSDL
     * - documentation: Protocol option is read-only,except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $protocol;
    /**
     * The protocolSide
     * Meta information extracted from the WSDL
     * - documentation: Side information is read-only except when creating a device
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $protocolSide;
    /**
     * The callingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The devicePoolName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $devicePoolName;
    /**
     * The commonDeviceConfigName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $commonDeviceConfigName;
    /**
     * The commonPhoneConfigName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $commonPhoneConfigName;
    /**
     * The locationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $locationName;
    /**
     * The mediaResourceListName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $mediaResourceListName;
    /**
     * The automatedAlternateRoutingCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $automatedAlternateRoutingCssName;
    /**
     * The aarNeighborhoodName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $aarNeighborhoodName;
    /**
     * The traceFlag
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $traceFlag;
    /**
     * The mlppDomainId
     * Meta information extracted from the WSDL
     * - documentation: Use -1 to set to null
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mlppDomainId;
    /**
     * The useTrustedRelayPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The retryVideoCallAsAudio
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $retryVideoCallAsAudio;
    /**
     * The remoteDevice
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $remoteDevice;
    /**
     * The cgpnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $cgpnTransformationCssName;
    /**
     * The useDevicePoolCgpnTransformCss
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCss;
    /**
     * The geoLocationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $geoLocationName;
    /**
     * The alwaysUsePrimeLine
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $alwaysUsePrimeLine;
    /**
     * The alwaysUsePrimeLineForVoiceMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $alwaysUsePrimeLineForVoiceMessage;
    /**
     * The srtpAllowed
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $srtpAllowed;
    /**
     * The unattendedPort
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for H323Phones and H323Trunks.Not for Gateways.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $unattendedPort;
    /**
     * The subscribeCallingSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $subscribeCallingSearchSpaceName;
    /**
     * The waitForFarEndH245TerminalSet
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $waitForFarEndH245TerminalSet;
    /**
     * The mtpRequired
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $mtpRequired;
    /**
     * The mtpPreferredCodec
     * Meta information extracted from the WSDL
     * - documentation: Applicable only for H323Phones
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mtpPreferredCodec;
    /**
     * The callerIdDn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callerIdDn;
    /**
     * The callingPartySelection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartySelection;
    /**
     * The callingLineIdPresentation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingLineIdPresentation;
    /**
     * The displayIEDelivery
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $displayIEDelivery;
    /**
     * The redirectOutboundNumberIe
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $redirectOutboundNumberIe;
    /**
     * The redirectInboundNumberIe
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $redirectInboundNumberIe;
    /**
     * The presenceGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $presenceGroupName;
    /**
     * The hlogStatus
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $hlogStatus;
    /**
     * The ownerUserName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $ownerUserName;
    /**
     * The signalingPort
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $signalingPort;
    /**
     * The gateKeeperInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\GateKeeperInfo
     */
    public $gateKeeperInfo;
    /**
     * The lines
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\Lines
     */
    public $lines;
    /**
     * The ignorePresentationIndicators
     * Meta information extracted from the WSDL
     * - documentation: The new Ignore Presentation Indicators flag for Hospitality feature is required for most phones andand device profiles. Not Nullable.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $ignorePresentationIndicators;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RH323Phone
     * @uses RH323Phone::setName()
     * @uses RH323Phone::setDescription()
     * @uses RH323Phone::setProduct()
     * @uses RH323Phone::setModel()
     * @uses RH323Phone::setClass()
     * @uses RH323Phone::setProtocol()
     * @uses RH323Phone::setProtocolSide()
     * @uses RH323Phone::setCallingSearchSpaceName()
     * @uses RH323Phone::setDevicePoolName()
     * @uses RH323Phone::setCommonDeviceConfigName()
     * @uses RH323Phone::setCommonPhoneConfigName()
     * @uses RH323Phone::setLocationName()
     * @uses RH323Phone::setMediaResourceListName()
     * @uses RH323Phone::setAutomatedAlternateRoutingCssName()
     * @uses RH323Phone::setAarNeighborhoodName()
     * @uses RH323Phone::setTraceFlag()
     * @uses RH323Phone::setMlppDomainId()
     * @uses RH323Phone::setUseTrustedRelayPoint()
     * @uses RH323Phone::setRetryVideoCallAsAudio()
     * @uses RH323Phone::setRemoteDevice()
     * @uses RH323Phone::setCgpnTransformationCssName()
     * @uses RH323Phone::setUseDevicePoolCgpnTransformCss()
     * @uses RH323Phone::setGeoLocationName()
     * @uses RH323Phone::setAlwaysUsePrimeLine()
     * @uses RH323Phone::setAlwaysUsePrimeLineForVoiceMessage()
     * @uses RH323Phone::setSrtpAllowed()
     * @uses RH323Phone::setUnattendedPort()
     * @uses RH323Phone::setSubscribeCallingSearchSpaceName()
     * @uses RH323Phone::setWaitForFarEndH245TerminalSet()
     * @uses RH323Phone::setMtpRequired()
     * @uses RH323Phone::setMtpPreferredCodec()
     * @uses RH323Phone::setCallerIdDn()
     * @uses RH323Phone::setCallingPartySelection()
     * @uses RH323Phone::setCallingLineIdPresentation()
     * @uses RH323Phone::setDisplayIEDelivery()
     * @uses RH323Phone::setRedirectOutboundNumberIe()
     * @uses RH323Phone::setRedirectInboundNumberIe()
     * @uses RH323Phone::setPresenceGroupName()
     * @uses RH323Phone::setHlogStatus()
     * @uses RH323Phone::setOwnerUserName()
     * @uses RH323Phone::setSignalingPort()
     * @uses RH323Phone::setGateKeeperInfo()
     * @uses RH323Phone::setLines()
     * @uses RH323Phone::setIgnorePresentationIndicators()
     * @uses RH323Phone::setCtiid()
     * @uses RH323Phone::setUuid()
     * @param string $name
     * @param string $description
     * @param string $product
     * @param string $model
     * @param string $class
     * @param string $protocol
     * @param string $protocolSide
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonPhoneConfigName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName
     * @param string $traceFlag
     * @param string $mlppDomainId
     * @param string $useTrustedRelayPoint
     * @param string $retryVideoCallAsAudio
     * @param string $remoteDevice
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName
     * @param string $useDevicePoolCgpnTransformCss
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName
     * @param string $alwaysUsePrimeLine
     * @param string $alwaysUsePrimeLineForVoiceMessage
     * @param string $srtpAllowed
     * @param string $unattendedPort
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscribeCallingSearchSpaceName
     * @param string $waitForFarEndH245TerminalSet
     * @param string $mtpRequired
     * @param string $mtpPreferredCodec
     * @param string $callerIdDn
     * @param string $callingPartySelection
     * @param string $callingLineIdPresentation
     * @param string $displayIEDelivery
     * @param string $redirectOutboundNumberIe
     * @param string $redirectInboundNumberIe
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName
     * @param string $hlogStatus
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ownerUserName
     * @param string $signalingPort
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GateKeeperInfo $gateKeeperInfo
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Lines $lines
     * @param string $ignorePresentationIndicators
     * @param int $ctiid
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $product = null, $model = null, $class = null, $protocol = null, $protocolSide = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonPhoneConfigName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName = null, $traceFlag = null, $mlppDomainId = null, $useTrustedRelayPoint = null, $retryVideoCallAsAudio = null, $remoteDevice = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName = null, $useDevicePoolCgpnTransformCss = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName = null, $alwaysUsePrimeLine = null, $alwaysUsePrimeLineForVoiceMessage = null, $srtpAllowed = null, $unattendedPort = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscribeCallingSearchSpaceName = null, $waitForFarEndH245TerminalSet = null, $mtpRequired = null, $mtpPreferredCodec = null, $callerIdDn = null, $callingPartySelection = null, $callingLineIdPresentation = null, $displayIEDelivery = null, $redirectOutboundNumberIe = null, $redirectInboundNumberIe = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName = null, $hlogStatus = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ownerUserName = null, $signalingPort = null, \\Losc\CucmBundle\Model\Webservice\StructType\GateKeeperInfo $gateKeeperInfo = null, \\Losc\CucmBundle\Model\Webservice\StructType\Lines $lines = null, $ignorePresentationIndicators = null, $ctiid = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setProduct($product)
            ->setModel($model)
            ->setClass($class)
            ->setProtocol($protocol)
            ->setProtocolSide($protocolSide)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setDevicePoolName($devicePoolName)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setCommonPhoneConfigName($commonPhoneConfigName)
            ->setLocationName($locationName)
            ->setMediaResourceListName($mediaResourceListName)
            ->setAutomatedAlternateRoutingCssName($automatedAlternateRoutingCssName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setTraceFlag($traceFlag)
            ->setMlppDomainId($mlppDomainId)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setRetryVideoCallAsAudio($retryVideoCallAsAudio)
            ->setRemoteDevice($remoteDevice)
            ->setCgpnTransformationCssName($cgpnTransformationCssName)
            ->setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss)
            ->setGeoLocationName($geoLocationName)
            ->setAlwaysUsePrimeLine($alwaysUsePrimeLine)
            ->setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage)
            ->setSrtpAllowed($srtpAllowed)
            ->setUnattendedPort($unattendedPort)
            ->setSubscribeCallingSearchSpaceName($subscribeCallingSearchSpaceName)
            ->setWaitForFarEndH245TerminalSet($waitForFarEndH245TerminalSet)
            ->setMtpRequired($mtpRequired)
            ->setMtpPreferredCodec($mtpPreferredCodec)
            ->setCallerIdDn($callerIdDn)
            ->setCallingPartySelection($callingPartySelection)
            ->setCallingLineIdPresentation($callingLineIdPresentation)
            ->setDisplayIEDelivery($displayIEDelivery)
            ->setRedirectOutboundNumberIe($redirectOutboundNumberIe)
            ->setRedirectInboundNumberIe($redirectInboundNumberIe)
            ->setPresenceGroupName($presenceGroupName)
            ->setHlogStatus($hlogStatus)
            ->setOwnerUserName($ownerUserName)
            ->setSignalingPort($signalingPort)
            ->setGateKeeperInfo($gateKeeperInfo)
            ->setLines($lines)
            ->setIgnorePresentationIndicators($ignorePresentationIndicators)
            ->setCtiid($ctiid)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Phone
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Phone
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get product value
     * @return string|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param string $product
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Phone
     */
    public function setProduct($product = null)
    {
        $this->product = $product;
        return $this;
    }
    /**
     * Get model value
     * @return string|null
     */
    public function getModel()
    {
        return $this->model;
    }
    /**
     * Set model value
     * @param string $model
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Phone
     */
    public function setModel($model = null)
    {
        $this->model = $model;
        return $this;
    }
    /**
     * Get class value
     * @return string|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param string $class
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Phone
     */
    public function setClass($class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get protocol value
     * @return string|null
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @param string $protocol
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Phone
     */
    public function setProtocol($protocol = null)
    {
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get protocolSide value
     * @return string|null
     */
    public function getProtocolSide()
    {
        return $this->protocolSide;
    }
    /**
     * Set protocolSide value
     * @param string $protocolSide
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Phone
     */
    public function setProtocolSide($protocolSide = null)
    {
        $this->protocolSide = $protocolSide;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return $this->callingSearchSpaceName;
    }
    /**
     * Set callingSearchSpaceName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Phone
     */
    public function setCallingSearchSpaceName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingSearchSpaceName = null)
    {
        $this->callingSearchSpaceName = $callingSearchSpaceName;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Phone
     */
    public function setDevicePoolName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return $this->commonDeviceConfigName;
    }
    /**
     * Set commonDeviceConfigName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Phone
     */
    public function setCommonDeviceConfigName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonDeviceConfigName = null)
    {
        $this->commonDeviceConfigName = $commonDeviceConfigName;
        return $this;
    }
    /**
     * Get commonPhoneConfigName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCommonPhoneConfigName()
    {
        return $this->commonPhoneConfigName;
    }
    /**
     * Set commonPhoneConfigName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonPhoneConfigName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Phone
     */
    public function setCommonPhoneConfigName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $commonPhoneConfigName = null)
    {
        $this->commonPhoneConfigName = $commonPhoneConfigName;
        return $this;
    }
    /**
     * Get locationName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Phone
     */
    public function setLocationName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get mediaResourceListName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getMediaResourceListName()
    {
        return $this->mediaResourceListName;
    }
    /**
     * Set mediaResourceListName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Phone
     */
    public function setMediaResourceListName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName = null)
    {
        $this->mediaResourceListName = $mediaResourceListName;
        return $this;
    }
    /**
     * Get automatedAlternateRoutingCssName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getAutomatedAlternateRoutingCssName()
    {
        return $this->automatedAlternateRoutingCssName;
    }
    /**
     * Set automatedAlternateRoutingCssName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Phone
     */
    public function setAutomatedAlternateRoutingCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName = null)
    {
        $this->automatedAlternateRoutingCssName = $automatedAlternateRoutingCssName;
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return $this->aarNeighborhoodName;
    }
    /**
     * Set aarNeighborhoodName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Phone
     */
    public function setAarNeighborhoodName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName = null)
    {
        $this->aarNeighborhoodName = $aarNeighborhoodName;
        return $this;
    }
    /**
     * Get traceFlag value
     * @return string|null
     */
    public function getTraceFlag()
    {
        return $this->traceFlag;
    }
    /**
     * Set traceFlag value
     * @param string $traceFlag
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Phone
     */
    public function setTraceFlag($traceFlag = null)
    {
        $this->traceFlag = $traceFlag;
        return $this;
    }
    /**
     * Get mlppDomainId value
     * @return string|null
     */
    public function getMlppDomainId()
    {
        return $this->mlppDomainId;
    }
    /**
     * Set mlppDomainId value
     * @param string $mlppDomainId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Phone
     */
    public function setMlppDomainId($mlppDomainId = null)
    {
        $this->mlppDomainId = $mlppDomainId;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @param string $useTrustedRelayPoint
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Phone
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = null)
    {
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get retryVideoCallAsAudio value
     * @return string|null
     */
    public function getRetryVideoCallAsAudio()
    {
        return $this->retryVideoCallAsAudio;
    }
    /**
     * Set retryVideoCallAsAudio value
     * @param string $retryVideoCallAsAudio
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Phone
     */
    public function setRetryVideoCallAsAudio($retryVideoCallAsAudio = null)
    {
        $this->retryVideoCallAsAudio = $retryVideoCallAsAudio;
        return $this;
    }
    /**
     * Get remoteDevice value
     * @return string|null
     */
    public function getRemoteDevice()
    {
        return $this->remoteDevice;
    }
    /**
     * Set remoteDevice value
     * @param string $remoteDevice
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Phone
     */
    public function setRemoteDevice($remoteDevice = null)
    {
        $this->remoteDevice = $remoteDevice;
        return $this;
    }
    /**
     * Get cgpnTransformationCssName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCgpnTransformationCssName()
    {
        return $this->cgpnTransformationCssName;
    }
    /**
     * Set cgpnTransformationCssName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Phone
     */
    public function setCgpnTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName = null)
    {
        $this->cgpnTransformationCssName = $cgpnTransformationCssName;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCss()
    {
        return $this->useDevicePoolCgpnTransformCss;
    }
    /**
     * Set useDevicePoolCgpnTransformCss value
     * @param string $useDevicePoolCgpnTransformCss
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Phone
     */
    public function setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss = null)
    {
        $this->useDevicePoolCgpnTransformCss = $useDevicePoolCgpnTransformCss;
        return $this;
    }
    /**
     * Get geoLocationName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getGeoLocationName()
    {
        return $this->geoLocationName;
    }
    /**
     * Set geoLocationName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Phone
     */
    public function setGeoLocationName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName = null)
    {
        $this->geoLocationName = $geoLocationName;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLine value
     * @return string|null
     */
    public function getAlwaysUsePrimeLine()
    {
        return $this->alwaysUsePrimeLine;
    }
    /**
     * Set alwaysUsePrimeLine value
     * @param string $alwaysUsePrimeLine
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Phone
     */
    public function setAlwaysUsePrimeLine($alwaysUsePrimeLine = null)
    {
        $this->alwaysUsePrimeLine = $alwaysUsePrimeLine;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLineForVoiceMessage value
     * @return string|null
     */
    public function getAlwaysUsePrimeLineForVoiceMessage()
    {
        return $this->alwaysUsePrimeLineForVoiceMessage;
    }
    /**
     * Set alwaysUsePrimeLineForVoiceMessage value
     * @param string $alwaysUsePrimeLineForVoiceMessage
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Phone
     */
    public function setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage = null)
    {
        $this->alwaysUsePrimeLineForVoiceMessage = $alwaysUsePrimeLineForVoiceMessage;
        return $this;
    }
    /**
     * Get srtpAllowed value
     * @return string|null
     */
    public function getSrtpAllowed()
    {
        return $this->srtpAllowed;
    }
    /**
     * Set srtpAllowed value
     * @param string $srtpAllowed
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Phone
     */
    public function setSrtpAllowed($srtpAllowed = null)
    {
        $this->srtpAllowed = $srtpAllowed;
        return $this;
    }
    /**
     * Get unattendedPort value
     * @return string|null
     */
    public function getUnattendedPort()
    {
        return $this->unattendedPort;
    }
    /**
     * Set unattendedPort value
     * @param string $unattendedPort
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Phone
     */
    public function setUnattendedPort($unattendedPort = null)
    {
        $this->unattendedPort = $unattendedPort;
        return $this;
    }
    /**
     * Get subscribeCallingSearchSpaceName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSubscribeCallingSearchSpaceName()
    {
        return $this->subscribeCallingSearchSpaceName;
    }
    /**
     * Set subscribeCallingSearchSpaceName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscribeCallingSearchSpaceName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Phone
     */
    public function setSubscribeCallingSearchSpaceName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $subscribeCallingSearchSpaceName = null)
    {
        $this->subscribeCallingSearchSpaceName = $subscribeCallingSearchSpaceName;
        return $this;
    }
    /**
     * Get waitForFarEndH245TerminalSet value
     * @return string|null
     */
    public function getWaitForFarEndH245TerminalSet()
    {
        return $this->waitForFarEndH245TerminalSet;
    }
    /**
     * Set waitForFarEndH245TerminalSet value
     * @param string $waitForFarEndH245TerminalSet
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Phone
     */
    public function setWaitForFarEndH245TerminalSet($waitForFarEndH245TerminalSet = null)
    {
        $this->waitForFarEndH245TerminalSet = $waitForFarEndH245TerminalSet;
        return $this;
    }
    /**
     * Get mtpRequired value
     * @return string|null
     */
    public function getMtpRequired()
    {
        return $this->mtpRequired;
    }
    /**
     * Set mtpRequired value
     * @param string $mtpRequired
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Phone
     */
    public function setMtpRequired($mtpRequired = null)
    {
        $this->mtpRequired = $mtpRequired;
        return $this;
    }
    /**
     * Get mtpPreferredCodec value
     * @return string|null
     */
    public function getMtpPreferredCodec()
    {
        return $this->mtpPreferredCodec;
    }
    /**
     * Set mtpPreferredCodec value
     * @param string $mtpPreferredCodec
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Phone
     */
    public function setMtpPreferredCodec($mtpPreferredCodec = null)
    {
        $this->mtpPreferredCodec = $mtpPreferredCodec;
        return $this;
    }
    /**
     * Get callerIdDn value
     * @return string|null
     */
    public function getCallerIdDn()
    {
        return $this->callerIdDn;
    }
    /**
     * Set callerIdDn value
     * @param string $callerIdDn
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Phone
     */
    public function setCallerIdDn($callerIdDn = null)
    {
        $this->callerIdDn = $callerIdDn;
        return $this;
    }
    /**
     * Get callingPartySelection value
     * @return string|null
     */
    public function getCallingPartySelection()
    {
        return $this->callingPartySelection;
    }
    /**
     * Set callingPartySelection value
     * @param string $callingPartySelection
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Phone
     */
    public function setCallingPartySelection($callingPartySelection = null)
    {
        $this->callingPartySelection = $callingPartySelection;
        return $this;
    }
    /**
     * Get callingLineIdPresentation value
     * @return string|null
     */
    public function getCallingLineIdPresentation()
    {
        return $this->callingLineIdPresentation;
    }
    /**
     * Set callingLineIdPresentation value
     * @param string $callingLineIdPresentation
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Phone
     */
    public function setCallingLineIdPresentation($callingLineIdPresentation = null)
    {
        $this->callingLineIdPresentation = $callingLineIdPresentation;
        return $this;
    }
    /**
     * Get displayIEDelivery value
     * @return string|null
     */
    public function getDisplayIEDelivery()
    {
        return $this->displayIEDelivery;
    }
    /**
     * Set displayIEDelivery value
     * @param string $displayIEDelivery
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Phone
     */
    public function setDisplayIEDelivery($displayIEDelivery = null)
    {
        $this->displayIEDelivery = $displayIEDelivery;
        return $this;
    }
    /**
     * Get redirectOutboundNumberIe value
     * @return string|null
     */
    public function getRedirectOutboundNumberIe()
    {
        return $this->redirectOutboundNumberIe;
    }
    /**
     * Set redirectOutboundNumberIe value
     * @param string $redirectOutboundNumberIe
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Phone
     */
    public function setRedirectOutboundNumberIe($redirectOutboundNumberIe = null)
    {
        $this->redirectOutboundNumberIe = $redirectOutboundNumberIe;
        return $this;
    }
    /**
     * Get redirectInboundNumberIe value
     * @return string|null
     */
    public function getRedirectInboundNumberIe()
    {
        return $this->redirectInboundNumberIe;
    }
    /**
     * Set redirectInboundNumberIe value
     * @param string $redirectInboundNumberIe
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Phone
     */
    public function setRedirectInboundNumberIe($redirectInboundNumberIe = null)
    {
        $this->redirectInboundNumberIe = $redirectInboundNumberIe;
        return $this;
    }
    /**
     * Get presenceGroupName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getPresenceGroupName()
    {
        return $this->presenceGroupName;
    }
    /**
     * Set presenceGroupName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Phone
     */
    public function setPresenceGroupName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $presenceGroupName = null)
    {
        $this->presenceGroupName = $presenceGroupName;
        return $this;
    }
    /**
     * Get hlogStatus value
     * @return string|null
     */
    public function getHlogStatus()
    {
        return $this->hlogStatus;
    }
    /**
     * Set hlogStatus value
     * @param string $hlogStatus
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Phone
     */
    public function setHlogStatus($hlogStatus = null)
    {
        $this->hlogStatus = $hlogStatus;
        return $this;
    }
    /**
     * Get ownerUserName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getOwnerUserName()
    {
        return $this->ownerUserName;
    }
    /**
     * Set ownerUserName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ownerUserName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Phone
     */
    public function setOwnerUserName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ownerUserName = null)
    {
        $this->ownerUserName = $ownerUserName;
        return $this;
    }
    /**
     * Get signalingPort value
     * @return string|null
     */
    public function getSignalingPort()
    {
        return $this->signalingPort;
    }
    /**
     * Set signalingPort value
     * @param string $signalingPort
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Phone
     */
    public function setSignalingPort($signalingPort = null)
    {
        $this->signalingPort = $signalingPort;
        return $this;
    }
    /**
     * Get gateKeeperInfo value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\GateKeeperInfo|null
     */
    public function getGateKeeperInfo()
    {
        return $this->gateKeeperInfo;
    }
    /**
     * Set gateKeeperInfo value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\GateKeeperInfo $gateKeeperInfo
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Phone
     */
    public function setGateKeeperInfo(\\Losc\CucmBundle\Model\Webservice\StructType\GateKeeperInfo $gateKeeperInfo = null)
    {
        $this->gateKeeperInfo = $gateKeeperInfo;
        return $this;
    }
    /**
     * Get lines value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\Lines|null
     */
    public function getLines()
    {
        return $this->lines;
    }
    /**
     * Set lines value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Lines $lines
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Phone
     */
    public function setLines(\\Losc\CucmBundle\Model\Webservice\StructType\Lines $lines = null)
    {
        $this->lines = $lines;
        return $this;
    }
    /**
     * Get ignorePresentationIndicators value
     * @return string|null
     */
    public function getIgnorePresentationIndicators()
    {
        return $this->ignorePresentationIndicators;
    }
    /**
     * Set ignorePresentationIndicators value
     * @param string $ignorePresentationIndicators
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Phone
     */
    public function setIgnorePresentationIndicators($ignorePresentationIndicators = null)
    {
        $this->ignorePresentationIndicators = $ignorePresentationIndicators;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Phone
     */
    public function setCtiid($ctiid = null)
    {
        $this->ctiid = $ctiid;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Phone
     */
    public function setUuid($uuid = null)
    {
        $this->uuid = $uuid;
        return $this;
    }
}
