<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RH323Line StructType
 * @subpackage Structs
 */
class RH323Line extends AbstractStructBase
{
    /**
     * The index
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $index;
    /**
     * The label
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $label;
    /**
     * The asciiLabel
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $asciiLabel;
    /**
     * The display
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $display;
    /**
     * The dirn
     * Meta information extracted from the WSDL
     * - documentation: Only uuid attribute is returned in response
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\RDirn
     */
    public $dirn;
    /**
     * The displayAscii
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $displayAscii;
    /**
     * The e164Mask
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $e164Mask;
    /**
     * The dialPlanWizardId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dialPlanWizardId;
    /**
     * The maxNumCalls
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $maxNumCalls;
    /**
     * The busyTrigger
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $busyTrigger;
    /**
     * The callInfoDisplay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\CallInfoDisplay
     */
    public $callInfoDisplay;
    /**
     * The recordingProfileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $recordingProfileName;
    /**
     * The monitoringCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $monitoringCssName;
    /**
     * The recordingFlag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $recordingFlag;
    /**
     * The audibleMwi
     * Meta information extracted from the WSDL
     * - documentation: Not applicable for gatewayEndpointAnalogAccess and CiscoCatalyst600024PortFXSGateway
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $audibleMwi;
    /**
     * The speedDial
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $speedDial;
    /**
     * The partitionUsage
     * Meta information extracted from the WSDL
     * - documentation: This tag cannot be modified. It can only be specified in the add request.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $partitionUsage;
    /**
     * The associatedEndusers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedEndusers
     */
    public $associatedEndusers;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RH323Line
     * @uses RH323Line::setIndex()
     * @uses RH323Line::setLabel()
     * @uses RH323Line::setAsciiLabel()
     * @uses RH323Line::setDisplay()
     * @uses RH323Line::setDirn()
     * @uses RH323Line::setDisplayAscii()
     * @uses RH323Line::setE164Mask()
     * @uses RH323Line::setDialPlanWizardId()
     * @uses RH323Line::setMaxNumCalls()
     * @uses RH323Line::setBusyTrigger()
     * @uses RH323Line::setCallInfoDisplay()
     * @uses RH323Line::setRecordingProfileName()
     * @uses RH323Line::setMonitoringCssName()
     * @uses RH323Line::setRecordingFlag()
     * @uses RH323Line::setAudibleMwi()
     * @uses RH323Line::setSpeedDial()
     * @uses RH323Line::setPartitionUsage()
     * @uses RH323Line::setAssociatedEndusers()
     * @uses RH323Line::setCtiid()
     * @uses RH323Line::setUuid()
     * @param string $index
     * @param string $label
     * @param string $asciiLabel
     * @param string $display
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RDirn $dirn
     * @param string $displayAscii
     * @param string $e164Mask
     * @param string $dialPlanWizardId
     * @param string $maxNumCalls
     * @param string $busyTrigger
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\CallInfoDisplay $callInfoDisplay
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $recordingProfileName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $monitoringCssName
     * @param string $recordingFlag
     * @param string $audibleMwi
     * @param string $speedDial
     * @param string $partitionUsage
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedEndusers $associatedEndusers
     * @param int $ctiid
     * @param string $uuid
     */
    public function __construct($index = null, $label = null, $asciiLabel = null, $display = null, \\Losc\CucmBundle\Model\Webservice\StructType\RDirn $dirn = null, $displayAscii = null, $e164Mask = null, $dialPlanWizardId = null, $maxNumCalls = null, $busyTrigger = null, \\Losc\CucmBundle\Model\Webservice\StructType\CallInfoDisplay $callInfoDisplay = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $recordingProfileName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $monitoringCssName = null, $recordingFlag = null, $audibleMwi = null, $speedDial = null, $partitionUsage = null, \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedEndusers $associatedEndusers = null, $ctiid = null, $uuid = null)
    {
        $this
            ->setIndex($index)
            ->setLabel($label)
            ->setAsciiLabel($asciiLabel)
            ->setDisplay($display)
            ->setDirn($dirn)
            ->setDisplayAscii($displayAscii)
            ->setE164Mask($e164Mask)
            ->setDialPlanWizardId($dialPlanWizardId)
            ->setMaxNumCalls($maxNumCalls)
            ->setBusyTrigger($busyTrigger)
            ->setCallInfoDisplay($callInfoDisplay)
            ->setRecordingProfileName($recordingProfileName)
            ->setMonitoringCssName($monitoringCssName)
            ->setRecordingFlag($recordingFlag)
            ->setAudibleMwi($audibleMwi)
            ->setSpeedDial($speedDial)
            ->setPartitionUsage($partitionUsage)
            ->setAssociatedEndusers($associatedEndusers)
            ->setCtiid($ctiid)
            ->setUuid($uuid);
    }
    /**
     * Get index value
     * @return string|null
     */
    public function getIndex()
    {
        return $this->index;
    }
    /**
     * Set index value
     * @param string $index
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Line
     */
    public function setIndex($index = null)
    {
        $this->index = $index;
        return $this;
    }
    /**
     * Get label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->label;
    }
    /**
     * Set label value
     * @param string $label
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Line
     */
    public function setLabel($label = null)
    {
        $this->label = $label;
        return $this;
    }
    /**
     * Get asciiLabel value
     * @return string|null
     */
    public function getAsciiLabel()
    {
        return $this->asciiLabel;
    }
    /**
     * Set asciiLabel value
     * @param string $asciiLabel
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Line
     */
    public function setAsciiLabel($asciiLabel = null)
    {
        $this->asciiLabel = $asciiLabel;
        return $this;
    }
    /**
     * Get display value
     * @return string|null
     */
    public function getDisplay()
    {
        return $this->display;
    }
    /**
     * Set display value
     * @param string $display
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Line
     */
    public function setDisplay($display = null)
    {
        $this->display = $display;
        return $this;
    }
    /**
     * Get dirn value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDirn|null
     */
    public function getDirn()
    {
        return $this->dirn;
    }
    /**
     * Set dirn value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\RDirn $dirn
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Line
     */
    public function setDirn(\\Losc\CucmBundle\Model\Webservice\StructType\RDirn $dirn = null)
    {
        $this->dirn = $dirn;
        return $this;
    }
    /**
     * Get displayAscii value
     * @return string|null
     */
    public function getDisplayAscii()
    {
        return $this->displayAscii;
    }
    /**
     * Set displayAscii value
     * @param string $displayAscii
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Line
     */
    public function setDisplayAscii($displayAscii = null)
    {
        $this->displayAscii = $displayAscii;
        return $this;
    }
    /**
     * Get e164Mask value
     * @return string|null
     */
    public function getE164Mask()
    {
        return $this->e164Mask;
    }
    /**
     * Set e164Mask value
     * @param string $e164Mask
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Line
     */
    public function setE164Mask($e164Mask = null)
    {
        $this->e164Mask = $e164Mask;
        return $this;
    }
    /**
     * Get dialPlanWizardId value
     * @return string|null
     */
    public function getDialPlanWizardId()
    {
        return $this->dialPlanWizardId;
    }
    /**
     * Set dialPlanWizardId value
     * @param string $dialPlanWizardId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Line
     */
    public function setDialPlanWizardId($dialPlanWizardId = null)
    {
        $this->dialPlanWizardId = $dialPlanWizardId;
        return $this;
    }
    /**
     * Get maxNumCalls value
     * @return string|null
     */
    public function getMaxNumCalls()
    {
        return $this->maxNumCalls;
    }
    /**
     * Set maxNumCalls value
     * @param string $maxNumCalls
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Line
     */
    public function setMaxNumCalls($maxNumCalls = null)
    {
        $this->maxNumCalls = $maxNumCalls;
        return $this;
    }
    /**
     * Get busyTrigger value
     * @return string|null
     */
    public function getBusyTrigger()
    {
        return $this->busyTrigger;
    }
    /**
     * Set busyTrigger value
     * @param string $busyTrigger
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Line
     */
    public function setBusyTrigger($busyTrigger = null)
    {
        $this->busyTrigger = $busyTrigger;
        return $this;
    }
    /**
     * Get callInfoDisplay value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\CallInfoDisplay|null
     */
    public function getCallInfoDisplay()
    {
        return $this->callInfoDisplay;
    }
    /**
     * Set callInfoDisplay value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\CallInfoDisplay $callInfoDisplay
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Line
     */
    public function setCallInfoDisplay(\\Losc\CucmBundle\Model\Webservice\StructType\CallInfoDisplay $callInfoDisplay = null)
    {
        $this->callInfoDisplay = $callInfoDisplay;
        return $this;
    }
    /**
     * Get recordingProfileName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getRecordingProfileName()
    {
        return $this->recordingProfileName;
    }
    /**
     * Set recordingProfileName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $recordingProfileName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Line
     */
    public function setRecordingProfileName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $recordingProfileName = null)
    {
        $this->recordingProfileName = $recordingProfileName;
        return $this;
    }
    /**
     * Get monitoringCssName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getMonitoringCssName()
    {
        return $this->monitoringCssName;
    }
    /**
     * Set monitoringCssName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $monitoringCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Line
     */
    public function setMonitoringCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $monitoringCssName = null)
    {
        $this->monitoringCssName = $monitoringCssName;
        return $this;
    }
    /**
     * Get recordingFlag value
     * @return string|null
     */
    public function getRecordingFlag()
    {
        return $this->recordingFlag;
    }
    /**
     * Set recordingFlag value
     * @param string $recordingFlag
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Line
     */
    public function setRecordingFlag($recordingFlag = null)
    {
        $this->recordingFlag = $recordingFlag;
        return $this;
    }
    /**
     * Get audibleMwi value
     * @return string|null
     */
    public function getAudibleMwi()
    {
        return $this->audibleMwi;
    }
    /**
     * Set audibleMwi value
     * @param string $audibleMwi
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Line
     */
    public function setAudibleMwi($audibleMwi = null)
    {
        $this->audibleMwi = $audibleMwi;
        return $this;
    }
    /**
     * Get speedDial value
     * @return string|null
     */
    public function getSpeedDial()
    {
        return $this->speedDial;
    }
    /**
     * Set speedDial value
     * @param string $speedDial
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Line
     */
    public function setSpeedDial($speedDial = null)
    {
        $this->speedDial = $speedDial;
        return $this;
    }
    /**
     * Get partitionUsage value
     * @return string|null
     */
    public function getPartitionUsage()
    {
        return $this->partitionUsage;
    }
    /**
     * Set partitionUsage value
     * @param string $partitionUsage
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Line
     */
    public function setPartitionUsage($partitionUsage = null)
    {
        $this->partitionUsage = $partitionUsage;
        return $this;
    }
    /**
     * Get associatedEndusers value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedEndusers|null
     */
    public function getAssociatedEndusers()
    {
        return $this->associatedEndusers;
    }
    /**
     * Set associatedEndusers value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedEndusers $associatedEndusers
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Line
     */
    public function setAssociatedEndusers(\\Losc\CucmBundle\Model\Webservice\StructType\AssociatedEndusers $associatedEndusers = null)
    {
        $this->associatedEndusers = $associatedEndusers;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Line
     */
    public function setCtiid($ctiid = null)
    {
        $this->ctiid = $ctiid;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RH323Line
     */
    public function setUuid($uuid = null)
    {
        $this->uuid = $uuid;
        return $this;
    }
}
