<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RGatewaySubunits StructType
 * @subpackage Structs
 */
class RGatewaySubunits extends AbstractStructBase
{
    /**
     * The domainName
     * Meta information extracted from the WSDL
     * - documentation: For SCCP mention MAC Address
     * - choice: domainName | gatewayUuid
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $domainName;
    /**
     * The gatewayUuid
     * Meta information extracted from the WSDL
     * - documentation: pkid of the Gateway
     * - base: xsd:string
     * - choice: domainName | gatewayUuid
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $gatewayUuid;
    /**
     * The unit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $unit;
    /**
     * The subunits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\Subunits
     */
    public $subunits;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RGatewaySubunits
     * @uses RGatewaySubunits::setDomainName()
     * @uses RGatewaySubunits::setGatewayUuid()
     * @uses RGatewaySubunits::setUnit()
     * @uses RGatewaySubunits::setSubunits()
     * @uses RGatewaySubunits::setUuid()
     * @param string $domainName
     * @param string $gatewayUuid
     * @param string $unit
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Subunits $subunits
     * @param string $uuid
     */
    public function __construct($domainName = null, $gatewayUuid = null, $unit = null, \\Losc\CucmBundle\Model\Webservice\StructType\Subunits $subunits = null, $uuid = null)
    {
        $this
            ->setDomainName($domainName)
            ->setGatewayUuid($gatewayUuid)
            ->setUnit($unit)
            ->setSubunits($subunits)
            ->setUuid($uuid);
    }
    /**
     * Get domainName value
     * @return string|null
     */
    public function getDomainName()
    {
        return isset($this->domainName) ? $this->domainName : null;
    }
    /**
     * Set domainName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $domainName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RGatewaySubunits
     */
    public function setDomainName($domainName = null)
    {
        if (is_null($domainName) || (is_array($domainName) && empty($domainName))) {
            unset($this->domainName);
        } else {
            $this->domainName = $domainName;
        }
        return $this;
    }
    /**
     * Get gatewayUuid value
     * @return string|null
     */
    public function getGatewayUuid()
    {
        return isset($this->gatewayUuid) ? $this->gatewayUuid : null;
    }
    /**
     * Set gatewayUuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $gatewayUuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RGatewaySubunits
     */
    public function setGatewayUuid($gatewayUuid = null)
    {
        if (is_null($gatewayUuid) || (is_array($gatewayUuid) && empty($gatewayUuid))) {
            unset($this->gatewayUuid);
        } else {
            $this->gatewayUuid = $gatewayUuid;
        }
        return $this;
    }
    /**
     * Get unit value
     * @return string|null
     */
    public function getUnit()
    {
        return $this->unit;
    }
    /**
     * Set unit value
     * @param string $unit
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RGatewaySubunits
     */
    public function setUnit($unit = null)
    {
        $this->unit = $unit;
        return $this;
    }
    /**
     * Get subunits value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\Subunits|null
     */
    public function getSubunits()
    {
        return $this->subunits;
    }
    /**
     * Set subunits value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\Subunits $subunits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RGatewaySubunits
     */
    public function setSubunits(\\Losc\CucmBundle\Model\Webservice\StructType\Subunits $subunits = null)
    {
        $this->subunits = $subunits;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RGatewaySubunits
     */
    public function setUuid($uuid = null)
    {
        $this->uuid = $uuid;
        return $this;
    }
}
