<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RGatekeeper StructType
 * @subpackage Structs
 */
class RGatekeeper extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: From Device Table
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - documentation: From Device Table
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The rrqTimeToLive
     * Meta information extracted from the WSDL
     * - documentation: Value should be numbers in range of 30 to 300
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $rrqTimeToLive;
    /**
     * The retryTimeout
     * Meta information extracted from the WSDL
     * - documentation: Value should be numbers in range of 30 to 600
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $retryTimeout;
    /**
     * The enableDevice
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableDevice;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RGatekeeper
     * @uses RGatekeeper::setName()
     * @uses RGatekeeper::setDescription()
     * @uses RGatekeeper::setRrqTimeToLive()
     * @uses RGatekeeper::setRetryTimeout()
     * @uses RGatekeeper::setEnableDevice()
     * @uses RGatekeeper::setUuid()
     * @param string $name
     * @param string $description
     * @param string $rrqTimeToLive
     * @param string $retryTimeout
     * @param string $enableDevice
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $rrqTimeToLive = null, $retryTimeout = null, $enableDevice = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setRrqTimeToLive($rrqTimeToLive)
            ->setRetryTimeout($retryTimeout)
            ->setEnableDevice($enableDevice)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RGatekeeper
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RGatekeeper
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get rrqTimeToLive value
     * @return string|null
     */
    public function getRrqTimeToLive()
    {
        return $this->rrqTimeToLive;
    }
    /**
     * Set rrqTimeToLive value
     * @param string $rrqTimeToLive
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RGatekeeper
     */
    public function setRrqTimeToLive($rrqTimeToLive = null)
    {
        $this->rrqTimeToLive = $rrqTimeToLive;
        return $this;
    }
    /**
     * Get retryTimeout value
     * @return string|null
     */
    public function getRetryTimeout()
    {
        return $this->retryTimeout;
    }
    /**
     * Set retryTimeout value
     * @param string $retryTimeout
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RGatekeeper
     */
    public function setRetryTimeout($retryTimeout = null)
    {
        $this->retryTimeout = $retryTimeout;
        return $this;
    }
    /**
     * Get enableDevice value
     * @return string|null
     */
    public function getEnableDevice()
    {
        return $this->enableDevice;
    }
    /**
     * Set enableDevice value
     * @param string $enableDevice
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RGatekeeper
     */
    public function setEnableDevice($enableDevice = null)
    {
        $this->enableDevice = $enableDevice;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RGatekeeper
     */
    public function setUuid($uuid = null)
    {
        $this->uuid = $uuid;
        return $this;
    }
}
