<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RDevicePool StructType
 * @subpackage Structs
 */
class RDevicePool extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: Not nullable.
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The autoSearchSpaceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $autoSearchSpaceName;
    /**
     * The dateTimeSettingName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $dateTimeSettingName;
    /**
     * The callManagerGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callManagerGroupName;
    /**
     * The mediaResourceListName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $mediaResourceListName;
    /**
     * The regionName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $regionName;
    /**
     * The networkLocale
     * Meta information extracted from the WSDL
     * - documentation: Nullable. The value accepted and retrieved from the database for this field will be of type XCountry in AXLEnums.xsd
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $networkLocale;
    /**
     * The srstName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $srstName;
    /**
     * The connectionMonitorDuration
     * Meta information extracted from the WSDL
     * - documentation: -1 means using system default
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $connectionMonitorDuration;
    /**
     * The automatedAlternateRoutingCssName
     * Meta information extracted from the WSDL
     * - documentation: The calling search space used by Automated Alternate Routing. Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $automatedAlternateRoutingCssName;
    /**
     * The aarNeighborhoodName
     * Meta information extracted from the WSDL
     * - documentation: For IP Phones and Gateways. Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $aarNeighborhoodName;
    /**
     * The locationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $locationName;
    /**
     * The mobilityCssName
     * Meta information extracted from the WSDL
     * - documentation: The calling search space used by Device Mobility. Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $mobilityCssName;
    /**
     * The physicalLocationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $physicalLocationName;
    /**
     * The deviceMobilityGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $deviceMobilityGroupName;
    /**
     * The revertPriority
     * Meta information extracted from the WSDL
     * - documentation: The value accepted and retrieved from the database for this field will be of type XRevertPriority in AXLEnums.xsd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $revertPriority;
    /**
     * The singleButtonBarge
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $singleButtonBarge;
    /**
     * The joinAcrossLines
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $joinAcrossLines;
    /**
     * The cgpnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $cgpnTransformationCssName;
    /**
     * The cdpnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $cdpnTransformationCssName;
    /**
     * The localRouteGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $localRouteGroupName;
    /**
     * The geoLocationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $geoLocationName;
    /**
     * The geoLocationFilterName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $geoLocationFilterName;
    /**
     * The callingPartyNationalPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyNationalPrefix;
    /**
     * The callingPartyInternationalPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyInternationalPrefix;
    /**
     * The callingPartyUnknownPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyUnknownPrefix;
    /**
     * The callingPartySubscriberPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartySubscriberPrefix;
    /**
     * The adjunctCallingSearchSpace
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $adjunctCallingSearchSpace;
    /**
     * The callingPartyNationalStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyNationalStripDigits;
    /**
     * The callingPartyInternationalStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyInternationalStripDigits;
    /**
     * The callingPartyUnknownStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyUnknownStripDigits;
    /**
     * The callingPartySubscriberStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartySubscriberStripDigits;
    /**
     * The callingPartyNationalTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callingPartyNationalTransformationCssName;
    /**
     * The callingPartyInternationalTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callingPartyInternationalTransformationCssName;
    /**
     * The callingPartyUnknownTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callingPartyUnknownTransformationCssName;
    /**
     * The callingPartySubscriberTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callingPartySubscriberTransformationCssName;
    /**
     * The calledPartyNationalPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyNationalPrefix;
    /**
     * The calledPartyInternationalPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyInternationalPrefix;
    /**
     * The calledPartyUnknownPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyUnknownPrefix;
    /**
     * The calledPartySubscriberPrefix
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartySubscriberPrefix;
    /**
     * The calledPartyNationalStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyNationalStripDigits;
    /**
     * The calledPartyInternationalStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyInternationalStripDigits;
    /**
     * The calledPartyUnknownStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyUnknownStripDigits;
    /**
     * The calledPartySubscriberStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartySubscriberStripDigits;
    /**
     * The calledPartyNationalTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $calledPartyNationalTransformationCssName;
    /**
     * The calledPartyInternationalTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $calledPartyInternationalTransformationCssName;
    /**
     * The calledPartyUnknownTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $calledPartyUnknownTransformationCssName;
    /**
     * The calledPartySubscriberTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $calledPartySubscriberTransformationCssName;
    /**
     * The imeEnrolledPatternGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $imeEnrolledPatternGroupName;
    /**
     * The cntdPnTransformationCssName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $cntdPnTransformationCssName;
    /**
     * The localRouteGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\LocalRouteGroup[]
     */
    public $localRouteGroup;
    /**
     * The redirectingPartyTransformationCSS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $redirectingPartyTransformationCSS;
    /**
     * The callingPartyTransformationCSS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callingPartyTransformationCSS;
    /**
     * The wirelessLanProfileGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $wirelessLanProfileGroup;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RDevicePool
     * @uses RDevicePool::setName()
     * @uses RDevicePool::setAutoSearchSpaceName()
     * @uses RDevicePool::setDateTimeSettingName()
     * @uses RDevicePool::setCallManagerGroupName()
     * @uses RDevicePool::setMediaResourceListName()
     * @uses RDevicePool::setRegionName()
     * @uses RDevicePool::setNetworkLocale()
     * @uses RDevicePool::setSrstName()
     * @uses RDevicePool::setConnectionMonitorDuration()
     * @uses RDevicePool::setAutomatedAlternateRoutingCssName()
     * @uses RDevicePool::setAarNeighborhoodName()
     * @uses RDevicePool::setLocationName()
     * @uses RDevicePool::setMobilityCssName()
     * @uses RDevicePool::setPhysicalLocationName()
     * @uses RDevicePool::setDeviceMobilityGroupName()
     * @uses RDevicePool::setRevertPriority()
     * @uses RDevicePool::setSingleButtonBarge()
     * @uses RDevicePool::setJoinAcrossLines()
     * @uses RDevicePool::setCgpnTransformationCssName()
     * @uses RDevicePool::setCdpnTransformationCssName()
     * @uses RDevicePool::setLocalRouteGroupName()
     * @uses RDevicePool::setGeoLocationName()
     * @uses RDevicePool::setGeoLocationFilterName()
     * @uses RDevicePool::setCallingPartyNationalPrefix()
     * @uses RDevicePool::setCallingPartyInternationalPrefix()
     * @uses RDevicePool::setCallingPartyUnknownPrefix()
     * @uses RDevicePool::setCallingPartySubscriberPrefix()
     * @uses RDevicePool::setAdjunctCallingSearchSpace()
     * @uses RDevicePool::setCallingPartyNationalStripDigits()
     * @uses RDevicePool::setCallingPartyInternationalStripDigits()
     * @uses RDevicePool::setCallingPartyUnknownStripDigits()
     * @uses RDevicePool::setCallingPartySubscriberStripDigits()
     * @uses RDevicePool::setCallingPartyNationalTransformationCssName()
     * @uses RDevicePool::setCallingPartyInternationalTransformationCssName()
     * @uses RDevicePool::setCallingPartyUnknownTransformationCssName()
     * @uses RDevicePool::setCallingPartySubscriberTransformationCssName()
     * @uses RDevicePool::setCalledPartyNationalPrefix()
     * @uses RDevicePool::setCalledPartyInternationalPrefix()
     * @uses RDevicePool::setCalledPartyUnknownPrefix()
     * @uses RDevicePool::setCalledPartySubscriberPrefix()
     * @uses RDevicePool::setCalledPartyNationalStripDigits()
     * @uses RDevicePool::setCalledPartyInternationalStripDigits()
     * @uses RDevicePool::setCalledPartyUnknownStripDigits()
     * @uses RDevicePool::setCalledPartySubscriberStripDigits()
     * @uses RDevicePool::setCalledPartyNationalTransformationCssName()
     * @uses RDevicePool::setCalledPartyInternationalTransformationCssName()
     * @uses RDevicePool::setCalledPartyUnknownTransformationCssName()
     * @uses RDevicePool::setCalledPartySubscriberTransformationCssName()
     * @uses RDevicePool::setImeEnrolledPatternGroupName()
     * @uses RDevicePool::setCntdPnTransformationCssName()
     * @uses RDevicePool::setLocalRouteGroup()
     * @uses RDevicePool::setRedirectingPartyTransformationCSS()
     * @uses RDevicePool::setCallingPartyTransformationCSS()
     * @uses RDevicePool::setWirelessLanProfileGroup()
     * @uses RDevicePool::setUuid()
     * @param string $name
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $autoSearchSpaceName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dateTimeSettingName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callManagerGroupName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $regionName
     * @param string $networkLocale
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $srstName
     * @param string $connectionMonitorDuration
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mobilityCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $physicalLocationName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $deviceMobilityGroupName
     * @param string $revertPriority
     * @param string $singleButtonBarge
     * @param string $joinAcrossLines
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $localRouteGroupName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName
     * @param string $callingPartyNationalPrefix
     * @param string $callingPartyInternationalPrefix
     * @param string $callingPartyUnknownPrefix
     * @param string $callingPartySubscriberPrefix
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $adjunctCallingSearchSpace
     * @param string $callingPartyNationalStripDigits
     * @param string $callingPartyInternationalStripDigits
     * @param string $callingPartyUnknownStripDigits
     * @param string $callingPartySubscriberStripDigits
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartyNationalTransformationCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartyInternationalTransformationCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartyUnknownTransformationCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartySubscriberTransformationCssName
     * @param string $calledPartyNationalPrefix
     * @param string $calledPartyInternationalPrefix
     * @param string $calledPartyUnknownPrefix
     * @param string $calledPartySubscriberPrefix
     * @param string $calledPartyNationalStripDigits
     * @param string $calledPartyInternationalStripDigits
     * @param string $calledPartyUnknownStripDigits
     * @param string $calledPartySubscriberStripDigits
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyNationalTransformationCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyInternationalTransformationCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyUnknownTransformationCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartySubscriberTransformationCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeEnrolledPatternGroupName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cntdPnTransformationCssName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\LocalRouteGroup[] $localRouteGroup
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $redirectingPartyTransformationCSS
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartyTransformationCSS
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $wirelessLanProfileGroup
     * @param string $uuid
     */
    public function __construct($name = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $autoSearchSpaceName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dateTimeSettingName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callManagerGroupName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $regionName = null, $networkLocale = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $srstName = null, $connectionMonitorDuration = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mobilityCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $physicalLocationName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $deviceMobilityGroupName = null, $revertPriority = null, $singleButtonBarge = null, $joinAcrossLines = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $localRouteGroupName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName = null, $callingPartyNationalPrefix = null, $callingPartyInternationalPrefix = null, $callingPartyUnknownPrefix = null, $callingPartySubscriberPrefix = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $adjunctCallingSearchSpace = null, $callingPartyNationalStripDigits = null, $callingPartyInternationalStripDigits = null, $callingPartyUnknownStripDigits = null, $callingPartySubscriberStripDigits = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartyNationalTransformationCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartyInternationalTransformationCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartyUnknownTransformationCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartySubscriberTransformationCssName = null, $calledPartyNationalPrefix = null, $calledPartyInternationalPrefix = null, $calledPartyUnknownPrefix = null, $calledPartySubscriberPrefix = null, $calledPartyNationalStripDigits = null, $calledPartyInternationalStripDigits = null, $calledPartyUnknownStripDigits = null, $calledPartySubscriberStripDigits = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyNationalTransformationCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyInternationalTransformationCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyUnknownTransformationCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartySubscriberTransformationCssName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeEnrolledPatternGroupName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cntdPnTransformationCssName = null, array $localRouteGroup = array(), \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $redirectingPartyTransformationCSS = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartyTransformationCSS = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $wirelessLanProfileGroup = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setAutoSearchSpaceName($autoSearchSpaceName)
            ->setDateTimeSettingName($dateTimeSettingName)
            ->setCallManagerGroupName($callManagerGroupName)
            ->setMediaResourceListName($mediaResourceListName)
            ->setRegionName($regionName)
            ->setNetworkLocale($networkLocale)
            ->setSrstName($srstName)
            ->setConnectionMonitorDuration($connectionMonitorDuration)
            ->setAutomatedAlternateRoutingCssName($automatedAlternateRoutingCssName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setLocationName($locationName)
            ->setMobilityCssName($mobilityCssName)
            ->setPhysicalLocationName($physicalLocationName)
            ->setDeviceMobilityGroupName($deviceMobilityGroupName)
            ->setRevertPriority($revertPriority)
            ->setSingleButtonBarge($singleButtonBarge)
            ->setJoinAcrossLines($joinAcrossLines)
            ->setCgpnTransformationCssName($cgpnTransformationCssName)
            ->setCdpnTransformationCssName($cdpnTransformationCssName)
            ->setLocalRouteGroupName($localRouteGroupName)
            ->setGeoLocationName($geoLocationName)
            ->setGeoLocationFilterName($geoLocationFilterName)
            ->setCallingPartyNationalPrefix($callingPartyNationalPrefix)
            ->setCallingPartyInternationalPrefix($callingPartyInternationalPrefix)
            ->setCallingPartyUnknownPrefix($callingPartyUnknownPrefix)
            ->setCallingPartySubscriberPrefix($callingPartySubscriberPrefix)
            ->setAdjunctCallingSearchSpace($adjunctCallingSearchSpace)
            ->setCallingPartyNationalStripDigits($callingPartyNationalStripDigits)
            ->setCallingPartyInternationalStripDigits($callingPartyInternationalStripDigits)
            ->setCallingPartyUnknownStripDigits($callingPartyUnknownStripDigits)
            ->setCallingPartySubscriberStripDigits($callingPartySubscriberStripDigits)
            ->setCallingPartyNationalTransformationCssName($callingPartyNationalTransformationCssName)
            ->setCallingPartyInternationalTransformationCssName($callingPartyInternationalTransformationCssName)
            ->setCallingPartyUnknownTransformationCssName($callingPartyUnknownTransformationCssName)
            ->setCallingPartySubscriberTransformationCssName($callingPartySubscriberTransformationCssName)
            ->setCalledPartyNationalPrefix($calledPartyNationalPrefix)
            ->setCalledPartyInternationalPrefix($calledPartyInternationalPrefix)
            ->setCalledPartyUnknownPrefix($calledPartyUnknownPrefix)
            ->setCalledPartySubscriberPrefix($calledPartySubscriberPrefix)
            ->setCalledPartyNationalStripDigits($calledPartyNationalStripDigits)
            ->setCalledPartyInternationalStripDigits($calledPartyInternationalStripDigits)
            ->setCalledPartyUnknownStripDigits($calledPartyUnknownStripDigits)
            ->setCalledPartySubscriberStripDigits($calledPartySubscriberStripDigits)
            ->setCalledPartyNationalTransformationCssName($calledPartyNationalTransformationCssName)
            ->setCalledPartyInternationalTransformationCssName($calledPartyInternationalTransformationCssName)
            ->setCalledPartyUnknownTransformationCssName($calledPartyUnknownTransformationCssName)
            ->setCalledPartySubscriberTransformationCssName($calledPartySubscriberTransformationCssName)
            ->setImeEnrolledPatternGroupName($imeEnrolledPatternGroupName)
            ->setCntdPnTransformationCssName($cntdPnTransformationCssName)
            ->setLocalRouteGroup($localRouteGroup)
            ->setRedirectingPartyTransformationCSS($redirectingPartyTransformationCSS)
            ->setCallingPartyTransformationCSS($callingPartyTransformationCSS)
            ->setWirelessLanProfileGroup($wirelessLanProfileGroup)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get autoSearchSpaceName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getAutoSearchSpaceName()
    {
        return $this->autoSearchSpaceName;
    }
    /**
     * Set autoSearchSpaceName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $autoSearchSpaceName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setAutoSearchSpaceName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $autoSearchSpaceName = null)
    {
        $this->autoSearchSpaceName = $autoSearchSpaceName;
        return $this;
    }
    /**
     * Get dateTimeSettingName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDateTimeSettingName()
    {
        return $this->dateTimeSettingName;
    }
    /**
     * Set dateTimeSettingName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dateTimeSettingName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setDateTimeSettingName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $dateTimeSettingName = null)
    {
        $this->dateTimeSettingName = $dateTimeSettingName;
        return $this;
    }
    /**
     * Get callManagerGroupName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallManagerGroupName()
    {
        return $this->callManagerGroupName;
    }
    /**
     * Set callManagerGroupName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callManagerGroupName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setCallManagerGroupName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callManagerGroupName = null)
    {
        $this->callManagerGroupName = $callManagerGroupName;
        return $this;
    }
    /**
     * Get mediaResourceListName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getMediaResourceListName()
    {
        return $this->mediaResourceListName;
    }
    /**
     * Set mediaResourceListName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setMediaResourceListName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mediaResourceListName = null)
    {
        $this->mediaResourceListName = $mediaResourceListName;
        return $this;
    }
    /**
     * Get regionName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getRegionName()
    {
        return $this->regionName;
    }
    /**
     * Set regionName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $regionName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setRegionName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $regionName = null)
    {
        $this->regionName = $regionName;
        return $this;
    }
    /**
     * Get networkLocale value
     * @return string|null
     */
    public function getNetworkLocale()
    {
        return $this->networkLocale;
    }
    /**
     * Set networkLocale value
     * @param string $networkLocale
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setNetworkLocale($networkLocale = null)
    {
        $this->networkLocale = $networkLocale;
        return $this;
    }
    /**
     * Get srstName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSrstName()
    {
        return $this->srstName;
    }
    /**
     * Set srstName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $srstName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setSrstName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $srstName = null)
    {
        $this->srstName = $srstName;
        return $this;
    }
    /**
     * Get connectionMonitorDuration value
     * @return string|null
     */
    public function getConnectionMonitorDuration()
    {
        return $this->connectionMonitorDuration;
    }
    /**
     * Set connectionMonitorDuration value
     * @param string $connectionMonitorDuration
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setConnectionMonitorDuration($connectionMonitorDuration = null)
    {
        $this->connectionMonitorDuration = $connectionMonitorDuration;
        return $this;
    }
    /**
     * Get automatedAlternateRoutingCssName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getAutomatedAlternateRoutingCssName()
    {
        return $this->automatedAlternateRoutingCssName;
    }
    /**
     * Set automatedAlternateRoutingCssName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setAutomatedAlternateRoutingCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $automatedAlternateRoutingCssName = null)
    {
        $this->automatedAlternateRoutingCssName = $automatedAlternateRoutingCssName;
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return $this->aarNeighborhoodName;
    }
    /**
     * Set aarNeighborhoodName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setAarNeighborhoodName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $aarNeighborhoodName = null)
    {
        $this->aarNeighborhoodName = $aarNeighborhoodName;
        return $this;
    }
    /**
     * Get locationName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setLocationName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get mobilityCssName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getMobilityCssName()
    {
        return $this->mobilityCssName;
    }
    /**
     * Set mobilityCssName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mobilityCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setMobilityCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $mobilityCssName = null)
    {
        $this->mobilityCssName = $mobilityCssName;
        return $this;
    }
    /**
     * Get physicalLocationName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getPhysicalLocationName()
    {
        return $this->physicalLocationName;
    }
    /**
     * Set physicalLocationName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $physicalLocationName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setPhysicalLocationName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $physicalLocationName = null)
    {
        $this->physicalLocationName = $physicalLocationName;
        return $this;
    }
    /**
     * Get deviceMobilityGroupName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDeviceMobilityGroupName()
    {
        return $this->deviceMobilityGroupName;
    }
    /**
     * Set deviceMobilityGroupName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $deviceMobilityGroupName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setDeviceMobilityGroupName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $deviceMobilityGroupName = null)
    {
        $this->deviceMobilityGroupName = $deviceMobilityGroupName;
        return $this;
    }
    /**
     * Get revertPriority value
     * @return string|null
     */
    public function getRevertPriority()
    {
        return $this->revertPriority;
    }
    /**
     * Set revertPriority value
     * @param string $revertPriority
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setRevertPriority($revertPriority = null)
    {
        $this->revertPriority = $revertPriority;
        return $this;
    }
    /**
     * Get singleButtonBarge value
     * @return string|null
     */
    public function getSingleButtonBarge()
    {
        return $this->singleButtonBarge;
    }
    /**
     * Set singleButtonBarge value
     * @param string $singleButtonBarge
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setSingleButtonBarge($singleButtonBarge = null)
    {
        $this->singleButtonBarge = $singleButtonBarge;
        return $this;
    }
    /**
     * Get joinAcrossLines value
     * @return string|null
     */
    public function getJoinAcrossLines()
    {
        return $this->joinAcrossLines;
    }
    /**
     * Set joinAcrossLines value
     * @param string $joinAcrossLines
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setJoinAcrossLines($joinAcrossLines = null)
    {
        $this->joinAcrossLines = $joinAcrossLines;
        return $this;
    }
    /**
     * Get cgpnTransformationCssName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCgpnTransformationCssName()
    {
        return $this->cgpnTransformationCssName;
    }
    /**
     * Set cgpnTransformationCssName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setCgpnTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cgpnTransformationCssName = null)
    {
        $this->cgpnTransformationCssName = $cgpnTransformationCssName;
        return $this;
    }
    /**
     * Get cdpnTransformationCssName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCdpnTransformationCssName()
    {
        return $this->cdpnTransformationCssName;
    }
    /**
     * Set cdpnTransformationCssName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setCdpnTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cdpnTransformationCssName = null)
    {
        $this->cdpnTransformationCssName = $cdpnTransformationCssName;
        return $this;
    }
    /**
     * Get localRouteGroupName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getLocalRouteGroupName()
    {
        return $this->localRouteGroupName;
    }
    /**
     * Set localRouteGroupName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $localRouteGroupName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setLocalRouteGroupName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $localRouteGroupName = null)
    {
        $this->localRouteGroupName = $localRouteGroupName;
        return $this;
    }
    /**
     * Get geoLocationName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getGeoLocationName()
    {
        return $this->geoLocationName;
    }
    /**
     * Set geoLocationName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setGeoLocationName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationName = null)
    {
        $this->geoLocationName = $geoLocationName;
        return $this;
    }
    /**
     * Get geoLocationFilterName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getGeoLocationFilterName()
    {
        return $this->geoLocationFilterName;
    }
    /**
     * Set geoLocationFilterName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setGeoLocationFilterName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $geoLocationFilterName = null)
    {
        $this->geoLocationFilterName = $geoLocationFilterName;
        return $this;
    }
    /**
     * Get callingPartyNationalPrefix value
     * @return string|null
     */
    public function getCallingPartyNationalPrefix()
    {
        return $this->callingPartyNationalPrefix;
    }
    /**
     * Set callingPartyNationalPrefix value
     * @param string $callingPartyNationalPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setCallingPartyNationalPrefix($callingPartyNationalPrefix = null)
    {
        $this->callingPartyNationalPrefix = $callingPartyNationalPrefix;
        return $this;
    }
    /**
     * Get callingPartyInternationalPrefix value
     * @return string|null
     */
    public function getCallingPartyInternationalPrefix()
    {
        return $this->callingPartyInternationalPrefix;
    }
    /**
     * Set callingPartyInternationalPrefix value
     * @param string $callingPartyInternationalPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setCallingPartyInternationalPrefix($callingPartyInternationalPrefix = null)
    {
        $this->callingPartyInternationalPrefix = $callingPartyInternationalPrefix;
        return $this;
    }
    /**
     * Get callingPartyUnknownPrefix value
     * @return string|null
     */
    public function getCallingPartyUnknownPrefix()
    {
        return $this->callingPartyUnknownPrefix;
    }
    /**
     * Set callingPartyUnknownPrefix value
     * @param string $callingPartyUnknownPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setCallingPartyUnknownPrefix($callingPartyUnknownPrefix = null)
    {
        $this->callingPartyUnknownPrefix = $callingPartyUnknownPrefix;
        return $this;
    }
    /**
     * Get callingPartySubscriberPrefix value
     * @return string|null
     */
    public function getCallingPartySubscriberPrefix()
    {
        return $this->callingPartySubscriberPrefix;
    }
    /**
     * Set callingPartySubscriberPrefix value
     * @param string $callingPartySubscriberPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setCallingPartySubscriberPrefix($callingPartySubscriberPrefix = null)
    {
        $this->callingPartySubscriberPrefix = $callingPartySubscriberPrefix;
        return $this;
    }
    /**
     * Get adjunctCallingSearchSpace value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getAdjunctCallingSearchSpace()
    {
        return $this->adjunctCallingSearchSpace;
    }
    /**
     * Set adjunctCallingSearchSpace value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $adjunctCallingSearchSpace
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setAdjunctCallingSearchSpace(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $adjunctCallingSearchSpace = null)
    {
        $this->adjunctCallingSearchSpace = $adjunctCallingSearchSpace;
        return $this;
    }
    /**
     * Get callingPartyNationalStripDigits value
     * @return string|null
     */
    public function getCallingPartyNationalStripDigits()
    {
        return $this->callingPartyNationalStripDigits;
    }
    /**
     * Set callingPartyNationalStripDigits value
     * @param string $callingPartyNationalStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setCallingPartyNationalStripDigits($callingPartyNationalStripDigits = null)
    {
        $this->callingPartyNationalStripDigits = $callingPartyNationalStripDigits;
        return $this;
    }
    /**
     * Get callingPartyInternationalStripDigits value
     * @return string|null
     */
    public function getCallingPartyInternationalStripDigits()
    {
        return $this->callingPartyInternationalStripDigits;
    }
    /**
     * Set callingPartyInternationalStripDigits value
     * @param string $callingPartyInternationalStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setCallingPartyInternationalStripDigits($callingPartyInternationalStripDigits = null)
    {
        $this->callingPartyInternationalStripDigits = $callingPartyInternationalStripDigits;
        return $this;
    }
    /**
     * Get callingPartyUnknownStripDigits value
     * @return string|null
     */
    public function getCallingPartyUnknownStripDigits()
    {
        return $this->callingPartyUnknownStripDigits;
    }
    /**
     * Set callingPartyUnknownStripDigits value
     * @param string $callingPartyUnknownStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setCallingPartyUnknownStripDigits($callingPartyUnknownStripDigits = null)
    {
        $this->callingPartyUnknownStripDigits = $callingPartyUnknownStripDigits;
        return $this;
    }
    /**
     * Get callingPartySubscriberStripDigits value
     * @return string|null
     */
    public function getCallingPartySubscriberStripDigits()
    {
        return $this->callingPartySubscriberStripDigits;
    }
    /**
     * Set callingPartySubscriberStripDigits value
     * @param string $callingPartySubscriberStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setCallingPartySubscriberStripDigits($callingPartySubscriberStripDigits = null)
    {
        $this->callingPartySubscriberStripDigits = $callingPartySubscriberStripDigits;
        return $this;
    }
    /**
     * Get callingPartyNationalTransformationCssName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallingPartyNationalTransformationCssName()
    {
        return $this->callingPartyNationalTransformationCssName;
    }
    /**
     * Set callingPartyNationalTransformationCssName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartyNationalTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setCallingPartyNationalTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartyNationalTransformationCssName = null)
    {
        $this->callingPartyNationalTransformationCssName = $callingPartyNationalTransformationCssName;
        return $this;
    }
    /**
     * Get callingPartyInternationalTransformationCssName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallingPartyInternationalTransformationCssName()
    {
        return $this->callingPartyInternationalTransformationCssName;
    }
    /**
     * Set callingPartyInternationalTransformationCssName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartyInternationalTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setCallingPartyInternationalTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartyInternationalTransformationCssName = null)
    {
        $this->callingPartyInternationalTransformationCssName = $callingPartyInternationalTransformationCssName;
        return $this;
    }
    /**
     * Get callingPartyUnknownTransformationCssName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallingPartyUnknownTransformationCssName()
    {
        return $this->callingPartyUnknownTransformationCssName;
    }
    /**
     * Set callingPartyUnknownTransformationCssName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartyUnknownTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setCallingPartyUnknownTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartyUnknownTransformationCssName = null)
    {
        $this->callingPartyUnknownTransformationCssName = $callingPartyUnknownTransformationCssName;
        return $this;
    }
    /**
     * Get callingPartySubscriberTransformationCssName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallingPartySubscriberTransformationCssName()
    {
        return $this->callingPartySubscriberTransformationCssName;
    }
    /**
     * Set callingPartySubscriberTransformationCssName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartySubscriberTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setCallingPartySubscriberTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartySubscriberTransformationCssName = null)
    {
        $this->callingPartySubscriberTransformationCssName = $callingPartySubscriberTransformationCssName;
        return $this;
    }
    /**
     * Get calledPartyNationalPrefix value
     * @return string|null
     */
    public function getCalledPartyNationalPrefix()
    {
        return $this->calledPartyNationalPrefix;
    }
    /**
     * Set calledPartyNationalPrefix value
     * @param string $calledPartyNationalPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setCalledPartyNationalPrefix($calledPartyNationalPrefix = null)
    {
        $this->calledPartyNationalPrefix = $calledPartyNationalPrefix;
        return $this;
    }
    /**
     * Get calledPartyInternationalPrefix value
     * @return string|null
     */
    public function getCalledPartyInternationalPrefix()
    {
        return $this->calledPartyInternationalPrefix;
    }
    /**
     * Set calledPartyInternationalPrefix value
     * @param string $calledPartyInternationalPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setCalledPartyInternationalPrefix($calledPartyInternationalPrefix = null)
    {
        $this->calledPartyInternationalPrefix = $calledPartyInternationalPrefix;
        return $this;
    }
    /**
     * Get calledPartyUnknownPrefix value
     * @return string|null
     */
    public function getCalledPartyUnknownPrefix()
    {
        return $this->calledPartyUnknownPrefix;
    }
    /**
     * Set calledPartyUnknownPrefix value
     * @param string $calledPartyUnknownPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setCalledPartyUnknownPrefix($calledPartyUnknownPrefix = null)
    {
        $this->calledPartyUnknownPrefix = $calledPartyUnknownPrefix;
        return $this;
    }
    /**
     * Get calledPartySubscriberPrefix value
     * @return string|null
     */
    public function getCalledPartySubscriberPrefix()
    {
        return $this->calledPartySubscriberPrefix;
    }
    /**
     * Set calledPartySubscriberPrefix value
     * @param string $calledPartySubscriberPrefix
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setCalledPartySubscriberPrefix($calledPartySubscriberPrefix = null)
    {
        $this->calledPartySubscriberPrefix = $calledPartySubscriberPrefix;
        return $this;
    }
    /**
     * Get calledPartyNationalStripDigits value
     * @return string|null
     */
    public function getCalledPartyNationalStripDigits()
    {
        return $this->calledPartyNationalStripDigits;
    }
    /**
     * Set calledPartyNationalStripDigits value
     * @param string $calledPartyNationalStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setCalledPartyNationalStripDigits($calledPartyNationalStripDigits = null)
    {
        $this->calledPartyNationalStripDigits = $calledPartyNationalStripDigits;
        return $this;
    }
    /**
     * Get calledPartyInternationalStripDigits value
     * @return string|null
     */
    public function getCalledPartyInternationalStripDigits()
    {
        return $this->calledPartyInternationalStripDigits;
    }
    /**
     * Set calledPartyInternationalStripDigits value
     * @param string $calledPartyInternationalStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setCalledPartyInternationalStripDigits($calledPartyInternationalStripDigits = null)
    {
        $this->calledPartyInternationalStripDigits = $calledPartyInternationalStripDigits;
        return $this;
    }
    /**
     * Get calledPartyUnknownStripDigits value
     * @return string|null
     */
    public function getCalledPartyUnknownStripDigits()
    {
        return $this->calledPartyUnknownStripDigits;
    }
    /**
     * Set calledPartyUnknownStripDigits value
     * @param string $calledPartyUnknownStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setCalledPartyUnknownStripDigits($calledPartyUnknownStripDigits = null)
    {
        $this->calledPartyUnknownStripDigits = $calledPartyUnknownStripDigits;
        return $this;
    }
    /**
     * Get calledPartySubscriberStripDigits value
     * @return string|null
     */
    public function getCalledPartySubscriberStripDigits()
    {
        return $this->calledPartySubscriberStripDigits;
    }
    /**
     * Set calledPartySubscriberStripDigits value
     * @param string $calledPartySubscriberStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setCalledPartySubscriberStripDigits($calledPartySubscriberStripDigits = null)
    {
        $this->calledPartySubscriberStripDigits = $calledPartySubscriberStripDigits;
        return $this;
    }
    /**
     * Get calledPartyNationalTransformationCssName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCalledPartyNationalTransformationCssName()
    {
        return $this->calledPartyNationalTransformationCssName;
    }
    /**
     * Set calledPartyNationalTransformationCssName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyNationalTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setCalledPartyNationalTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyNationalTransformationCssName = null)
    {
        $this->calledPartyNationalTransformationCssName = $calledPartyNationalTransformationCssName;
        return $this;
    }
    /**
     * Get calledPartyInternationalTransformationCssName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCalledPartyInternationalTransformationCssName()
    {
        return $this->calledPartyInternationalTransformationCssName;
    }
    /**
     * Set calledPartyInternationalTransformationCssName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyInternationalTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setCalledPartyInternationalTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyInternationalTransformationCssName = null)
    {
        $this->calledPartyInternationalTransformationCssName = $calledPartyInternationalTransformationCssName;
        return $this;
    }
    /**
     * Get calledPartyUnknownTransformationCssName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCalledPartyUnknownTransformationCssName()
    {
        return $this->calledPartyUnknownTransformationCssName;
    }
    /**
     * Set calledPartyUnknownTransformationCssName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyUnknownTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setCalledPartyUnknownTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartyUnknownTransformationCssName = null)
    {
        $this->calledPartyUnknownTransformationCssName = $calledPartyUnknownTransformationCssName;
        return $this;
    }
    /**
     * Get calledPartySubscriberTransformationCssName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCalledPartySubscriberTransformationCssName()
    {
        return $this->calledPartySubscriberTransformationCssName;
    }
    /**
     * Set calledPartySubscriberTransformationCssName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartySubscriberTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setCalledPartySubscriberTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $calledPartySubscriberTransformationCssName = null)
    {
        $this->calledPartySubscriberTransformationCssName = $calledPartySubscriberTransformationCssName;
        return $this;
    }
    /**
     * Get imeEnrolledPatternGroupName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getImeEnrolledPatternGroupName()
    {
        return $this->imeEnrolledPatternGroupName;
    }
    /**
     * Set imeEnrolledPatternGroupName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeEnrolledPatternGroupName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setImeEnrolledPatternGroupName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $imeEnrolledPatternGroupName = null)
    {
        $this->imeEnrolledPatternGroupName = $imeEnrolledPatternGroupName;
        return $this;
    }
    /**
     * Get cntdPnTransformationCssName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCntdPnTransformationCssName()
    {
        return $this->cntdPnTransformationCssName;
    }
    /**
     * Set cntdPnTransformationCssName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cntdPnTransformationCssName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setCntdPnTransformationCssName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $cntdPnTransformationCssName = null)
    {
        $this->cntdPnTransformationCssName = $cntdPnTransformationCssName;
        return $this;
    }
    /**
     * Get localRouteGroup value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LocalRouteGroup[]|null
     */
    public function getLocalRouteGroup()
    {
        return $this->localRouteGroup;
    }
    /**
     * Set localRouteGroup value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\LocalRouteGroup[] $localRouteGroup
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setLocalRouteGroup(array $localRouteGroup = array())
    {
        $this->localRouteGroup = $localRouteGroup;
        return $this;
    }
    /**
     * Add item to localRouteGroup value
     * @throws \InvalidArgumentException
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\LocalRouteGroup $item
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function addToLocalRouteGroup(\\Losc\CucmBundle\Model\Webservice\StructType\LocalRouteGroup $item)
    {
        $this->localRouteGroup[] = $item;
        return $this;
    }
    /**
     * Get redirectingPartyTransformationCSS value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getRedirectingPartyTransformationCSS()
    {
        return $this->redirectingPartyTransformationCSS;
    }
    /**
     * Set redirectingPartyTransformationCSS value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $redirectingPartyTransformationCSS
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setRedirectingPartyTransformationCSS(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $redirectingPartyTransformationCSS = null)
    {
        $this->redirectingPartyTransformationCSS = $redirectingPartyTransformationCSS;
        return $this;
    }
    /**
     * Get callingPartyTransformationCSS value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCallingPartyTransformationCSS()
    {
        return $this->callingPartyTransformationCSS;
    }
    /**
     * Set callingPartyTransformationCSS value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartyTransformationCSS
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setCallingPartyTransformationCSS(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callingPartyTransformationCSS = null)
    {
        $this->callingPartyTransformationCSS = $callingPartyTransformationCSS;
        return $this;
    }
    /**
     * Get wirelessLanProfileGroup value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getWirelessLanProfileGroup()
    {
        return $this->wirelessLanProfileGroup;
    }
    /**
     * Set wirelessLanProfileGroup value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $wirelessLanProfileGroup
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setWirelessLanProfileGroup(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $wirelessLanProfileGroup = null)
    {
        $this->wirelessLanProfileGroup = $wirelessLanProfileGroup;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RDevicePool
     */
    public function setUuid($uuid = null)
    {
        $this->uuid = $uuid;
        return $this;
    }
}
