<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RCcdHostedDN StructType
 * @subpackage Structs
 */
class RCcdHostedDN extends AbstractStructBase
{
    /**
     * The hostedPattern
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $hostedPattern;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The CcdHostedDnGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $CcdHostedDnGroup;
    /**
     * The pstnFailoverStripDigits
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pstnFailoverStripDigits;
    /**
     * The pstnFailoverPrependDigits
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pstnFailoverPrependDigits;
    /**
     * The usePstnFailover
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $usePstnFailover;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RCcdHostedDN
     * @uses RCcdHostedDN::setHostedPattern()
     * @uses RCcdHostedDN::setDescription()
     * @uses RCcdHostedDN::setCcdHostedDnGroup()
     * @uses RCcdHostedDN::setPstnFailoverStripDigits()
     * @uses RCcdHostedDN::setPstnFailoverPrependDigits()
     * @uses RCcdHostedDN::setUsePstnFailover()
     * @uses RCcdHostedDN::setUuid()
     * @param string $hostedPattern
     * @param string $description
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ccdHostedDnGroup
     * @param string $pstnFailoverStripDigits
     * @param string $pstnFailoverPrependDigits
     * @param string $usePstnFailover
     * @param string $uuid
     */
    public function __construct($hostedPattern = null, $description = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ccdHostedDnGroup = null, $pstnFailoverStripDigits = null, $pstnFailoverPrependDigits = null, $usePstnFailover = null, $uuid = null)
    {
        $this
            ->setHostedPattern($hostedPattern)
            ->setDescription($description)
            ->setCcdHostedDnGroup($ccdHostedDnGroup)
            ->setPstnFailoverStripDigits($pstnFailoverStripDigits)
            ->setPstnFailoverPrependDigits($pstnFailoverPrependDigits)
            ->setUsePstnFailover($usePstnFailover)
            ->setUuid($uuid);
    }
    /**
     * Get hostedPattern value
     * @return string|null
     */
    public function getHostedPattern()
    {
        return $this->hostedPattern;
    }
    /**
     * Set hostedPattern value
     * @param string $hostedPattern
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCcdHostedDN
     */
    public function setHostedPattern($hostedPattern = null)
    {
        $this->hostedPattern = $hostedPattern;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCcdHostedDN
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get CcdHostedDnGroup value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getCcdHostedDnGroup()
    {
        return $this->CcdHostedDnGroup;
    }
    /**
     * Set CcdHostedDnGroup value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ccdHostedDnGroup
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCcdHostedDN
     */
    public function setCcdHostedDnGroup(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ccdHostedDnGroup = null)
    {
        $this->CcdHostedDnGroup = $ccdHostedDnGroup;
        return $this;
    }
    /**
     * Get pstnFailoverStripDigits value
     * @return string|null
     */
    public function getPstnFailoverStripDigits()
    {
        return $this->pstnFailoverStripDigits;
    }
    /**
     * Set pstnFailoverStripDigits value
     * @param string $pstnFailoverStripDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCcdHostedDN
     */
    public function setPstnFailoverStripDigits($pstnFailoverStripDigits = null)
    {
        $this->pstnFailoverStripDigits = $pstnFailoverStripDigits;
        return $this;
    }
    /**
     * Get pstnFailoverPrependDigits value
     * @return string|null
     */
    public function getPstnFailoverPrependDigits()
    {
        return $this->pstnFailoverPrependDigits;
    }
    /**
     * Set pstnFailoverPrependDigits value
     * @param string $pstnFailoverPrependDigits
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCcdHostedDN
     */
    public function setPstnFailoverPrependDigits($pstnFailoverPrependDigits = null)
    {
        $this->pstnFailoverPrependDigits = $pstnFailoverPrependDigits;
        return $this;
    }
    /**
     * Get usePstnFailover value
     * @return string|null
     */
    public function getUsePstnFailover()
    {
        return $this->usePstnFailover;
    }
    /**
     * Set usePstnFailover value
     * @param string $usePstnFailover
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCcdHostedDN
     */
    public function setUsePstnFailover($usePstnFailover = null)
    {
        $this->usePstnFailover = $usePstnFailover;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\RCcdHostedDN
     */
    public function setUuid($uuid = null)
    {
        $this->uuid = $uuid;
        return $this;
    }
}
