<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ports StructType
 * @subpackage Structs
 */
class Ports extends AbstractStructBase
{
    /**
     * The port
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XAnalogPort[]
     */
    public $port;
    /**
     * The ethernetPhonePort
     * Meta information extracted from the WSDL
     * - default: 2000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ethernetPhonePort;
    /**
     * The mgcpPorts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\MgcpPorts
     */
    public $mgcpPorts;
    /**
     * The sipPorts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\SipPorts
     */
    public $sipPorts;
    /**
     * Constructor method for ports
     * @uses Ports::setPort()
     * @uses Ports::setEthernetPhonePort()
     * @uses Ports::setMgcpPorts()
     * @uses Ports::setSipPorts()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XAnalogPort[] $port
     * @param string $ethernetPhonePort
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\MgcpPorts $mgcpPorts
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\SipPorts $sipPorts
     */
    public function __construct(array $port = array(), $ethernetPhonePort = '2000', \\Losc\CucmBundle\Model\Webservice\StructType\MgcpPorts $mgcpPorts = null, \\Losc\CucmBundle\Model\Webservice\StructType\SipPorts $sipPorts = null)
    {
        $this
            ->setPort($port)
            ->setEthernetPhonePort($ethernetPhonePort)
            ->setMgcpPorts($mgcpPorts)
            ->setSipPorts($sipPorts);
    }
    /**
     * Get port value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XAnalogPort[]
     */
    public function getPort()
    {
        return $this->port;
    }
    /**
     * Set port value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XAnalogPort[] $port
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\Ports
     */
    public function setPort(array $port = array())
    {
        $this->port = $port;
        return $this;
    }
    /**
     * Add item to port value
     * @throws \InvalidArgumentException
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XAnalogPort $item
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\Ports
     */
    public function addToPort(\\Losc\CucmBundle\Model\Webservice\StructType\XAnalogPort $item)
    {
        $this->port[] = $item;
        return $this;
    }
    /**
     * Get ethernetPhonePort value
     * @return string|null
     */
    public function getEthernetPhonePort()
    {
        return $this->ethernetPhonePort;
    }
    /**
     * Set ethernetPhonePort value
     * @param string $ethernetPhonePort
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\Ports
     */
    public function setEthernetPhonePort($ethernetPhonePort = '2000')
    {
        $this->ethernetPhonePort = $ethernetPhonePort;
        return $this;
    }
    /**
     * Get mgcpPorts value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\MgcpPorts|null
     */
    public function getMgcpPorts()
    {
        return $this->mgcpPorts;
    }
    /**
     * Set mgcpPorts value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\MgcpPorts $mgcpPorts
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\Ports
     */
    public function setMgcpPorts(\\Losc\CucmBundle\Model\Webservice\StructType\MgcpPorts $mgcpPorts = null)
    {
        $this->mgcpPorts = $mgcpPorts;
        return $this;
    }
    /**
     * Get sipPorts value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\SipPorts|null
     */
    public function getSipPorts()
    {
        return $this->sipPorts;
    }
    /**
     * Set sipPorts value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\SipPorts $sipPorts
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\Ports
     */
    public function setSipPorts(\\Losc\CucmBundle\Model\Webservice\StructType\SipPorts $sipPorts = null)
    {
        $this->sipPorts = $sipPorts;
        return $this;
    }
}
