<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for mgcpPorts StructType
 * @subpackage Structs
 */
class MgcpPorts extends AbstractStructBase
{
    /**
     * The listen
     * Meta information extracted from the WSDL
     * - documentation: UDP port for MGCP communication.
     * - default: 2427
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $listen;
    /**
     * The keepAlive
     * Meta information extracted from the WSDL
     * - documentation: TCP port for backhaul for Q.931 messages.
     * - default: 2428
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $keepAlive;
    /**
     * Constructor method for mgcpPorts
     * @uses MgcpPorts::setListen()
     * @uses MgcpPorts::setKeepAlive()
     * @param string $listen
     * @param string $keepAlive
     */
    public function __construct($listen = '2427', $keepAlive = '2428')
    {
        $this
            ->setListen($listen)
            ->setKeepAlive($keepAlive);
    }
    /**
     * Get listen value
     * @return string|null
     */
    public function getListen()
    {
        return $this->listen;
    }
    /**
     * Set listen value
     * @param string $listen
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\MgcpPorts
     */
    public function setListen($listen = '2427')
    {
        $this->listen = $listen;
        return $this;
    }
    /**
     * Get keepAlive value
     * @return string|null
     */
    public function getKeepAlive()
    {
        return $this->keepAlive;
    }
    /**
     * Set keepAlive value
     * @param string $keepAlive
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\MgcpPorts
     */
    public function setKeepAlive($keepAlive = '2428')
    {
        $this->keepAlive = $keepAlive;
        return $this;
    }
}
