<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LTvsCertificate StructType
 * @subpackage Structs
 */
class LTvsCertificate extends AbstractStructBase
{
    /**
     * The subjectName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $subjectName;
    /**
     * The issuerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $issuerName;
    /**
     * The serialNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $serialNumber;
    /**
     * The timeToLive
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $timeToLive;
    /**
     * The ipv4Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ipv4Address;
    /**
     * The ipv6Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ipv6Address;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LTvsCertificate
     * @uses LTvsCertificate::setSubjectName()
     * @uses LTvsCertificate::setIssuerName()
     * @uses LTvsCertificate::setSerialNumber()
     * @uses LTvsCertificate::setTimeToLive()
     * @uses LTvsCertificate::setIpv4Address()
     * @uses LTvsCertificate::setIpv6Address()
     * @uses LTvsCertificate::setUuid()
     * @param string $subjectName
     * @param string $issuerName
     * @param string $serialNumber
     * @param int $timeToLive
     * @param string $ipv4Address
     * @param string $ipv6Address
     * @param string $uuid
     */
    public function __construct($subjectName = null, $issuerName = null, $serialNumber = null, $timeToLive = null, $ipv4Address = null, $ipv6Address = null, $uuid = null)
    {
        $this
            ->setSubjectName($subjectName)
            ->setIssuerName($issuerName)
            ->setSerialNumber($serialNumber)
            ->setTimeToLive($timeToLive)
            ->setIpv4Address($ipv4Address)
            ->setIpv6Address($ipv6Address)
            ->setUuid($uuid);
    }
    /**
     * Get subjectName value
     * @return string|null
     */
    public function getSubjectName()
    {
        return $this->subjectName;
    }
    /**
     * Set subjectName value
     * @param string $subjectName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LTvsCertificate
     */
    public function setSubjectName($subjectName = null)
    {
        $this->subjectName = $subjectName;
        return $this;
    }
    /**
     * Get issuerName value
     * @return string|null
     */
    public function getIssuerName()
    {
        return $this->issuerName;
    }
    /**
     * Set issuerName value
     * @param string $issuerName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LTvsCertificate
     */
    public function setIssuerName($issuerName = null)
    {
        $this->issuerName = $issuerName;
        return $this;
    }
    /**
     * Get serialNumber value
     * @return string|null
     */
    public function getSerialNumber()
    {
        return $this->serialNumber;
    }
    /**
     * Set serialNumber value
     * @param string $serialNumber
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LTvsCertificate
     */
    public function setSerialNumber($serialNumber = null)
    {
        $this->serialNumber = $serialNumber;
        return $this;
    }
    /**
     * Get timeToLive value
     * @return int|null
     */
    public function getTimeToLive()
    {
        return $this->timeToLive;
    }
    /**
     * Set timeToLive value
     * @param int $timeToLive
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LTvsCertificate
     */
    public function setTimeToLive($timeToLive = null)
    {
        $this->timeToLive = $timeToLive;
        return $this;
    }
    /**
     * Get ipv4Address value
     * @return string|null
     */
    public function getIpv4Address()
    {
        return $this->ipv4Address;
    }
    /**
     * Set ipv4Address value
     * @param string $ipv4Address
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LTvsCertificate
     */
    public function setIpv4Address($ipv4Address = null)
    {
        $this->ipv4Address = $ipv4Address;
        return $this;
    }
    /**
     * Get ipv6Address value
     * @return string|null
     */
    public function getIpv6Address()
    {
        return $this->ipv6Address;
    }
    /**
     * Set ipv6Address value
     * @param string $ipv6Address
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LTvsCertificate
     */
    public function setIpv6Address($ipv6Address = null)
    {
        $this->ipv6Address = $ipv6Address;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LTvsCertificate
     */
    public function setUuid($uuid = null)
    {
        $this->uuid = $uuid;
        return $this;
    }
}
