<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LProcessNode StructType
 * @subpackage Structs
 */
class LProcessNode extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: The primary hostname of the process node.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The mac
     * Meta information extracted from the WSDL
     * - documentation: The mac address of the host.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]|[a-f]|[A-F]){12}
     * @var string
     */
    public $mac;
    /**
     * The ipv6Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ipv6Name;
    /**
     * The nodeUsage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $nodeUsage;
    /**
     * The lbmHubGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $lbmHubGroup;
    /**
     * The processNodeRole
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $processNodeRole;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LProcessNode
     * @uses LProcessNode::setName()
     * @uses LProcessNode::setDescription()
     * @uses LProcessNode::setMac()
     * @uses LProcessNode::setIpv6Name()
     * @uses LProcessNode::setNodeUsage()
     * @uses LProcessNode::setLbmHubGroup()
     * @uses LProcessNode::setProcessNodeRole()
     * @uses LProcessNode::setUuid()
     * @param string $name
     * @param string $description
     * @param string $mac
     * @param string $ipv6Name
     * @param string $nodeUsage
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $lbmHubGroup
     * @param string $processNodeRole
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $mac = null, $ipv6Name = null, $nodeUsage = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $lbmHubGroup = null, $processNodeRole = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setMac($mac)
            ->setIpv6Name($ipv6Name)
            ->setNodeUsage($nodeUsage)
            ->setLbmHubGroup($lbmHubGroup)
            ->setProcessNodeRole($processNodeRole)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LProcessNode
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LProcessNode
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get mac value
     * @return string|null
     */
    public function getMac()
    {
        return $this->mac;
    }
    /**
     * Set mac value
     * @param string $mac
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LProcessNode
     */
    public function setMac($mac = null)
    {
        $this->mac = $mac;
        return $this;
    }
    /**
     * Get ipv6Name value
     * @return string|null
     */
    public function getIpv6Name()
    {
        return $this->ipv6Name;
    }
    /**
     * Set ipv6Name value
     * @param string $ipv6Name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LProcessNode
     */
    public function setIpv6Name($ipv6Name = null)
    {
        $this->ipv6Name = $ipv6Name;
        return $this;
    }
    /**
     * Get nodeUsage value
     * @return string|null
     */
    public function getNodeUsage()
    {
        return $this->nodeUsage;
    }
    /**
     * Set nodeUsage value
     * @param string $nodeUsage
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LProcessNode
     */
    public function setNodeUsage($nodeUsage = null)
    {
        $this->nodeUsage = $nodeUsage;
        return $this;
    }
    /**
     * Get lbmHubGroup value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getLbmHubGroup()
    {
        return $this->lbmHubGroup;
    }
    /**
     * Set lbmHubGroup value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $lbmHubGroup
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LProcessNode
     */
    public function setLbmHubGroup(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $lbmHubGroup = null)
    {
        $this->lbmHubGroup = $lbmHubGroup;
        return $this;
    }
    /**
     * Get processNodeRole value
     * @return string|null
     */
    public function getProcessNodeRole()
    {
        return $this->processNodeRole;
    }
    /**
     * Set processNodeRole value
     * @param string $processNodeRole
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LProcessNode
     */
    public function setProcessNodeRole($processNodeRole = null)
    {
        $this->processNodeRole = $processNodeRole;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LProcessNode
     */
    public function setUuid($uuid = null)
    {
        $this->uuid = $uuid;
        return $this;
    }
}
