<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LMohServer StructType
 * @subpackage Structs
 */
class LMohServer extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The processNodeName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $processNodeName;
    /**
     * The devicePoolName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $devicePoolName;
    /**
     * The locationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $locationName;
    /**
     * The maxUnicastConnections
     * Meta information extracted from the WSDL
     * - documentation: Maximum Half Duplex Streams must be a number in the range 0 to 500.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $maxUnicastConnections;
    /**
     * The maxMulticastConnections
     * Meta information extracted from the WSDL
     * - documentation: Maximum Multicast Connections must be a number in the range 0 to 999999.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $maxMulticastConnections;
    /**
     * The fixedAudioSourceDevice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $fixedAudioSourceDevice;
    /**
     * The runFlag
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $runFlag;
    /**
     * The useTrustedRelayPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The isMultiCastEnabled
     * Meta information extracted from the WSDL
     * - documentation: If isMultiCastEnabled is false then these elements are not necessary.MOHServer will be added to the database without the values of these tags. ie. The table MOHServerMulticastInfo table will be empty. Multicast Base Port number must
     * be an even number in the range 16384 to 32766.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isMultiCastEnabled;
    /**
     * The baseMulticastIpaddress
     * Meta information extracted from the WSDL
     * - documentation: If isMultiCastEnabled is false then these elements are not necessary.MOHServer will be added to the database without the values of these tags. ie. The table MOHServerMulticastInfo table will be empty. Multicast Base Port number must
     * be an even number in the range 16384 to 32766. baseMulticastIPAddress and baseMulticastPort must be a unique pair. All Multicast IP Addresses must be in the range 239.1.1.1 to 239.255.255.255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $baseMulticastIpaddress;
    /**
     * The baseMulticastPort
     * Meta information extracted from the WSDL
     * - documentation: If isMultiCastEnabled is false then these elements are not necessary.MOHServer will be added to the database without the values of these tags. ie. The table MOHServerMulticastInfo table will be empty. Multicast Base Port number must
     * be an even number in the range 16384 to 32766
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $baseMulticastPort;
    /**
     * The multicastIncrementOnIp
     * Meta information extracted from the WSDL
     * - documentation: If isMultiCastEnabled is false then these elements are not necessary.MOHServer will be added to the database without the values of these tags. ie. The table MOHServerMulticastInfo table will be empty.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $multicastIncrementOnIp;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LMohServer
     * @uses LMohServer::setName()
     * @uses LMohServer::setDescription()
     * @uses LMohServer::setProcessNodeName()
     * @uses LMohServer::setDevicePoolName()
     * @uses LMohServer::setLocationName()
     * @uses LMohServer::setMaxUnicastConnections()
     * @uses LMohServer::setMaxMulticastConnections()
     * @uses LMohServer::setFixedAudioSourceDevice()
     * @uses LMohServer::setRunFlag()
     * @uses LMohServer::setUseTrustedRelayPoint()
     * @uses LMohServer::setIsMultiCastEnabled()
     * @uses LMohServer::setBaseMulticastIpaddress()
     * @uses LMohServer::setBaseMulticastPort()
     * @uses LMohServer::setMulticastIncrementOnIp()
     * @uses LMohServer::setUuid()
     * @param string $name
     * @param string $description
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $processNodeName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName
     * @param string $maxUnicastConnections
     * @param string $maxMulticastConnections
     * @param string $fixedAudioSourceDevice
     * @param string $runFlag
     * @param string $useTrustedRelayPoint
     * @param string $isMultiCastEnabled
     * @param string $baseMulticastIpaddress
     * @param string $baseMulticastPort
     * @param string $multicastIncrementOnIp
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $processNodeName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName = null, $maxUnicastConnections = null, $maxMulticastConnections = null, $fixedAudioSourceDevice = null, $runFlag = null, $useTrustedRelayPoint = null, $isMultiCastEnabled = null, $baseMulticastIpaddress = null, $baseMulticastPort = null, $multicastIncrementOnIp = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setProcessNodeName($processNodeName)
            ->setDevicePoolName($devicePoolName)
            ->setLocationName($locationName)
            ->setMaxUnicastConnections($maxUnicastConnections)
            ->setMaxMulticastConnections($maxMulticastConnections)
            ->setFixedAudioSourceDevice($fixedAudioSourceDevice)
            ->setRunFlag($runFlag)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setIsMultiCastEnabled($isMultiCastEnabled)
            ->setBaseMulticastIpaddress($baseMulticastIpaddress)
            ->setBaseMulticastPort($baseMulticastPort)
            ->setMulticastIncrementOnIp($multicastIncrementOnIp)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LMohServer
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LMohServer
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get processNodeName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getProcessNodeName()
    {
        return $this->processNodeName;
    }
    /**
     * Set processNodeName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $processNodeName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LMohServer
     */
    public function setProcessNodeName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $processNodeName = null)
    {
        $this->processNodeName = $processNodeName;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LMohServer
     */
    public function setDevicePoolName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get locationName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LMohServer
     */
    public function setLocationName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get maxUnicastConnections value
     * @return string|null
     */
    public function getMaxUnicastConnections()
    {
        return $this->maxUnicastConnections;
    }
    /**
     * Set maxUnicastConnections value
     * @param string $maxUnicastConnections
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LMohServer
     */
    public function setMaxUnicastConnections($maxUnicastConnections = null)
    {
        $this->maxUnicastConnections = $maxUnicastConnections;
        return $this;
    }
    /**
     * Get maxMulticastConnections value
     * @return string|null
     */
    public function getMaxMulticastConnections()
    {
        return $this->maxMulticastConnections;
    }
    /**
     * Set maxMulticastConnections value
     * @param string $maxMulticastConnections
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LMohServer
     */
    public function setMaxMulticastConnections($maxMulticastConnections = null)
    {
        $this->maxMulticastConnections = $maxMulticastConnections;
        return $this;
    }
    /**
     * Get fixedAudioSourceDevice value
     * @return string|null
     */
    public function getFixedAudioSourceDevice()
    {
        return $this->fixedAudioSourceDevice;
    }
    /**
     * Set fixedAudioSourceDevice value
     * @param string $fixedAudioSourceDevice
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LMohServer
     */
    public function setFixedAudioSourceDevice($fixedAudioSourceDevice = null)
    {
        $this->fixedAudioSourceDevice = $fixedAudioSourceDevice;
        return $this;
    }
    /**
     * Get runFlag value
     * @return string|null
     */
    public function getRunFlag()
    {
        return $this->runFlag;
    }
    /**
     * Set runFlag value
     * @param string $runFlag
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LMohServer
     */
    public function setRunFlag($runFlag = null)
    {
        $this->runFlag = $runFlag;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @param string $useTrustedRelayPoint
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LMohServer
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = null)
    {
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get isMultiCastEnabled value
     * @return string|null
     */
    public function getIsMultiCastEnabled()
    {
        return $this->isMultiCastEnabled;
    }
    /**
     * Set isMultiCastEnabled value
     * @param string $isMultiCastEnabled
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LMohServer
     */
    public function setIsMultiCastEnabled($isMultiCastEnabled = null)
    {
        $this->isMultiCastEnabled = $isMultiCastEnabled;
        return $this;
    }
    /**
     * Get baseMulticastIpaddress value
     * @return string|null
     */
    public function getBaseMulticastIpaddress()
    {
        return $this->baseMulticastIpaddress;
    }
    /**
     * Set baseMulticastIpaddress value
     * @param string $baseMulticastIpaddress
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LMohServer
     */
    public function setBaseMulticastIpaddress($baseMulticastIpaddress = null)
    {
        $this->baseMulticastIpaddress = $baseMulticastIpaddress;
        return $this;
    }
    /**
     * Get baseMulticastPort value
     * @return string|null
     */
    public function getBaseMulticastPort()
    {
        return $this->baseMulticastPort;
    }
    /**
     * Set baseMulticastPort value
     * @param string $baseMulticastPort
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LMohServer
     */
    public function setBaseMulticastPort($baseMulticastPort = null)
    {
        $this->baseMulticastPort = $baseMulticastPort;
        return $this;
    }
    /**
     * Get multicastIncrementOnIp value
     * @return string|null
     */
    public function getMulticastIncrementOnIp()
    {
        return $this->multicastIncrementOnIp;
    }
    /**
     * Set multicastIncrementOnIp value
     * @param string $multicastIncrementOnIp
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LMohServer
     */
    public function setMulticastIncrementOnIp($multicastIncrementOnIp = null)
    {
        $this->multicastIncrementOnIp = $multicastIncrementOnIp;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LMohServer
     */
    public function setUuid($uuid = null)
    {
        $this->uuid = $uuid;
        return $this;
    }
}
