<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LLdapDirectory StructType
 * @subpackage Structs
 */
class LLdapDirectory extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The ldapDn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ldapDn;
    /**
     * The userSearchBase
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userSearchBase;
    /**
     * The repeatable
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $repeatable;
    /**
     * The intervalValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $intervalValue;
    /**
     * The scheduleUnit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $scheduleUnit;
    /**
     * The nextExecTime
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 32
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $nextExecTime;
    /**
     * The accessControlGroupInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\AccessControlGroupInfo
     */
    public $accessControlGroupInfo;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LLdapDirectory
     * @uses LLdapDirectory::setName()
     * @uses LLdapDirectory::setLdapDn()
     * @uses LLdapDirectory::setUserSearchBase()
     * @uses LLdapDirectory::setRepeatable()
     * @uses LLdapDirectory::setIntervalValue()
     * @uses LLdapDirectory::setScheduleUnit()
     * @uses LLdapDirectory::setNextExecTime()
     * @uses LLdapDirectory::setAccessControlGroupInfo()
     * @uses LLdapDirectory::setUuid()
     * @param string $name
     * @param string $ldapDn
     * @param string $userSearchBase
     * @param string $repeatable
     * @param string $intervalValue
     * @param string $scheduleUnit
     * @param string $nextExecTime
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AccessControlGroupInfo $accessControlGroupInfo
     * @param string $uuid
     */
    public function __construct($name = null, $ldapDn = null, $userSearchBase = null, $repeatable = null, $intervalValue = null, $scheduleUnit = null, $nextExecTime = null, \\Losc\CucmBundle\Model\Webservice\StructType\AccessControlGroupInfo $accessControlGroupInfo = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setLdapDn($ldapDn)
            ->setUserSearchBase($userSearchBase)
            ->setRepeatable($repeatable)
            ->setIntervalValue($intervalValue)
            ->setScheduleUnit($scheduleUnit)
            ->setNextExecTime($nextExecTime)
            ->setAccessControlGroupInfo($accessControlGroupInfo)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LLdapDirectory
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get ldapDn value
     * @return string|null
     */
    public function getLdapDn()
    {
        return $this->ldapDn;
    }
    /**
     * Set ldapDn value
     * @param string $ldapDn
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LLdapDirectory
     */
    public function setLdapDn($ldapDn = null)
    {
        $this->ldapDn = $ldapDn;
        return $this;
    }
    /**
     * Get userSearchBase value
     * @return string|null
     */
    public function getUserSearchBase()
    {
        return $this->userSearchBase;
    }
    /**
     * Set userSearchBase value
     * @param string $userSearchBase
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LLdapDirectory
     */
    public function setUserSearchBase($userSearchBase = null)
    {
        $this->userSearchBase = $userSearchBase;
        return $this;
    }
    /**
     * Get repeatable value
     * @return string|null
     */
    public function getRepeatable()
    {
        return $this->repeatable;
    }
    /**
     * Set repeatable value
     * @param string $repeatable
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LLdapDirectory
     */
    public function setRepeatable($repeatable = null)
    {
        $this->repeatable = $repeatable;
        return $this;
    }
    /**
     * Get intervalValue value
     * @return string|null
     */
    public function getIntervalValue()
    {
        return $this->intervalValue;
    }
    /**
     * Set intervalValue value
     * @param string $intervalValue
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LLdapDirectory
     */
    public function setIntervalValue($intervalValue = null)
    {
        $this->intervalValue = $intervalValue;
        return $this;
    }
    /**
     * Get scheduleUnit value
     * @return string|null
     */
    public function getScheduleUnit()
    {
        return $this->scheduleUnit;
    }
    /**
     * Set scheduleUnit value
     * @param string $scheduleUnit
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LLdapDirectory
     */
    public function setScheduleUnit($scheduleUnit = null)
    {
        $this->scheduleUnit = $scheduleUnit;
        return $this;
    }
    /**
     * Get nextExecTime value
     * @return string|null
     */
    public function getNextExecTime()
    {
        return $this->nextExecTime;
    }
    /**
     * Set nextExecTime value
     * @param string $nextExecTime
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LLdapDirectory
     */
    public function setNextExecTime($nextExecTime = null)
    {
        $this->nextExecTime = $nextExecTime;
        return $this;
    }
    /**
     * Get accessControlGroupInfo value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\AccessControlGroupInfo|null
     */
    public function getAccessControlGroupInfo()
    {
        return $this->accessControlGroupInfo;
    }
    /**
     * Set accessControlGroupInfo value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\AccessControlGroupInfo $accessControlGroupInfo
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LLdapDirectory
     */
    public function setAccessControlGroupInfo(\\Losc\CucmBundle\Model\Webservice\StructType\AccessControlGroupInfo $accessControlGroupInfo = null)
    {
        $this->accessControlGroupInfo = $accessControlGroupInfo;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LLdapDirectory
     */
    public function setUuid($uuid = null)
    {
        $this->uuid = $uuid;
        return $this;
    }
}
