<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LImeClient StructType
 * @subpackage Structs
 */
class LImeClient extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The domain
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $domain;
    /**
     * The isActivated
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isActivated;
    /**
     * The sipTrunkName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $sipTrunkName;
    /**
     * The primaryImeServerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $primaryImeServerName;
    /**
     * The secondaryImeServerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $secondaryImeServerName;
    /**
     * The learnedRouteFilterGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $learnedRouteFilterGroupName;
    /**
     * The exclusionNumberGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $exclusionNumberGroupName;
    /**
     * The firewallName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $firewallName;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LImeClient
     * @uses LImeClient::setName()
     * @uses LImeClient::setDescription()
     * @uses LImeClient::setDomain()
     * @uses LImeClient::setIsActivated()
     * @uses LImeClient::setSipTrunkName()
     * @uses LImeClient::setPrimaryImeServerName()
     * @uses LImeClient::setSecondaryImeServerName()
     * @uses LImeClient::setLearnedRouteFilterGroupName()
     * @uses LImeClient::setExclusionNumberGroupName()
     * @uses LImeClient::setFirewallName()
     * @uses LImeClient::setUuid()
     * @param string $name
     * @param string $description
     * @param string $domain
     * @param string $isActivated
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipTrunkName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $primaryImeServerName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $secondaryImeServerName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $learnedRouteFilterGroupName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $exclusionNumberGroupName
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $firewallName
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $domain = null, $isActivated = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipTrunkName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $primaryImeServerName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $secondaryImeServerName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $learnedRouteFilterGroupName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $exclusionNumberGroupName = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $firewallName = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setDomain($domain)
            ->setIsActivated($isActivated)
            ->setSipTrunkName($sipTrunkName)
            ->setPrimaryImeServerName($primaryImeServerName)
            ->setSecondaryImeServerName($secondaryImeServerName)
            ->setLearnedRouteFilterGroupName($learnedRouteFilterGroupName)
            ->setExclusionNumberGroupName($exclusionNumberGroupName)
            ->setFirewallName($firewallName)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LImeClient
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LImeClient
     */
    public function setDescription($description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get domain value
     * @return string|null
     */
    public function getDomain()
    {
        return $this->domain;
    }
    /**
     * Set domain value
     * @param string $domain
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LImeClient
     */
    public function setDomain($domain = null)
    {
        $this->domain = $domain;
        return $this;
    }
    /**
     * Get isActivated value
     * @return string|null
     */
    public function getIsActivated()
    {
        return $this->isActivated;
    }
    /**
     * Set isActivated value
     * @param string $isActivated
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LImeClient
     */
    public function setIsActivated($isActivated = null)
    {
        $this->isActivated = $isActivated;
        return $this;
    }
    /**
     * Get sipTrunkName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSipTrunkName()
    {
        return $this->sipTrunkName;
    }
    /**
     * Set sipTrunkName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipTrunkName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LImeClient
     */
    public function setSipTrunkName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $sipTrunkName = null)
    {
        $this->sipTrunkName = $sipTrunkName;
        return $this;
    }
    /**
     * Get primaryImeServerName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getPrimaryImeServerName()
    {
        return $this->primaryImeServerName;
    }
    /**
     * Set primaryImeServerName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $primaryImeServerName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LImeClient
     */
    public function setPrimaryImeServerName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $primaryImeServerName = null)
    {
        $this->primaryImeServerName = $primaryImeServerName;
        return $this;
    }
    /**
     * Get secondaryImeServerName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getSecondaryImeServerName()
    {
        return $this->secondaryImeServerName;
    }
    /**
     * Set secondaryImeServerName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $secondaryImeServerName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LImeClient
     */
    public function setSecondaryImeServerName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $secondaryImeServerName = null)
    {
        $this->secondaryImeServerName = $secondaryImeServerName;
        return $this;
    }
    /**
     * Get learnedRouteFilterGroupName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getLearnedRouteFilterGroupName()
    {
        return $this->learnedRouteFilterGroupName;
    }
    /**
     * Set learnedRouteFilterGroupName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $learnedRouteFilterGroupName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LImeClient
     */
    public function setLearnedRouteFilterGroupName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $learnedRouteFilterGroupName = null)
    {
        $this->learnedRouteFilterGroupName = $learnedRouteFilterGroupName;
        return $this;
    }
    /**
     * Get exclusionNumberGroupName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getExclusionNumberGroupName()
    {
        return $this->exclusionNumberGroupName;
    }
    /**
     * Set exclusionNumberGroupName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $exclusionNumberGroupName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LImeClient
     */
    public function setExclusionNumberGroupName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $exclusionNumberGroupName = null)
    {
        $this->exclusionNumberGroupName = $exclusionNumberGroupName;
        return $this;
    }
    /**
     * Get firewallName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getFirewallName()
    {
        return $this->firewallName;
    }
    /**
     * Set firewallName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $firewallName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LImeClient
     */
    public function setFirewallName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $firewallName = null)
    {
        $this->firewallName = $firewallName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\LImeClient
     */
    public function setUuid($uuid = null)
    {
        $this->uuid = $uuid;
        return $this;
    }
}
