<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DoDeviceLoginReq StructType
 * Meta information extracted from the WSDL
 * - documentation: Logs-in the specified user to the specified phone.
 * @subpackage Structs
 */
class DoDeviceLoginReq extends APIRequest
{
    /**
     * The deviceName
     * Meta information extracted from the WSDL
     * - documentation: The name or uuid of the phone that is being logged-into. Not nullable.
     * - nillable: false
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $deviceName;
    /**
     * The loginDuration
     * Meta information extracted from the WSDL
     * - documentation: The duration of the login. Not nullable.
     * - nillable: false
     * @var int
     */
    public $loginDuration;
    /**
     * The profileName
     * Meta information extracted from the WSDL
     * - documentation: The name or uuid of the Device Profile to be used. Not nullable.
     * - nillable: false
     * @var \\Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $profileName;
    /**
     * The userId
     * Meta information extracted from the WSDL
     * - documentation: The LDAP RN of the user that is to be logged-into the phone. Not nullable.
     * - nillable: false
     * @var string
     */
    public $userId;
    /**
     * Constructor method for DoDeviceLoginReq
     * @uses DoDeviceLoginReq::setDeviceName()
     * @uses DoDeviceLoginReq::setLoginDuration()
     * @uses DoDeviceLoginReq::setProfileName()
     * @uses DoDeviceLoginReq::setUserId()
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $deviceName
     * @param int $loginDuration
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $profileName
     * @param string $userId
     */
    public function __construct(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $deviceName = null, $loginDuration = null, \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $profileName = null, $userId = null)
    {
        $this
            ->setDeviceName($deviceName)
            ->setLoginDuration($loginDuration)
            ->setProfileName($profileName)
            ->setUserId($userId);
    }
    /**
     * Get deviceName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getDeviceName()
    {
        return $this->deviceName;
    }
    /**
     * Set deviceName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $deviceName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\DoDeviceLoginReq
     */
    public function setDeviceName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $deviceName = null)
    {
        $this->deviceName = $deviceName;
        return $this;
    }
    /**
     * Get loginDuration value
     * @return int|null
     */
    public function getLoginDuration()
    {
        return $this->loginDuration;
    }
    /**
     * Set loginDuration value
     * @param int $loginDuration
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\DoDeviceLoginReq
     */
    public function setLoginDuration($loginDuration = null)
    {
        $this->loginDuration = $loginDuration;
        return $this;
    }
    /**
     * Get profileName value
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getProfileName()
    {
        return $this->profileName;
    }
    /**
     * Set profileName value
     * @param \\Losc\CucmBundle\Model\Webservice\StructType\XFkType $profileName
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\DoDeviceLoginReq
     */
    public function setProfileName(\\Losc\CucmBundle\Model\Webservice\StructType\XFkType $profileName = null)
    {
        $this->profileName = $profileName;
        return $this;
    }
    /**
     * Get userId value
     * @return string|null
     */
    public function getUserId()
    {
        return $this->userId;
    }
    /**
     * Set userId value
     * @param string $userId
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\DoDeviceLoginReq
     */
    public function setUserId($userId = null)
    {
        $this->userId = $userId;
        return $this;
    }
}
