<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DoChangeDNDStatusReq StructType
 * @subpackage Structs
 */
class DoChangeDNDStatusReq extends APIRequest
{
    /**
     * The dndStatus
     * Meta information extracted from the WSDL
     * - documentation: True means set dndStatus for device as true, false means set dndStatus for device as false
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $dndStatus;
    /**
     * The userID
     * Meta information extracted from the WSDL
     * - choice: userID | uuid
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - nillable: false
     * @var string
     */
    public $userID;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: userID | uuid
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - nillable: false
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for DoChangeDNDStatusReq
     * @uses DoChangeDNDStatusReq::setDndStatus()
     * @uses DoChangeDNDStatusReq::setUserID()
     * @uses DoChangeDNDStatusReq::setUuid()
     * @param string $dndStatus
     * @param string $userID
     * @param string $uuid
     */
    public function __construct($dndStatus = null, $userID = null, $uuid = null)
    {
        $this
            ->setDndStatus($dndStatus)
            ->setUserID($userID)
            ->setUuid($uuid);
    }
    /**
     * Get dndStatus value
     * @return string
     */
    public function getDndStatus()
    {
        return $this->dndStatus;
    }
    /**
     * Set dndStatus value
     * @param string $dndStatus
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\DoChangeDNDStatusReq
     */
    public function setDndStatus($dndStatus = null)
    {
        $this->dndStatus = $dndStatus;
        return $this;
    }
    /**
     * Get userID value
     * @return string|null
     */
    public function getUserID()
    {
        return isset($this->userID) ? $this->userID : null;
    }
    /**
     * Set userID value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $userID
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\DoChangeDNDStatusReq
     */
    public function setUserID($userID = null)
    {
        if (is_null($userID) || (is_array($userID) && empty($userID))) {
            unset($this->userID);
        } else {
            $this->userID = $userID;
        }
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return isset($this->uuid) ? $this->uuid : null;
    }
    /**
     * Set uuid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string $uuid
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\DoChangeDNDStatusReq
     */
    public function setUuid($uuid = null)
    {
        if (is_null($uuid) || (is_array($uuid) && empty($uuid))) {
            unset($this->uuid);
        } else {
            $this->uuid = $uuid;
        }
        return $this;
    }
}
