<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for associatedDevices StructType
 * Meta information extracted from the WSDL
 * - documentation: Read only | Also known as controlled devices.
 * @subpackage Structs
 */
class AssociatedDevices extends AbstractStructBase
{
    /**
     * The device
     * Meta information extracted from the WSDL
     * - documentation: Name of device.
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $device;
    /**
     * Constructor method for associatedDevices
     * @uses AssociatedDevices::setDevice()
     * @param string[] $device
     */
    public function __construct(array $device = array())
    {
        $this
            ->setDevice($device);
    }
    /**
     * Get device value
     * @return string[]|null
     */
    public function getDevice()
    {
        return $this->device;
    }
    /**
     * Set device value
     * @param string[] $device
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedDevices
     */
    public function setDevice(array $device = array())
    {
        $this->device = $device;
        return $this;
    }
    /**
     * Add item to device value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\AssociatedDevices
     */
    public function addToDevice($item)
    {
        $this->device[] = $item;
        return $this;
    }
}
