<?php

namespace \Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for addresses StructType
 * Meta information extracted from the WSDL
 * - documentation: Valid only for Cisco TelePresence Conference bridges
 * @subpackage Structs
 */
class Addresses extends AbstractStructBase
{
    /**
     * The address
     * Meta information extracted from the WSDL
     * - documentation: Valid only for Cisco TelePresence Conference bridges
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var string[]
     */
    public $address;
    /**
     * Constructor method for addresses
     * @uses Addresses::setAddress()
     * @param string[] $address
     */
    public function __construct(array $address = array())
    {
        $this
            ->setAddress($address);
    }
    /**
     * Get address value
     * @return string[]|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param string[] $address
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\Addresses
     */
    public function setAddress(array $address = array())
    {
        $this->address = $address;
        return $this;
    }
    /**
     * Add item to address value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \\Losc\CucmBundle\Model\Webservice\StructType\Addresses
     */
    public function addToAddress($item)
    {
        $this->address[] = $item;
        return $this;
    }
}
