<?php

namespace \Losc\CucmBundle\Model\Webservice\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for XUserAgentServerHeaderInfo EnumType
 * Meta information extracted from the WSDL
 * - union: string
 * @subpackage Enumerations
 */
class XUserAgentServerHeaderInfo extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Send Unified CM Version Information as User-Agent Header'
     * @return string 'Send Unified CM Version Information as User-Agent Header'
     */
    const VALUE_SEND_UNIFIED_CM_VERSION_INFORMATION_AS_USER_AGENT_HEADER = 'Send Unified CM Version Information as User-Agent Header';
    /**
     * Constant for value 'Pass Through Received Information as Contact Header
     * Parameters'
     * @return string 'Pass Through Received Information as Contact Header Parameters'
     */
    const VALUE_PASS_THROUGH_RECEIVED_INFORMATION_AS_CONTACT_HEADER_PARAMETERS = 'Pass Through Received Information as Contact Header Parameters';
    /**
     * Constant for value 'Pass Through Received Information as User-Agent and Server
     * Header'
     * @return string 'Pass Through Received Information as User-Agent and Server Header'
     */
    const VALUE_PASS_THROUGH_RECEIVED_INFORMATION_AS_USER_AGENT_AND_SERVER_HEADER = 'Pass Through Received Information as User-Agent and Server Header';
    /**
     * Return allowed values
     * @uses self::VALUE_SEND_UNIFIED_CM_VERSION_INFORMATION_AS_USER_AGENT_HEADER
     * @uses self::VALUE_PASS_THROUGH_RECEIVED_INFORMATION_AS_CONTACT_HEADER_PARAMETERS
     * @uses self::VALUE_PASS_THROUGH_RECEIVED_INFORMATION_AS_USER_AGENT_AND_SERVER_HEADER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SEND_UNIFIED_CM_VERSION_INFORMATION_AS_USER_AGENT_HEADER,
            self::VALUE_PASS_THROUGH_RECEIVED_INFORMATION_AS_CONTACT_HEADER_PARAMETERS,
            self::VALUE_PASS_THROUGH_RECEIVED_INFORMATION_AS_USER_AGENT_AND_SERVER_HEADER,
        );
    }
}
