<?php

namespace \Losc\CucmBundle\Model\Webservice\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for XURIDisambiguationPolicy EnumType
 * Meta information extracted from the WSDL
 * - union: string
 * @subpackage Enumerations
 */
class XURIDisambiguationPolicy extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Always treat all dial strings as URI addresses'
     * @return string 'Always treat all dial strings as URI addresses'
     */
    const VALUE_ALWAYS_TREAT_ALL_DIAL_STRINGS_AS_URI_ADDRESSES = 'Always treat all dial strings as URI addresses';
    /**
     * Constant for value 'Phone number consists of characters 0-9, A-D, *, #, and +
     * (others treated as URI addresses)'
     * @return string 'Phone number consists of characters 0-9, A-D, *, #, and + (others treated as URI addresses)'
     */
    const VALUE_PHONE_NUMBER_CONSISTS_OF_CHARACTERS_0_9_A_D_AND_OTHERS_TREATED_AS_URI_ADDRESSES = 'Phone number consists of characters 0-9, A-D, *, #, and + (others treated as URI addresses)';
    /**
     * Constant for value 'Phone number consists of characters 0-9, *, #, and + (others
     * treated as URI addresses)'
     * @return string 'Phone number consists of characters 0-9, *, #, and + (others treated as URI addresses)'
     */
    const VALUE_PHONE_NUMBER_CONSISTS_OF_CHARACTERS_0_9_AND_OTHERS_TREATED_AS_URI_ADDRESSES = 'Phone number consists of characters 0-9, *, #, and + (others treated as URI addresses)';
    /**
     * Return allowed values
     * @uses self::VALUE_ALWAYS_TREAT_ALL_DIAL_STRINGS_AS_URI_ADDRESSES
     * @uses self::VALUE_PHONE_NUMBER_CONSISTS_OF_CHARACTERS_0_9_A_D_AND_OTHERS_TREATED_AS_URI_ADDRESSES
     * @uses self::VALUE_PHONE_NUMBER_CONSISTS_OF_CHARACTERS_0_9_AND_OTHERS_TREATED_AS_URI_ADDRESSES
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALWAYS_TREAT_ALL_DIAL_STRINGS_AS_URI_ADDRESSES,
            self::VALUE_PHONE_NUMBER_CONSISTS_OF_CHARACTERS_0_9_A_D_AND_OTHERS_TREATED_AS_URI_ADDRESSES,
            self::VALUE_PHONE_NUMBER_CONSISTS_OF_CHARACTERS_0_9_AND_OTHERS_TREATED_AS_URI_ADDRESSES,
        );
    }
}
