<?php

namespace \Losc\CucmBundle\Model\Webservice\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for XLDAPDirectoryFunction EnumType
 * Meta information extracted from the WSDL
 * - union: string
 * @subpackage Enumerations
 */
class XLDAPDirectoryFunction extends AbstractStructEnumBase
{
    /**
     * Constant for value 'DirSync'
     * @return string 'DirSync'
     */
    const VALUE_DIR_SYNC = 'DirSync';
    /**
     * Constant for value 'DN Alias Sync and Lookup'
     * @return string 'DN Alias Sync and Lookup'
     */
    const VALUE_DN_ALIAS_SYNC_AND_LOOKUP = 'DN Alias Sync and Lookup';
    /**
     * Constant for value 'Alias Sync only'
     * @return string 'Alias Sync only'
     */
    const VALUE_ALIAS_SYNC_ONLY = 'Alias Sync only';
    /**
     * Constant for value 'Lookup only'
     * @return string 'Lookup only'
     */
    const VALUE_LOOKUP_ONLY = 'Lookup only';
    /**
     * Return allowed values
     * @uses self::VALUE_DIR_SYNC
     * @uses self::VALUE_DN_ALIAS_SYNC_AND_LOOKUP
     * @uses self::VALUE_ALIAS_SYNC_ONLY
     * @uses self::VALUE_LOOKUP_ONLY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DIR_SYNC,
            self::VALUE_DN_ALIAS_SYNC_AND_LOOKUP,
            self::VALUE_ALIAS_SYNC_ONLY,
            self::VALUE_LOOKUP_ONLY,
        );
    }
}
