<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XVg224 StructType
 * @subpackage Structs
 */
class XVg224 extends AbstractStructBase
{
    /**
     * The domainName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $domainName;
    /**
     * The product
     * Meta information extracted from the WSDL
     * - default: Cisco VG200
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $product;
    /**
     * The protocol
     * Meta information extracted from the WSDL
     * - default: MGCP
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $protocol;
    /**
     * The callManagerGroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $callManagerGroupName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The units
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\Units
     */
    public $units;
    /**
     * The vendorConfig
     * Meta information extracted from the WSDL
     * - documentation: It contains Product Specific Configuration Information like Fax mode, Modem Passthorugh, etc.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig
     */
    public $vendorConfig;
    /**
     * The versionStamp
     * Meta information extracted from the WSDL
     * - documentation: Read only. UUID that is changed each time the VG224 is updated.
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $versionStamp;
    /**
     * Constructor method for XVg224
     * @uses XVg224::setDomainName()
     * @uses XVg224::setProduct()
     * @uses XVg224::setProtocol()
     * @uses XVg224::setCallManagerGroupName()
     * @uses XVg224::setDescription()
     * @uses XVg224::setUnits()
     * @uses XVg224::setVendorConfig()
     * @uses XVg224::setVersionStamp()
     * @param string $domainName
     * @param string $product
     * @param string $protocol
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $callManagerGroupName
     * @param string $description
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Units $units
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig
     * @param string $versionStamp
     */
    public function __construct($domainName = null, $product = 'Cisco VG200', $protocol = 'MGCP', \Losc\CucmBundle\Model\Webservice\StructType\XFkType $callManagerGroupName = null, $description = null, \Losc\CucmBundle\Model\Webservice\StructType\Units $units = null, \Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig = null, $versionStamp = null)
    {
        $this
            ->setDomainName($domainName)
            ->setProduct($product)
            ->setProtocol($protocol)
            ->setCallManagerGroupName($callManagerGroupName)
            ->setDescription($description)
            ->setUnits($units)
            ->setVendorConfig($vendorConfig)
            ->setVersionStamp($versionStamp);
    }
    /**
     * Get domainName value
     * @return string
     */
    public function getDomainName()
    {
        return $this->domainName;
    }
    /**
     * Set domainName value
     * @param string $domainName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XVg224
     */
    public function setDomainName($domainName = null)
    {
        // validation for constraint: string
        if (!is_null($domainName) && !is_string($domainName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($domainName, true), gettype($domainName)), __LINE__);
        }
        $this->domainName = $domainName;
        return $this;
    }
    /**
     * Get product value
     * @return string
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XProduct::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XProduct::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XVg224
     */
    public function setProduct($product = 'Cisco VG200')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XProduct::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XProduct', is_array($product) ? implode(', ', $product) : var_export($product, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XProduct::getValidValues())), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get protocol value
     * @return string
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDeviceProtocol::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDeviceProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocol
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XVg224
     */
    public function setProtocol($protocol = 'MGCP')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XDeviceProtocol::valueIsValid($protocol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XDeviceProtocol', is_array($protocol) ? implode(', ', $protocol) : var_export($protocol, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XDeviceProtocol::getValidValues())), __LINE__);
        }
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get callManagerGroupName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getCallManagerGroupName()
    {
        return $this->callManagerGroupName;
    }
    /**
     * Set callManagerGroupName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $callManagerGroupName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XVg224
     */
    public function setCallManagerGroupName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $callManagerGroupName = null)
    {
        $this->callManagerGroupName = $callManagerGroupName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XVg224
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get units value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\Units|null
     */
    public function getUnits()
    {
        return $this->units;
    }
    /**
     * Set units value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Units $units
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XVg224
     */
    public function setUnits(\Losc\CucmBundle\Model\Webservice\StructType\Units $units = null)
    {
        $this->units = $units;
        return $this;
    }
    /**
     * Get vendorConfig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig|null
     */
    public function getVendorConfig()
    {
        return isset($this->vendorConfig) ? $this->vendorConfig : null;
    }
    /**
     * Set vendorConfig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XVg224
     */
    public function setVendorConfig(\Losc\CucmBundle\Model\Webservice\StructType\XVendorConfig $vendorConfig = null)
    {
        if (is_null($vendorConfig) || (is_array($vendorConfig) && empty($vendorConfig))) {
            unset($this->vendorConfig);
        } else {
            $this->vendorConfig = $vendorConfig;
        }
        return $this;
    }
    /**
     * Get versionStamp value
     * @return string|null
     */
    public function getVersionStamp()
    {
        return $this->versionStamp;
    }
    /**
     * Set versionStamp value
     * @param string $versionStamp
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XVg224
     */
    public function setVersionStamp($versionStamp = null)
    {
        // validation for constraint: string
        if (!is_null($versionStamp) && !is_string($versionStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($versionStamp, true), gettype($versionStamp)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($versionStamp) && mb_strlen($versionStamp) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($versionStamp)), __LINE__);
        }
        $this->versionStamp = $versionStamp;
        return $this;
    }
}
