<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XTodAccess StructType
 * @subpackage Structs
 */
class XTodAccess extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 128
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The ownerIdName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $ownerIdName;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The members
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Losc\CucmBundle\Model\Webservice\StructType\Members
     */
    public $members;
    /**
     * Constructor method for XTodAccess
     * @uses XTodAccess::setName()
     * @uses XTodAccess::setOwnerIdName()
     * @uses XTodAccess::setDescription()
     * @uses XTodAccess::setMembers()
     * @param string $name
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $ownerIdName
     * @param string $description
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Members $members
     */
    public function __construct($name = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $ownerIdName = null, $description = null, \Losc\CucmBundle\Model\Webservice\StructType\Members $members = null)
    {
        $this
            ->setName($name)
            ->setOwnerIdName($ownerIdName)
            ->setDescription($description)
            ->setMembers($members);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XTodAccess
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($name) && mb_strlen($name) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get ownerIdName value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public function getOwnerIdName()
    {
        return $this->ownerIdName;
    }
    /**
     * Set ownerIdName value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $ownerIdName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XTodAccess
     */
    public function setOwnerIdName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $ownerIdName = null)
    {
        $this->ownerIdName = $ownerIdName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XTodAccess
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($description) && mb_strlen($description) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get members value
     * @return \Losc\CucmBundle\Model\Webservice\StructType\Members|null
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param \Losc\CucmBundle\Model\Webservice\StructType\Members $members
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XTodAccess
     */
    public function setMembers(\Losc\CucmBundle\Model\Webservice\StructType\Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
}
