<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XTimePeriod StructType
 * @subpackage Structs
 */
class XTimePeriod extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The startTime
     * Meta information extracted from the WSDL
     * - default: No Office Hours
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $startTime;
    /**
     * The endTime
     * Meta information extracted from the WSDL
     * - default: No Office Hours
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $endTime;
    /**
     * The startDay
     * Meta information extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $startDay;
    /**
     * The endDay
     * Meta information extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $endDay;
    /**
     * The monthOfYear
     * Meta information extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $monthOfYear;
    /**
     * The dayOfMonth
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $dayOfMonth;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The isPublished
     * Meta information extracted from the WSDL
     * - documentation: TimePeriod cannot be published if it has a todOwnerId assigned to it. Only Administrative Time Period can be published.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isPublished;
    /**
     * The todOwnerIdName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \Losc\CucmBundle\Model\Webservice\StructType\XFkType
     */
    public $todOwnerIdName;
    /**
     * The dayOfMonthEnd
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $dayOfMonthEnd;
    /**
     * The monthOfYearEnd
     * Meta information extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $monthOfYearEnd;
    /**
     * Constructor method for XTimePeriod
     * @uses XTimePeriod::setName()
     * @uses XTimePeriod::setStartTime()
     * @uses XTimePeriod::setEndTime()
     * @uses XTimePeriod::setStartDay()
     * @uses XTimePeriod::setEndDay()
     * @uses XTimePeriod::setMonthOfYear()
     * @uses XTimePeriod::setDayOfMonth()
     * @uses XTimePeriod::setDescription()
     * @uses XTimePeriod::setIsPublished()
     * @uses XTimePeriod::setTodOwnerIdName()
     * @uses XTimePeriod::setDayOfMonthEnd()
     * @uses XTimePeriod::setMonthOfYearEnd()
     * @param string $name
     * @param string $startTime
     * @param string $endTime
     * @param string $startDay
     * @param string $endDay
     * @param string $monthOfYear
     * @param string $dayOfMonth
     * @param string $description
     * @param string $isPublished
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $todOwnerIdName
     * @param string $dayOfMonthEnd
     * @param string $monthOfYearEnd
     */
    public function __construct($name = null, $startTime = 'No Office Hours', $endTime = 'No Office Hours', $startDay = 'None', $endDay = 'None', $monthOfYear = 'None', $dayOfMonth = '0', $description = null, $isPublished = null, \Losc\CucmBundle\Model\Webservice\StructType\XFkType $todOwnerIdName = null, $dayOfMonthEnd = '0', $monthOfYearEnd = 'None')
    {
        $this
            ->setName($name)
            ->setStartTime($startTime)
            ->setEndTime($endTime)
            ->setStartDay($startDay)
            ->setEndDay($endDay)
            ->setMonthOfYear($monthOfYear)
            ->setDayOfMonth($dayOfMonth)
            ->setDescription($description)
            ->setIsPublished($isPublished)
            ->setTodOwnerIdName($todOwnerIdName)
            ->setDayOfMonthEnd($dayOfMonthEnd)
            ->setMonthOfYearEnd($monthOfYearEnd);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XTimePeriod
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name) && mb_strlen($name) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get startTime value
     * @return string|null
     */
    public function getStartTime()
    {
        return $this->startTime;
    }
    /**
     * Set startTime value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XTimeOfDay::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XTimeOfDay::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $startTime
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XTimePeriod
     */
    public function setStartTime($startTime = 'No Office Hours')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XTimeOfDay::valueIsValid($startTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XTimeOfDay', is_array($startTime) ? implode(', ', $startTime) : var_export($startTime, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XTimeOfDay::getValidValues())), __LINE__);
        }
        $this->startTime = $startTime;
        return $this;
    }
    /**
     * Get endTime value
     * @return string|null
     */
    public function getEndTime()
    {
        return $this->endTime;
    }
    /**
     * Set endTime value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XTimeOfDay::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XTimeOfDay::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $endTime
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XTimePeriod
     */
    public function setEndTime($endTime = 'No Office Hours')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XTimeOfDay::valueIsValid($endTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XTimeOfDay', is_array($endTime) ? implode(', ', $endTime) : var_export($endTime, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XTimeOfDay::getValidValues())), __LINE__);
        }
        $this->endTime = $endTime;
        return $this;
    }
    /**
     * Get startDay value
     * @return string|null
     */
    public function getStartDay()
    {
        return $this->startDay;
    }
    /**
     * Set startDay value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDayOfWeek::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDayOfWeek::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $startDay
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XTimePeriod
     */
    public function setStartDay($startDay = 'None')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XDayOfWeek::valueIsValid($startDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XDayOfWeek', is_array($startDay) ? implode(', ', $startDay) : var_export($startDay, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XDayOfWeek::getValidValues())), __LINE__);
        }
        $this->startDay = $startDay;
        return $this;
    }
    /**
     * Get endDay value
     * @return string|null
     */
    public function getEndDay()
    {
        return $this->endDay;
    }
    /**
     * Set endDay value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDayOfWeek::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XDayOfWeek::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $endDay
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XTimePeriod
     */
    public function setEndDay($endDay = 'None')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XDayOfWeek::valueIsValid($endDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XDayOfWeek', is_array($endDay) ? implode(', ', $endDay) : var_export($endDay, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XDayOfWeek::getValidValues())), __LINE__);
        }
        $this->endDay = $endDay;
        return $this;
    }
    /**
     * Get monthOfYear value
     * @return string|null
     */
    public function getMonthOfYear()
    {
        return $this->monthOfYear;
    }
    /**
     * Set monthOfYear value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XMonthOfYear::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XMonthOfYear::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $monthOfYear
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XTimePeriod
     */
    public function setMonthOfYear($monthOfYear = 'None')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XMonthOfYear::valueIsValid($monthOfYear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XMonthOfYear', is_array($monthOfYear) ? implode(', ', $monthOfYear) : var_export($monthOfYear, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XMonthOfYear::getValidValues())), __LINE__);
        }
        $this->monthOfYear = $monthOfYear;
        return $this;
    }
    /**
     * Get dayOfMonth value
     * @return string|null
     */
    public function getDayOfMonth()
    {
        return $this->dayOfMonth;
    }
    /**
     * Set dayOfMonth value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dayOfMonth
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XTimePeriod
     */
    public function setDayOfMonth($dayOfMonth = '0')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($dayOfMonth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($dayOfMonth) ? implode(', ', $dayOfMonth) : var_export($dayOfMonth, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->dayOfMonth = $dayOfMonth;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XTimePeriod
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($description) && mb_strlen($description) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get isPublished value
     * @return string|null
     */
    public function getIsPublished()
    {
        return $this->isPublished;
    }
    /**
     * Set isPublished value
     * @param string $isPublished
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XTimePeriod
     */
    public function setIsPublished($isPublished = null)
    {
        // validation for constraint: string
        if (!is_null($isPublished) && !is_string($isPublished)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isPublished, true), gettype($isPublished)), __LINE__);
        }
        // validation for constraint: pattern((t)|(f)|(true)|(false)|(0)|(1))
        if (!is_null($isPublished) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isPublished)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (t)|(f)|(true)|(false)|(0)|(1)', var_export($isPublished, true)), __LINE__);
        }
        $this->isPublished = $isPublished;
        return $this;
    }
    /**
     * Get todOwnerIdName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XFkType|null
     */
    public function getTodOwnerIdName()
    {
        return isset($this->todOwnerIdName) ? $this->todOwnerIdName : null;
    }
    /**
     * Set todOwnerIdName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Losc\CucmBundle\Model\Webservice\StructType\XFkType $todOwnerIdName
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XTimePeriod
     */
    public function setTodOwnerIdName(\Losc\CucmBundle\Model\Webservice\StructType\XFkType $todOwnerIdName = null)
    {
        if (is_null($todOwnerIdName) || (is_array($todOwnerIdName) && empty($todOwnerIdName))) {
            unset($this->todOwnerIdName);
        } else {
            $this->todOwnerIdName = $todOwnerIdName;
        }
        return $this;
    }
    /**
     * Get dayOfMonthEnd value
     * @return string|null
     */
    public function getDayOfMonthEnd()
    {
        return $this->dayOfMonthEnd;
    }
    /**
     * Set dayOfMonthEnd value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dayOfMonthEnd
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XTimePeriod
     */
    public function setDayOfMonthEnd($dayOfMonthEnd = '0')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($dayOfMonthEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($dayOfMonthEnd) ? implode(', ', $dayOfMonthEnd) : var_export($dayOfMonthEnd, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->dayOfMonthEnd = $dayOfMonthEnd;
        return $this;
    }
    /**
     * Get monthOfYearEnd value
     * @return string|null
     */
    public function getMonthOfYearEnd()
    {
        return $this->monthOfYearEnd;
    }
    /**
     * Set monthOfYearEnd value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XMonthOfYear::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XMonthOfYear::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $monthOfYearEnd
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XTimePeriod
     */
    public function setMonthOfYearEnd($monthOfYearEnd = 'None')
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XMonthOfYear::valueIsValid($monthOfYearEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XMonthOfYear', is_array($monthOfYearEnd) ? implode(', ', $monthOfYearEnd) : var_export($monthOfYearEnd, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XMonthOfYear::getValidValues())), __LINE__);
        }
        $this->monthOfYearEnd = $monthOfYearEnd;
        return $this;
    }
}
