<?php

namespace Losc\CucmBundle\Model\Webservice\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XSpeeddial StructType
 * @subpackage Structs
 */
class XSpeeddial extends AbstractStructBase
{
    /**
     * The dirn
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $dirn;
    /**
     * The label
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $label;
    /**
     * The index
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $index;
    /**
     * Constructor method for XSpeeddial
     * @uses XSpeeddial::setDirn()
     * @uses XSpeeddial::setLabel()
     * @uses XSpeeddial::setIndex()
     * @param string $dirn
     * @param string $label
     * @param string $index
     */
    public function __construct($dirn = null, $label = null, $index = null)
    {
        $this
            ->setDirn($dirn)
            ->setLabel($label)
            ->setIndex($index);
    }
    /**
     * Get dirn value
     * @return string
     */
    public function getDirn()
    {
        return $this->dirn;
    }
    /**
     * Set dirn value
     * @param string $dirn
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XSpeeddial
     */
    public function setDirn($dirn = null)
    {
        // validation for constraint: string
        if (!is_null($dirn) && !is_string($dirn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dirn, true), gettype($dirn)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($dirn) && mb_strlen($dirn) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($dirn)), __LINE__);
        }
        $this->dirn = $dirn;
        return $this;
    }
    /**
     * Get label value
     * @return string
     */
    public function getLabel()
    {
        return $this->label;
    }
    /**
     * Set label value
     * @param string $label
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XSpeeddial
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($label, true), gettype($label)), __LINE__);
        }
        $this->label = $label;
        return $this;
    }
    /**
     * Get index value
     * @return string
     */
    public function getIndex()
    {
        return $this->index;
    }
    /**
     * Set index value
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid()
     * @uses \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $index
     * @return \Losc\CucmBundle\Model\Webservice\StructType\XSpeeddial
     */
    public function setIndex($index = null)
    {
        // validation for constraint: enumeration
        if (!\Losc\CucmBundle\Model\Webservice\EnumType\XInteger::valueIsValid($index)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Losc\CucmBundle\Model\Webservice\EnumType\XInteger', is_array($index) ? implode(', ', $index) : var_export($index, true), implode(', ', \Losc\CucmBundle\Model\Webservice\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->index = $index;
        return $this;
    }
}
